/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.diskanalyze.worktaker.impl;

import com.huawei.ism.tool.base.utils.CallbackPackageSnMappingUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.OSCmdUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.diskanalyze.analyze.AnalyzeThread;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDevice;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeDisk;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeItemResult;
import com.huawei.ism.tool.diskanalyze.entity.AnalyzeSummary;
import com.huawei.ism.tool.diskanalyze.entity.ZTreeNode;
import com.huawei.ism.tool.diskanalyze.rule.logic.CommonCheckLogic;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeConstants;
import com.huawei.ism.tool.diskanalyze.util.DiskAnalyzeContext;
import com.huawei.ism.tool.diskanalyze.util.DiskHealthAssistant;
import com.huawei.ism.tool.diskanalyze.worktaker.IReportWorktaker;
import com.huawei.ism.tool.diskanalyze.worktaker.impl.ComparatorByFields;
import com.huawei.ism.tool.diskanalyze.worktaker.impl.ExcelResultBuilder;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.platform.worktaker.AbstractWorktaker;
import com.huawei.ism.tool.framework.pubservice.entity.DevNode;
import com.huawei.json.JSONArray;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JDialog;
import org.slf4j.Logger;
import utils.FilesUtil;

public class ReportWorktakerImpl
extends AbstractWorktaker
implements IReportWorktaker {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ReportWorktakerImpl.class);
    protected DiskAnalyzeContext context = DiskAnalyzeContext.getInstance();
    protected String configHtmlPath = "config/diskanalyze/html/zh";
    protected String[] htmlFileNameArray = new String[]{"index.html", "left.html", "front.html", "summary.html"};
    protected String[] imageFileNameArray = new String[]{"detail_top.png", "front_bottom.png", "front_top.png", "summary_top.png", "logo.png"};
    protected String[] cssFileNameArray = new String[]{"metroStyle.css", "common.css", "img/line_conn.png", "img/loading.gif", "img/metro.gif", "img/metro.png"};
    protected String[] jsFileNameArray = new String[]{"jquery.min.js", "jquery.ztree.all.min.js"};
    protected Map<String, String> oldPathMap = new HashMap<String, String>();
    protected Map<String, String> newPathMap = new HashMap<String, String>();
    protected List<String> argList = new ArrayList<String>();
    protected Map<String, String> idMap = new HashMap<String, String>();

    @Override
    public void buildReport() {
        Locale locale = LanguageManager.getInstance().getCurrentLanguage();
        this.configHtmlPath = locale.equals(Locale.ENGLISH) ? "config/diskanalyze/html/en" : "config/diskanalyze/html/zh";
        this.delOldHtmlFiles(DiskAnalyzeConstants.HTML_FILE_PATH);
        this.buildDeviceMap();
        this.addStaticFiles();
        this.buildLeftPage();
        this.buildFrontPage();
        this.buildSummaryPage();
        for (String string : this.context.getDeviceList()) {
            AnalyzeDevice device = this.context.getDeviceById(string);
            this.buildDetailPage(device);
        }
        StringBuilder sb = new StringBuilder("deviceSN=");
        for (String deviceId : this.context.getDeviceList()) {
            AnalyzeDevice device = this.context.getDeviceById(deviceId);
            sb.append("${" + device.getDeviceInfo().getDeviceSerialNumber() + "},");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(System.lineSeparator()).append("fileCreateTime=" + System.currentTimeMillis()).append(System.lineSeparator());
        this.buildPkgInfo(sb.toString());
        try {
            ExcelResultBuilder excelResultBuilder = new ExcelResultBuilder();
            excelResultBuilder.buildTittle();
            for (String deviceId : this.context.getDeviceList()) {
                AnalyzeDevice device = this.context.getDeviceById(deviceId);
                excelResultBuilder.buildSummary(device);
            }
            excelResultBuilder.writeExcel(DiskAnalyzeConstants.REPORT_TEMP_PATH);
        }
        catch (Exception exception) {
            LOGGER.error("build excel error.", (Throwable)exception);
        }
        if (DiskAnalyzeContext.getInstance().isScene()) {
            this.putSenceReport();
        }
    }

    protected void buildPkgInfo(String info) {
        File file = new File(DiskAnalyzeConstants.REPORT_TEMP_PATH);
        if (!file.exists()) {
            LOGGER.info("build pkgInfo failed!");
            return;
        }
        File pkginfoDir = new File(DiskAnalyzeConstants.PKGINFODIR);
        File typefile = new File(DiskAnalyzeConstants.TYPE_FILE);
        File domain = new File(DiskAnalyzeConstants.DOMAIN);
        File desc = new File(DiskAnalyzeConstants.DESC);
        try {
            if (!pkginfoDir.exists() && !pkginfoDir.mkdir()) {
                LOGGER.info("build pkgInfo failed!");
                return;
            }
            if (!typefile.exists() && !typefile.createNewFile()) {
                LOGGER.info("build type_file failed!");
            }
            if (!domain.exists() && !domain.createNewFile()) {
                LOGGER.info("build domain failed!");
            }
            this.writeInfoToFile(info, desc);
        }
        catch (IOException e) {
            LOGGER.error("build pkgInfo failed!" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInfoToFile(String info, File file) {
        block5: {
            OutputStreamWriter osWriter = null;
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(file);
                osWriter = new OutputStreamWriter((OutputStream)out, "UTF-8");
                osWriter.append(info);
                osWriter.flush();
                StreamUtils.closeResource(null, (Closeable)osWriter);
            }
            catch (IOException e) {
                LOGGER.error("Summary page append failed.");
                break block5;
            }
            finally {
                StreamUtils.closeResource(null, osWriter);
                StreamUtils.closeResource(null, (Closeable)out);
            }
            StreamUtils.closeResource(null, (Closeable)out);
        }
    }

    protected void putSenceReport() {
        Date date = new Date();
        StringBuilder reportPath = new StringBuilder();
        reportPath.append(DiskAnalyzeContext.getInstance().getSceneDir());
        reportPath.append(File.separator);
        reportPath.append("DiskHealthReport");
        reportPath.append('_');
        reportPath.append(date.getTime());
        reportPath.append('.');
        reportPath.append("zip");
        this.exportReport(new File(reportPath.toString()));
    }

    @Override
    public boolean exportReport(File file) {
        StringBuffer srcFilePath = new StringBuffer();
        srcFilePath.append(ApplicationContext.getInstance().getWorkPath());
        srcFilePath.append(File.separator);
        srcFilePath.append(ApplicationContext.getInstance().getTmpPath());
        srcFilePath.append(File.separator);
        srcFilePath.append("report");
        String filePath = "";
        try {
            filePath = file.getCanonicalPath();
        }
        catch (Exception e) {
            LOGGER.error("get path error.", (Throwable)e);
            return false;
        }
        boolean result = ZipUtils.compressFile((String)filePath, (String)srcFilePath.toString());
        if (result) {
            FileUtils.setFilePermissions((File)file);
        }
        try {
            if (DiskHealthAssistant.checkUploadRight()) {
                DiskAnalyzeContext analyzeContext = DiskAnalyzeContext.getInstance();
                List<AnalyzeDevice> list = DiskAnalyzeContext.getInstance().getSelectAnalyzeDeviceList(analyzeContext.getSelectDeviceUUID());
                ArrayList<DevNode> nodeList = new ArrayList<DevNode>(list.size());
                for (AnalyzeDevice analyzeDevice : list) {
                    nodeList.add(analyzeDevice.getDeviceInfo());
                }
                if (!CallbackPackageSnMappingUtils.recordToolPackageSnMapping((String)"diskanalyze", nodeList, (String)filePath)) {
                    LOGGER.error("write file sn failed.");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("write file sn failed.");
        }
        LOGGER.info(String.format(Locale.ENGLISH, "compress file result is: %s", result));
        return result;
    }

    @Override
    public void getReport(JDialog parent) {
        StringBuffer pathname = new StringBuffer();
        pathname.append(DiskAnalyzeConstants.HTML_FILE_PATH);
        pathname.append(File.separator);
        pathname.append("index.html");
        OSCmdUtils.explorerFile((String)pathname.toString());
    }

    protected String buildHtmlString(String htmlFilePath, List<String> argStrList, boolean isReadFromCls) {
        if (isReadFromCls) {
            return this.readHtmlFromClass(htmlFilePath, argStrList);
        }
        return this.readHtmlFromFile(htmlFilePath, argStrList);
    }

    /*
     * Exception decompiling
     */
    private String readHtmlFromFile(String htmlFilePath, List<String> argStrList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private String readHtmlFromClass(String htmlFilePath, List<String> argStrList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String readHtmlString(List<String> argStrList, BufferedReader brFileContent) throws IOException {
        StringBuilder sbFileContent = new StringBuilder();
        String strLine = null;
        while ((strLine = brFileContent.readLine()) != null) {
            sbFileContent.append(strLine).append('\n');
        }
        String strFileContent = sbFileContent.toString();
        return this.replaceElement(strFileContent, argStrList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buildHtmlFile(String htmlFilePath, List<String> argStrList) {
        block5: {
            OutputStreamWriter osWriter = null;
            FileOutputStream out = null;
            try {
                String strHtmlContent = this.buildHtmlString(htmlFilePath, argStrList, false);
                out = new FileOutputStream(new File(htmlFilePath));
                osWriter = new OutputStreamWriter((OutputStream)out, "UTF-8");
                osWriter.append(strHtmlContent);
                osWriter.flush();
                StreamUtils.closeResource(null, (Closeable)osWriter);
            }
            catch (IOException e) {
                LOGGER.error("Summary page append failed.");
                break block5;
            }
            finally {
                StreamUtils.closeResource(null, osWriter);
                StreamUtils.closeResource(null, out);
            }
            StreamUtils.closeResource(null, (Closeable)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyFile(String oldFileName, String newFileName) {
        StringBuilder sbOldPath = new StringBuilder();
        sbOldPath.append(this.oldPathMap.get(oldFileName));
        sbOldPath.append('/');
        sbOldPath.append(oldFileName);
        StringBuilder sbNewPath = new StringBuilder();
        sbNewPath.append(this.newPathMap.get(newFileName));
        sbNewPath.append(File.separator);
        sbNewPath.append(newFileName);
        LOGGER.info(String.format(Locale.ENGLISH, "Old file path: %s", sbOldPath.toString()));
        LOGGER.info(String.format(Locale.ENGLISH, "New file path: %s", sbNewPath.toString()));
        InputStream inputStream = null;
        FileOutputStream fileOutStream = null;
        try {
            File parent = new File(sbNewPath.toString()).getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                LOGGER.warn("{} dir is not exist.", (Object)FilesUtil.getCanonicalPath(parent));
                StreamUtils.closeStream(fileOutStream, (InputStream)inputStream);
                return;
            }
            int byteread = 0;
            inputStream = FileUtils.getStreamWithObj(ReportWorktakerImpl.class, (String)sbOldPath.toString());
            if (inputStream != null) {
                fileOutStream = new FileOutputStream(sbNewPath.toString());
                byte[] buffer = new byte[1444];
                while ((byteread = inputStream.read(buffer)) != -1) {
                    fileOutStream.write(buffer, 0, byteread);
                }
                LOGGER.info("Copy file successed.");
            }
            StreamUtils.closeStream(fileOutStream, (InputStream)inputStream);
        }
        catch (IOException e) {
            LOGGER.error("Copy file failed.");
        }
        finally {
            StreamUtils.closeStream(fileOutStream, inputStream);
        }
    }

    protected Map<String, Map<String, AnalyzeDevice>> buildDeviceMap() {
        HashMap<String, Map<String, AnalyzeDevice>> deviceMap = new HashMap<String, Map<String, AnalyzeDevice>>();
        for (String deviceID : this.context.getDeviceList()) {
            AnalyzeDevice device = DiskAnalyzeContext.getInstance().getDeviceById(deviceID);
            if (device == null) continue;
            String key = device.getDeviceInfo().getDeviceType() + " " + device.getDeviceInfo().getProductVersion();
            HashMap<String, AnalyzeDevice> map = (HashMap<String, AnalyzeDevice>)deviceMap.get(key);
            if (null == map) {
                map = new HashMap<String, AnalyzeDevice>();
                map.put(device.getUuid(), device);
                deviceMap.put(key, map);
            }
            map.put(device.getUuid(), device);
        }
        return deviceMap;
    }

    protected String replaceElement(String str, List<String> argStrList) {
        String strRet = str;
        try {
            for (int i = 0; i < argStrList.size(); ++i) {
                String prefix = "{" + i + "}";
                strRet = strRet.replace(prefix, argStrList.get(i));
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("strRet replace is failed");
        }
        return strRet;
    }

    protected void buildLeftPage() {
        Map<String, Map<String, AnalyzeDevice>> deviceMap = this.buildDeviceMap();
        JSONArray zTreeNodes = new JSONArray();
        ZTreeNode coverNode = new ZTreeNode(ResourceUtil.getString((String)"report.corver")).setUrl("front.html").setOpen(true);
        ZTreeNode summaryNode = new ZTreeNode(ResourceUtil.getString((String)"report.summary")).setUrl("summary.html");
        zTreeNodes.put((Object)coverNode).put((Object)summaryNode);
        ArrayList typeNodeList = new ArrayList();
        deviceMap.forEach((type, devices) -> {
            ZTreeNode typeNode = this.buildTypeNode((String)type);
            typeNodeList.add(typeNode);
            devices.forEach((uuid, device) -> {
                typeNode.addChildren(this.buildNode((AnalyzeDevice)device, (String)uuid));
                this.idMap.put(device.getDeviceInfo().getDeviceSerialNumber(), (String)uuid);
            });
        });
        typeNodeList.forEach(typeNode -> zTreeNodes.put(typeNode));
        StringBuilder sbLeftPath = new StringBuilder();
        sbLeftPath.append(DiskAnalyzeConstants.HTML_FILE_PATH);
        sbLeftPath.append(File.separator);
        sbLeftPath.append("left.html");
        this.argList.clear();
        this.argList.add(zTreeNodes.toString());
        this.buildHtmlFile(sbLeftPath.toString(), this.argList);
    }

    private ZTreeNode buildTypeNode(String typeKey) {
        return new ZTreeNode(typeKey).setParent(true);
    }

    private ZTreeNode buildNode(AnalyzeDevice device, String uuid) {
        return new ZTreeNode(device.getDeviceInfo().getDeviceSerialNumber()).setUrl(uuid + ".html");
    }

    protected void buildDetailPage(AnalyzeDevice device) {
        DevNode node = device.getDeviceInfo();
        List<AnalyzeDisk> diskList = device.getDiskList();
        diskList = this.sortByFields(diskList);
        StringBuilder sbScoreContent = this.buildScorePage(diskList);
        StringBuilder sbDiskList = new StringBuilder();
        this.getdiskList(diskList, sbDiskList);
        StringBuilder sbFileName = new StringBuilder();
        sbFileName.append(device.getUuid());
        sbFileName.append(".html");
        this.oldPathMap.put("detail.html", this.configHtmlPath);
        this.newPathMap.put(sbFileName.toString(), DiskAnalyzeConstants.HTML_FILE_PATH);
        this.copyFile("detail.html", sbFileName.toString());
        StringBuilder sbDetailPath = new StringBuilder();
        sbDetailPath.append(DiskAnalyzeConstants.HTML_FILE_PATH);
        sbDetailPath.append(File.separator);
        sbDetailPath.append((CharSequence)sbFileName);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        this.prepareParam(device, node, sbScoreContent, sbDiskList, df);
        this.buildHtmlFile(sbDetailPath.toString(), this.argList);
    }

    private void prepareParam(AnalyzeDevice device, DevNode node, StringBuilder sbScoreContent, StringBuilder sbDiskList, SimpleDateFormat df) {
        this.argList.clear();
        this.argList.add(node.getDeviceSerialNumber());
        this.argList.add(node.getDeviceType().toString());
        this.argList.add(DiskAnalyzeContext.getInstance().getDevVersionWithoutSPC(node.getProductVersion()));
        this.argList.add(node.getDeviceName());
        this.argList.add(node.getIp());
        this.argList.add(node.getDeviceSerialNumber());
        this.argList.add(String.valueOf(device.getDiskList().size()));
        this.argList.add(String.valueOf(device.getRiskDiskList().size()));
        this.argList.add(sbScoreContent.toString());
        this.argList.add(sbDiskList.toString());
        Date date = device.getPackageDate();
        this.argList.add(null != date ? df.format(date) : "");
        this.argList.add(String.valueOf(device.getCollectDiskNum()));
        Map<String, String> promptMap = CommonCheckLogic.getInstance().getPromptMap();
        this.argList.add(ResourceUtil.getString((String)("diskhealthanalyze.change.prompt." + promptMap.getOrDefault(node.getDeviceType().toString(), "default"))));
    }

    private void getdiskList(List<AnalyzeDisk> diskList, StringBuilder sbDiskList) {
        for (AnalyzeDisk disk : diskList) {
            int score = disk.getScore();
            this.argList.clear();
            this.argList.add(disk.getBgColor());
            this.argList.add(disk.getEnclosureNo());
            this.argList.add(disk.getSlotNo());
            this.argList.add(disk.getShowDiskType());
            this.argList.add(disk.getVender());
            this.argList.add(disk.getModel());
            this.argList.add(disk.getFirmwareVersion());
            this.argList.add(disk.getSn() + "_" + disk.getSn());
            this.argList.add(disk.getSn());
            this.argList.add(String.valueOf(-1 == score ? "--" : Integer.valueOf(score)));
            this.argList.add(disk.getSn());
            this.argList.add(-1 == score ? "" : ResourceUtil.getString((String)"analyze.disk.button.detail"));
            sbDiskList.append(this.replaceElement(DiskAnalyzeConstants.HTML_TEMPLATE_TR_DETAIL, this.argList));
        }
    }

    protected StringBuilder buildScorePage(List<AnalyzeDisk> diskList) {
        StringBuilder sbScorePath = new StringBuilder();
        sbScorePath.append(this.configHtmlPath);
        sbScorePath.append('/');
        sbScorePath.append("score.html");
        StringBuilder sbScoreContent = new StringBuilder();
        for (AnalyzeDisk disk : diskList) {
            StringBuilder sbScoreTr = new StringBuilder();
            for (AnalyzeItemResult resultItem : disk.getResultList()) {
                this.argList.clear();
                this.argList.add(resultItem.getRule().getName());
                this.argList.add(String.valueOf(resultItem.getRiskLevel()));
                if (!this.isHaveDHA(disk, resultItem.getRule().getNameZh())) continue;
                String strScoreTr = this.replaceElement(DiskAnalyzeConstants.HTML_TEMPLATE_TR_SCORE, this.argList);
                sbScoreTr.append(strScoreTr);
            }
            if (disk.getPowerOnTime() != null) {
                sbScoreTr.append(this.replaceElement(DiskAnalyzeConstants.HTML_TEMPLATE_TR_SCORE, Arrays.asList(ResourceUtil.getString((String)"analyze.disk.detail.lifetime"), disk.getPowerOnTime())));
            }
            if (disk.getRaidLevel() != null) {
                sbScoreTr.append(this.replaceElement(DiskAnalyzeConstants.HTML_TEMPLATE_TR_SCORE, Arrays.asList("RAID Level", disk.getRaidLevel().toString())));
            }
            this.argList.clear();
            this.argList.add(disk.getSn());
            this.argList.add(disk.getSn());
            this.argList.add(sbScoreTr.toString());
            String strDiskScore = this.buildHtmlString(sbScorePath.toString(), this.argList, true);
            sbScoreContent.append(strDiskScore);
        }
        return sbScoreContent;
    }

    protected void buildFrontPage() {
        StringBuilder sbFrontPath = new StringBuilder();
        sbFrontPath.append(DiskAnalyzeConstants.HTML_FILE_PATH);
        sbFrontPath.append(File.separator);
        sbFrontPath.append("front.html");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String buildDate = df.format(new Date());
        this.argList.clear();
        this.argList.add(buildDate);
        this.argList.add(UserOpDataSaveUtil.getToolIniProp((String)"tool.version"));
        if (UserOpDataSaveUtil.getToolBoxIniProp((String)"app.version") == null) {
            LOGGER.info("toolkit version is null !");
            this.argList.add(" ");
        }
        this.argList.add(UserOpDataSaveUtil.getToolBoxIniProp((String)"app.version"));
        this.argList.add(UserOpDataSaveUtil.getToolIniProp((String)"date"));
        this.buildHtmlFile(sbFrontPath.toString(), this.argList);
    }

    protected void buildSummaryPage() {
        StringBuilder sbRiskTable = new StringBuilder();
        StringBuilder sbDeviceTable = new StringBuilder();
        StringBuilder sbCollectRiskTable = new StringBuilder();
        for (String deviceID : this.context.getDeviceList()) {
            AnalyzeDevice device = this.context.getDeviceById(deviceID);
            DevNode node = device.getDeviceInfo();
            this.prepareDeviceParam(device, node);
            String strDeviceTableTr = this.replaceElement(DiskAnalyzeConstants.HTML_TEMPLATE_TR_DEVICE_TOTAL, this.argList);
            sbDeviceTable.append(strDeviceTableTr);
            for (AnalyzeDisk disk : device.getRiskDiskList()) {
                this.prepareRiskDiskParam(device, node, disk);
                String strRiskTableTr = this.replaceElement(DiskAnalyzeConstants.HTML_TEMPLATE_TR_RISK_TOTAL, this.argList);
                sbRiskTable.append(strRiskTableTr);
            }
            for (AnalyzeDisk disk : device.getCollectDiskList()) {
                this.prepareCollectDiskParam(device, node, disk);
                sbCollectRiskTable.append(this.replaceElement(DiskAnalyzeConstants.HTML_TEMPLATE_TR_COLLECT_RISK_TOTAL, this.argList));
            }
        }
        StringBuilder sbSummaryPath = new StringBuilder();
        sbSummaryPath.append(DiskAnalyzeConstants.HTML_FILE_PATH);
        sbSummaryPath.append(File.separator);
        sbSummaryPath.append("summary.html");
        AnalyzeSummary analyzeSummary = this.context.getAnalyzeSummary();
        this.prepareAnalyzeSummaryParam(sbRiskTable, sbDeviceTable, sbCollectRiskTable, analyzeSummary);
        this.buildHtmlFile(sbSummaryPath.toString(), this.argList);
    }

    private void prepareAnalyzeSummaryParam(StringBuilder sbRiskTable, StringBuilder sbDeviceTable, StringBuilder sbCollectRiskTable, AnalyzeSummary analyzeSummary) {
        this.argList.clear();
        this.argList.add(String.valueOf(analyzeSummary.getTotalDeviceNum()));
        this.argList.add(String.valueOf(analyzeSummary.getTotalDiskNum()));
        this.argList.add(String.valueOf(analyzeSummary.getRiskDiskNum()));
        this.argList.add(String.valueOf(analyzeSummary.getCollectDiskNum()));
        this.argList.add(sbRiskTable.toString());
        this.argList.add(sbCollectRiskTable.toString());
        this.argList.add(sbDeviceTable.toString());
    }

    private void prepareCollectDiskParam(AnalyzeDevice device, DevNode node, AnalyzeDisk disk) {
        this.argList.clear();
        this.argList.add(disk.getSn());
        this.argList.add(this.getHtmlName(node.getDeviceSerialNumber()));
        this.argList.add(disk.getSn());
        this.argList.add(device.getDeviceInfo().getDeviceName());
        this.argList.add(disk.getEnclosureNo());
        this.argList.add(disk.getSlotNo());
        this.argList.add("--");
    }

    private void prepareRiskDiskParam(AnalyzeDevice device, DevNode node, AnalyzeDisk disk) {
        this.argList.clear();
        this.argList.add(disk.getSn());
        this.argList.add(this.getHtmlName(node.getDeviceSerialNumber()));
        this.argList.add(disk.getSn());
        this.argList.add(device.getDeviceInfo().getDeviceName());
        this.argList.add(disk.getEnclosureNo());
        this.argList.add(disk.getSlotNo());
        this.argList.add(String.valueOf(disk.getScore()));
    }

    private void prepareDeviceParam(AnalyzeDevice device, DevNode node) {
        this.argList.clear();
        this.argList.add(node.getDeviceType().toString());
        this.argList.add(DiskAnalyzeContext.getInstance().getDevVersionWithoutSPC(node.getProductVersion()));
        this.argList.add(this.getHtmlName(node.getDeviceSerialNumber()));
        this.argList.add(node.getDeviceName());
        this.argList.add(node.getIp());
        this.argList.add(node.getDeviceSerialNumber());
        this.argList.add(String.valueOf(device.getDiskList().size()));
        this.argList.add(String.valueOf(device.getRiskDiskList().size()));
        this.argList.add(String.valueOf(device.getCollectDiskList().size()));
    }

    protected String getHtmlName(String deviceSerialNumber) {
        String htmlNameExte = "";
        if (this.idMap.containsKey(deviceSerialNumber)) {
            htmlNameExte = this.idMap.get(deviceSerialNumber) + ".html";
            return htmlNameExte;
        }
        htmlNameExte = "#";
        return htmlNameExte;
    }

    protected void delOldHtmlFiles(String filePath) {
        if (null == filePath || filePath.isEmpty()) {
            return;
        }
        File tempFolder = new File(filePath);
        if (tempFolder.isDirectory()) {
            File[] fileList = tempFolder.listFiles();
            if (!tempFolder.delete()) {
                LOGGER.error("Failed to delete {} folder.", (Object)tempFolder.getName());
            }
            this.checkFileType(fileList);
        }
    }

    protected void checkFileType(File[] fileList) {
        if (null == fileList) {
            return;
        }
        for (File file : fileList) {
            if (file.isFile()) {
                if (file.delete()) continue;
                LOGGER.error("Failed to delete file.");
                continue;
            }
            if (!file.isDirectory()) continue;
            this.delOldHtmlFiles(FilesUtil.getCanonicalPath(file));
        }
    }

    protected void createFiles(String[] fileNameArray, String fileType) {
        for (String fileName : fileNameArray) {
            if (fileType.equals("css")) {
                this.oldPathMap.put(fileName, "config/diskanalyze/css");
                this.newPathMap.put(fileName, DiskAnalyzeConstants.CSS_FILE_PATH);
            } else if (fileType.equals("html")) {
                this.oldPathMap.put(fileName, this.configHtmlPath);
                this.newPathMap.put(fileName, DiskAnalyzeConstants.HTML_FILE_PATH);
            } else if (fileType.equals("image")) {
                this.oldPathMap.put(fileName, "config/diskanalyze/images");
                this.newPathMap.put(fileName, DiskAnalyzeConstants.IMG_FILE_PATH);
            } else if (fileType.equals("js")) {
                this.oldPathMap.put(fileName, "config/diskanalyze/js");
                this.newPathMap.put(fileName, DiskAnalyzeConstants.JS_FILE_PATH);
            }
            this.copyFile(fileName, fileName);
        }
    }

    protected void addStaticFiles() {
        File imgFile;
        File reportFile = new File(DiskAnalyzeConstants.HTML_FILE_PATH);
        if (!reportFile.mkdirs()) {
            LOGGER.error("Failed to create report folder.");
        }
        if (!(imgFile = new File(DiskAnalyzeConstants.IMG_FILE_PATH)).mkdirs()) {
            LOGGER.error("Failed to create image folder.");
        }
        this.createFiles(this.imageFileNameArray, "image");
        File jsFile = new File(DiskAnalyzeConstants.JS_FILE_PATH);
        if (!jsFile.mkdirs()) {
            LOGGER.error("Failed to create js folder.");
        }
        this.createFiles(this.jsFileNameArray, "js");
        this.createFiles(this.cssFileNameArray, "css");
        this.createFiles(this.htmlFileNameArray, "html");
    }

    protected List<AnalyzeDisk> sortByFields(List<AnalyzeDisk> diskList) {
        Collections.sort(diskList, new ComparatorByFields());
        return diskList;
    }

    private boolean isHaveDHA(AnalyzeDisk analyzeDisk, String nameZh) {
        if (!"DHA".equals(nameZh)) {
            return true;
        }
        return !analyzeDisk.getSn().equals(AnalyzeThread.HAVEDHA.get(analyzeDisk.getSn() + "N/A"));
    }
}

