/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.encryptbase.context;

import com.huawei.encryptbase.utils.FileUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationContext {
    private static final Logger log = LoggerFactory.getLogger(ApplicationContext.class);
    public static final String ENV_SET_ENCRYPT_PARAM_CONFIG_PATH = "eservice.tools.encrypt.param.config.path";
    private static final ConcurrentHashMap<String, String> PATH_MAP = new ConcurrentHashMap();
    private static final ApplicationContext INSTANCE = new ApplicationContext();
    private static final String PROGRAM_OWNED_ENCRYPT_PARAM_CONFIG_PATH = System.getProperty("user.dir") + "/config/mm/appConfig.properties";

    private ApplicationContext() {
    }

    public void setAppEncryptConfigPath(String path) {
        PATH_MAP.put(ENV_SET_ENCRYPT_PARAM_CONFIG_PATH, path);
    }

    public synchronized Optional<String> getAppEncryptConfigPath() {
        String environmentHomePath = System.getProperty(ENV_SET_ENCRYPT_PARAM_CONFIG_PATH);
        if (StringUtils.isNotBlank((CharSequence)environmentHomePath)) {
            return FileUtil.normalizePath(environmentHomePath);
        }
        String settingHomePath = PATH_MAP.get(ENV_SET_ENCRYPT_PARAM_CONFIG_PATH);
        if (StringUtils.isNotBlank((CharSequence)settingHomePath)) {
            Optional<String> path = FileUtil.normalizePath(settingHomePath);
            log.info("the path of config is :{}", path);
            return path;
        }
        if (Files.exists(Paths.get(PROGRAM_OWNED_ENCRYPT_PARAM_CONFIG_PATH, new String[0]), new LinkOption[0])) {
            Optional<String> path = FileUtil.normalizePath(PROGRAM_OWNED_ENCRYPT_PARAM_CONFIG_PATH);
            log.info("the path of config is :{}", path);
            return path;
        }
        return Optional.empty();
    }

    public static ApplicationContext getInstance() {
        return INSTANCE;
    }
}

