/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.encryptbase.utils;

import com.huawei.encryptbase.service.IAesEncryptService;
import com.huawei.encryptbase.service.impl.AesEncryptImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesEncryptUtils {
    private static final Logger log = LoggerFactory.getLogger(AesEncryptUtils.class);
    private static final IAesEncryptService ENCRYPT_SERVICE = new AesEncryptImpl();

    private AesEncryptUtils() {
    }

    public static String decryptByAes(String cipherText) {
        return ENCRYPT_SERVICE.decrypt(cipherText);
    }

    public static byte[] decryptByAes(byte[] cipherText) {
        return ENCRYPT_SERVICE.decryptByte(cipherText);
    }

    public static byte[] decryptByAes(byte[] cipherText, int domainId) {
        return ENCRYPT_SERVICE.decryptByte(cipherText, domainId);
    }

    public static String encryptByAes(String plaintext) {
        return ENCRYPT_SERVICE.encrypt(plaintext);
    }

    public static byte[] encryptByAes(byte[] plaintext) {
        return ENCRYPT_SERVICE.encryptByte(plaintext);
    }

    public static byte[] encryptByAes(byte[] plaintext, int domainId) {
        return ENCRYPT_SERVICE.encryptByte(plaintext, domainId);
    }

    public static void importWorkKeyByDomainId(int domainId, byte[] content) {
        ENCRYPT_SERVICE.importWorkKeyByDomainId(domainId, content);
    }

    public static byte[] generateSecurityKey(int length) {
        return ENCRYPT_SERVICE.generateSecurityKey(length);
    }
}

