/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.encryptbase.utils;

import com.huawei.encryptbase.context.ApplicationContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CryptParamPropUtils {
    private static final Logger log = LoggerFactory.getLogger(CryptParamPropUtils.class);
    private static final String AUTO_UPDATE_MK_ENABLED = "auto_update_mk_enabled";
    private static final String AUTO_UPDATE_MK_ENABLED_DEFAULT = "false";
    private static final String CRYPT_KEY_LIFETIME_DAYS = "crypt_key_lifetime_days";
    private static final String CRYPT_KEY_LIFETIME_DAYS_DEFAULT = "179";
    private static final String PRIMARY_KEY_STORE_FILE = "primary_key_store_file";
    private static final String PRIMARY_KEY_STORE_FILE_DEFAULT = "config/k1.ks";
    private static final String STANDBY_KEY_STORE_FILE = "standby_key_store_file";
    private static final String STANDBY_KEY_STORE_FILE_DEFAULT = "config/s1.ks";
    private static final String DOMAIN_COUNT = "domain_count";
    private static final String DOMAIN_COUNT_DEFAULT = "2";
    private static final String CONFIG_PATH = "/config/appConfig.properties";
    private static final Properties PROPERTIES = new Properties();

    private CryptParamPropUtils() {
    }

    private static void loadProperties() {
        String cfgPath = ApplicationContext.getInstance().getAppEncryptConfigPath().orElse("");
        try (InputStream inputStream = StringUtils.isBlank((CharSequence)cfgPath) ? CryptParamPropUtils.class.getResourceAsStream(CONFIG_PATH) : new FileInputStream(cfgPath);){
            PROPERTIES.load(inputStream);
        }
        catch (IOException e) {
            log.error("read properties failed", (Throwable)e);
        }
    }

    public static String getDomainCount() {
        String domainCount = PROPERTIES.getProperty(DOMAIN_COUNT);
        return StringUtils.isBlank((CharSequence)domainCount) ? DOMAIN_COUNT_DEFAULT : domainCount;
    }

    public static String getAutoUpdateMkEnabled() {
        String autoUpdateMkEnabled = PROPERTIES.getProperty(AUTO_UPDATE_MK_ENABLED);
        return StringUtils.isBlank((CharSequence)autoUpdateMkEnabled) ? AUTO_UPDATE_MK_ENABLED_DEFAULT : autoUpdateMkEnabled;
    }

    public static String getCryptKeyLifetimeDays() {
        String cryptKeyLifetimeDays = PROPERTIES.getProperty(CRYPT_KEY_LIFETIME_DAYS);
        return StringUtils.isBlank((CharSequence)cryptKeyLifetimeDays) ? CRYPT_KEY_LIFETIME_DAYS_DEFAULT : cryptKeyLifetimeDays;
    }

    public static String getPrimaryKeyStoreFile() {
        String primaryKeyStoreFile = PROPERTIES.getProperty(PRIMARY_KEY_STORE_FILE);
        return StringUtils.isBlank((CharSequence)primaryKeyStoreFile) ? PRIMARY_KEY_STORE_FILE_DEFAULT.replaceAll("/", Matcher.quoteReplacement(File.separator)) : primaryKeyStoreFile.replaceAll("/", Matcher.quoteReplacement(File.separator));
    }

    public static String getStandbyKeyStoreFile() {
        String standbyKeyStoreFile = PROPERTIES.getProperty(STANDBY_KEY_STORE_FILE);
        return StringUtils.isBlank((CharSequence)standbyKeyStoreFile) ? STANDBY_KEY_STORE_FILE_DEFAULT.replaceAll("/", Matcher.quoteReplacement(File.separator)) : standbyKeyStoreFile.replaceAll("/", Matcher.quoteReplacement(File.separator));
    }

    public static void editKmcConfig(String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)key) && StringUtils.isNotBlank((CharSequence)value)) {
            PROPERTIES.setProperty(key, value);
        }
    }

    static {
        CryptParamPropUtils.loadProperties();
    }
}

