/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.ClassUtils;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import org.slf4j.Logger;

public final class SerializableUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SerializableUtils.class);

    private SerializableUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(Object obj, String fileName, String tmpPath) {
        boolean state;
        if (!(obj instanceof Serializable)) {
            return;
        }
        File path = new File(tmpPath);
        if (!path.exists() && !(state = path.mkdir())) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("create TMP_OBJECT_PATH path state" + state);
            }
            return;
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            File reFile = new File(tmpPath + File.separator + fileName);
            if (!reFile.exists() && !reFile.createNewFile()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Create reFile file error.File name is " + reFile);
                }
                return;
            }
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(reFile));
            objectOutputStream.writeObject(obj);
            objectOutputStream.flush();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Save tmp device file success . " + reFile.getCanonicalPath());
            }
            StreamUtils.closeStream(objectOutputStream, null);
        }
        catch (RuntimeException e) {
            LOGGER.error("Write object to tmp file error.", (Throwable)e);
        }
        catch (Exception e) {
            LOGGER.error("Write object to tmp file error.", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(objectOutputStream, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object readObject(String fileName, String tmpPath) {
        Object object;
        File reFile = new File(tmpPath + File.separator + fileName);
        if (!reFile.exists()) {
            return null;
        }
        ObjectInputStream inputStream = null;
        try {
            inputStream = new ObjectInputStream(new FileInputStream(reFile));
            object = inputStream.readObject();
        }
        catch (Exception e) {
            try {
                LOGGER.error("Read info from tmp file error.", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, inputStream);
                throw throwable;
            }
            StreamUtils.closeStream(null, inputStream);
            return null;
        }
        StreamUtils.closeStream(null, inputStream);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObject(String fileName, Class<?> clazz, String tmpPath) {
        Object object;
        File reFile = new File(tmpPath + File.separator + fileName);
        if (!reFile.exists()) {
            return null;
        }
        OsgiObjectInputStream stream = null;
        try {
            stream = new OsgiObjectInputStream(new FileInputStream(reFile), clazz.getClassLoader());
            object = stream.readObject();
        }
        catch (Exception e) {
            Object var6_7;
            try {
                LOGGER.error("Read info from tmp file error.", (Throwable)e);
                var6_7 = null;
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, stream);
                throw throwable;
            }
            StreamUtils.closeStream(null, stream);
            return var6_7;
        }
        StreamUtils.closeStream(null, stream);
        return object;
    }

    private static class OsgiObjectInputStream
    extends ObjectInputStream {
        private ClassLoader cl = Thread.currentThread().getContextClassLoader();

        public OsgiObjectInputStream(FileInputStream fis, ClassLoader cl) throws IOException {
            super(fis);
            this.cl = cl;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            try {
                return Class.forName(name, false, this.cl);
            }
            catch (ClassNotFoundException ex) {
                Class<?> cls = ClassUtils.PRIM_CLASS_MAP.get(name);
                if (cls != null) {
                    return cls;
                }
                throw ex;
            }
        }
    }
}

