/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.StreamStatusOperator;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.UnZipLimit;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamUtils {
    private static final Logger log = LoggerFactory.getLogger(StreamUtils.class);

    private StreamUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeInfo2File(byte[] message, String filePath) {
        File outFile = new File(filePath);
        BufferedOutputStream outputStream = null;
        try {
            if (!outFile.exists() && !outFile.createNewFile()) {
                LoggerFactory.getLogger(StreamUtils.class).error("Can not create out file " + outFile);
                StreamUtils.closeStream(outputStream, null);
                return;
            }
            outputStream = new BufferedOutputStream(new FileOutputStream(outFile));
            outputStream.write(message);
            outputStream.flush();
            StreamUtils.closeStream(outputStream, null);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(StreamUtils.class).error("Write file error...", (Throwable)e);
        }
        finally {
            StreamUtils.closeStream(outputStream, null);
        }
    }

    public static void closeStream(OutputStream out, InputStream input) {
        StreamUtils.closeResource(out, out);
        StreamUtils.closeResource(null, input);
    }

    public static void closeResource(Flushable flushed, Closeable closed) {
        try {
            if (null != flushed) {
                flushed.flush();
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(StreamUtils.class).error("Close output stream error...", (Throwable)e);
        }
        try {
            if (null != closed) {
                closed.close();
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(StreamUtils.class).error("Close output stream error...", (Throwable)e);
        }
    }

    public static String readResourcesAsClassLoader(String resName, Class<?> clazz) {
        InputStream input = FileUtils.getStreamWithObj(clazz, resName);
        ToolLoggerFactory.getLogger(StreamUtils.class).info("read template file : /config/template/" + resName);
        return StreamUtils.readStringFormInputStream(input);
    }

    public static String readStringFormFile(File file) {
        InputStream in = StreamUtils.createInputStream(file);
        return StreamUtils.readStringFormInputStream(in);
    }

    public static void writeStringFormFile(List<String> strs, String filePath, String targetFile) {
        if (StringUtils.isNULLStr(filePath) || strs == null || strs.isEmpty()) {
            return;
        }
        File rootPath = new File(filePath);
        if (!rootPath.exists()) {
            rootPath.mkdirs();
        }
        File fileDir = new File(filePath, targetFile);
        try {
            if (!fileDir.exists()) {
                fileDir.createNewFile();
            }
        }
        catch (IOException e) {
            LoggerFactory.getLogger(StreamUtils.class).error("Create file error.", (Throwable)e);
            return;
        }
        try (BufferedWriter outputStream = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileDir), "UTF-8"));){
            for (String str : strs) {
                outputStream.write(str);
                outputStream.flush();
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(StreamUtils.class).error("Write file error...", (Throwable)e);
        }
    }

    public static String readStringFormFile(File file, String charset) {
        InputStream in = StreamUtils.createInputStream(file);
        return StreamUtils.readStringFormInputStream(in, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String readStringFormInputStream(InputStream input, String charset) {
        BufferedReader reader = null;
        StringBuffer buffer = new StringBuffer();
        String line = null;
        try {
            reader = new BufferedReader(new InputStreamReader(input, charset));
            while (null != (line = reader.readLine())) {
                buffer.append(line);
                buffer.append(System.getProperty("line.separator"));
            }
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(StreamUtils.class).error("Read error " + buffer.toString());
            StreamUtils.closeStream(null, input);
            StreamUtils.closeResource(null, reader);
        }
        catch (Exception e2) {
            ToolLoggerFactory.getLogger(StreamUtils.class).error("Read error " + buffer.toString());
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, input);
                    StreamUtils.closeResource(null, reader);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, input);
            StreamUtils.closeResource(null, reader);
        }
        StreamUtils.closeStream(null, input);
        StreamUtils.closeResource(null, reader);
        return buffer.toString();
    }

    public static String readStringFormInputStream(InputStream input) {
        return StreamUtils.readStringFormInputStream(input, "UTF-8");
    }

    public static InputStream createInputStream(File input) {
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(input);
        }
        catch (FileNotFoundException e) {
            ToolLoggerFactory.getLogger(StreamUtils.class).error("Can't found file {} .", (Object)input.getName());
        }
        return fileInputStream;
    }

    public static void copyFile(File sourceFile, File targetFile) {
        try {
            StreamUtils.copyFileThrowEx(sourceFile, targetFile);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(StreamUtils.class).error("", (Throwable)e);
        }
    }

    public static void copyFileThrowEx(File sourceFile, File targetFile) throws Exception {
        try (FileInputStream input = new FileInputStream(sourceFile);
             BufferedInputStream inBuff = new BufferedInputStream(input);
             FileOutputStream output = new FileOutputStream(targetFile);
             BufferedOutputStream outBuff = new BufferedOutputStream(output);){
            int len;
            byte[] b = new byte[5120];
            while ((len = inBuff.read(b)) != -1) {
                outBuff.write(b, 0, len);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileThrowEx(File sourceFile, File targetFile, StreamStatusOperator streamOperator) throws Exception {
        if (streamOperator == null) {
            StreamUtils.copyFileThrowEx(sourceFile, targetFile);
            return;
        }
        try (FileInputStream input = new FileInputStream(sourceFile);
             BufferedInputStream inBuff = new BufferedInputStream(input);
             FileOutputStream output = new FileOutputStream(targetFile);
             BufferedOutputStream outBuff = new BufferedOutputStream(output);){
            int len;
            byte[] b = new byte[5120];
            while ((len = inBuff.read(b)) != -1 && !streamOperator.isManualTerminated()) {
                outBuff.write(b, 0, len);
            }
        }
        finally {
            if (streamOperator.isManualTerminated()) {
                FileUtils.deleteFile(targetFile);
            }
        }
    }

    /*
     * Loose catch block
     */
    public static byte[] readBytesFromFile(File file) {
        byte[] byArray;
        Throwable throwable;
        ByteArrayOutputStream baos;
        Throwable throwable2;
        BufferedInputStream bis;
        block31: {
            block32: {
                block29: {
                    block30: {
                        int bytesRead;
                        long fileSize = file.length();
                        if (fileSize > Integer.MAX_VALUE) {
                            log.error("File is too large to fit into a byte array (greater than 2GB).");
                            return new byte[0];
                        }
                        bis = new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
                        throwable2 = null;
                        baos = new ByteArrayOutputStream();
                        throwable = null;
                        byte[] buffer = new byte[8192];
                        while ((bytesRead = bis.read(buffer)) != -1) {
                            baos.write(buffer, 0, bytesRead);
                        }
                        byArray = baos.toByteArray();
                        if (baos == null) break block29;
                        if (throwable == null) break block30;
                        try {
                            baos.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        break block29;
                    }
                    baos.close();
                }
                if (bis == null) break block31;
                if (throwable2 == null) break block32;
                try {
                    bis.close();
                }
                catch (Throwable throwable4) {
                    throwable2.addSuppressed(throwable4);
                }
                break block31;
            }
            bis.close();
        }
        return byArray;
        {
            catch (Throwable throwable5) {
                try {
                    try {
                        try {
                            try {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                if (baos != null) {
                                    if (throwable != null) {
                                        try {
                                            baos.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable.addSuppressed(throwable7);
                                        }
                                    } else {
                                        baos.close();
                                    }
                                }
                                throw throwable6;
                            }
                        }
                        catch (Throwable throwable8) {
                            throwable2 = throwable8;
                            throw throwable8;
                        }
                    }
                    catch (Throwable throwable9) {
                        if (bis != null) {
                            if (throwable2 != null) {
                                try {
                                    bis.close();
                                }
                                catch (Throwable throwable10) {
                                    throwable2.addSuppressed(throwable10);
                                }
                            } else {
                                bis.close();
                            }
                        }
                        throw throwable9;
                    }
                }
                catch (FileNotFoundException e) {
                    log.error("read file data error,file path : {}", (Object)file);
                }
                catch (IOException e) {
                    log.error("read file data error,file path : {}", (Object)file, (Object)e);
                }
            }
        }
        return new byte[0];
    }

    public static String readStringFormInputStreamWithLimit(InputStream input, UnZipLimit unZipLimit) {
        return StreamUtils.readStringFormInputStreamWithLimit(input, StandardCharsets.UTF_8, unZipLimit);
    }

    private static String readStringFormInputStreamWithLimit(InputStream input, Charset charset, UnZipLimit unZipLimit) {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, charset));){
            String line;
            while (null != (line = reader.readLine())) {
                unZipLimit.increaseFileSize(line.getBytes(charset).length);
                ZipUtils.checkUnzipLimit(unZipLimit);
                builder.append(line);
                builder.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException e) {
            return "";
        }
        return builder.toString();
    }
}

