/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils;

import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.framework.platform.exception.ToolException;
import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public final class XmlWriter {
    private XmlWriter() {
    }

    public static Document createNewDocument() throws ToolException {
        Document document;
        try {
            DocumentBuilder documentBuilder = XmlUtils.getIgnoreWhitespaceDocBuilderFactory().newDocumentBuilder();
            document = documentBuilder.newDocument();
            document.setXmlVersion("1.0");
        }
        catch (ParserConfigurationException e) {
            throw new ToolException("Can't create document", e);
        }
        return document;
    }

    public static void writeDomToXmlFile(Document document, String fileAbsolutePath) throws ToolException {
        XmlWriter.writeDomToXmlFile(document, fileAbsolutePath, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeDomToXmlFile(Document document, String fileAbsolutePath, boolean indent) throws ToolException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(new File(fileAbsolutePath));
            Transformer transformer = XmlUtils.newTransformer();
            transformer.setOutputProperty("indent", indent ? "yes" : "no");
            transformer.transform(new DOMSource(document), new StreamResult(os));
        }
        catch (RuntimeException e) {
            try {
                throw new ToolException("Wirte to xml file \"" + fileAbsolutePath + "\" error:", e);
                catch (Exception e2) {
                    throw new ToolException("Wirte to xml file \"" + fileAbsolutePath + "\" error:", e2);
                }
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(os, null);
                throw throwable;
            }
        }
        StreamUtils.closeStream(os, null);
    }

    public static Element createTagElement(Document document, String tagName) {
        Element tagElement = document.createElement(tagName);
        return tagElement;
    }

    public static Element createTagElement(Document document, String tagName, String textContent) {
        Element tagElement = XmlWriter.createTagElement(document, tagName);
        Text text = document.createTextNode(textContent);
        tagElement.appendChild(text);
        return tagElement;
    }

    public static Element createTagElement(Document document, String tagName, String attrName, String attrValue) {
        Element tagElement = XmlWriter.createTagElement(document, tagName);
        Attr attr = document.createAttribute(attrName);
        attr.setValue(attrValue);
        tagElement.setAttributeNode(attr);
        return tagElement;
    }

    public static Element createTagElement(Document document, String tagName, List<KeyValue<String, String>> attributeInfos) {
        Element tagElement = XmlWriter.createTagElement(document, tagName);
        for (KeyValue<String, String> keyValue : attributeInfos) {
            Attr attr = document.createAttribute(keyValue.getKey());
            attr.setValue(keyValue.getValue());
            tagElement.setAttributeNode(attr);
        }
        return tagElement;
    }
}

