/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.utils.crypto;

import com.huawei.ism.tool.base.context.SmartKitClassLoader;
import com.huawei.ism.tool.base.context.StartParamContext;
import com.huawei.ism.tool.base.utils.crypto.AesCrypterManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESightEncryptManager
implements AesCrypterManager {
    private static final Logger log = LoggerFactory.getLogger(ESightEncryptManager.class);
    private static boolean isInitSuccess = false;
    private static Object cipherManager = null;
    private static Method encryptMethod = null;
    private static Method decryptMethod = null;
    private static Enum<?> keyLocal = null;
    private static final String DEFAULT_FAIL_VALUE = "";

    private static void initESightEncryptManager() {
        try {
            if (StartParamContext.getNeedJar().isEmpty()) {
                log.info("need jar is empty, not need init eSight encrypt manager");
                return;
            }
            log.info("init eSight encrypt manager start");
            SmartKitClassLoader smartKitClassLoader = new SmartKitClassLoader(StartParamContext.getNeedJar(), null);
            Class<?> cipherManagerClass = smartKitClassLoader.loadClass("com.huawei.bsp.encrypt.cbb.CipherManager");
            Method getInstance = cipherManagerClass.getMethod("getInstance", new Class[0]);
            cipherManager = getInstance.invoke(cipherManagerClass, new Object[0]);
            Class<?> keyTypeClass = smartKitClassLoader.loadClass("com.huawei.bsp.encrypt.cbb.KeyType");
            ESightEncryptManager.initNeedMethod(cipherManagerClass, keyTypeClass);
            log.info("init eSight encrypt manager success");
            isInitSuccess = true;
        }
        catch (ClassNotFoundException e) {
            log.error("can't find class when init eSight encrypt manager", (Throwable)e);
        }
        catch (Throwable e) {
            log.error("init eSight encrypt manager error", e);
        }
    }

    private static void initNeedMethod(Class<?> cipherManagerClass, Class<?> keyTypeClass) throws NoSuchMethodException {
        keyLocal = Enum.valueOf(keyTypeClass, "LOCAL");
        encryptMethod = cipherManagerClass.getMethod("encryptV2", char[].class, keyTypeClass, String.class);
        decryptMethod = cipherManagerClass.getMethod("decryptV2", char[].class, keyTypeClass, String.class);
    }

    public static ESightEncryptManager getInstance() {
        return ESightEncryptManagerHolder.INSTANCE;
    }

    @Override
    public boolean isInitSuccess() {
        return isInitSuccess;
    }

    @Override
    public String performEncrypt(String content) {
        if (!isInitSuccess) {
            log.error("eSight encrypt init fail");
            return DEFAULT_FAIL_VALUE;
        }
        try {
            char[] result = (char[])encryptMethod.invoke(cipherManager, content.toCharArray(), keyLocal, "common_local");
            return new String(result);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("use eSight encrypt error", (Throwable)e);
            return DEFAULT_FAIL_VALUE;
        }
    }

    @Override
    public String performDecrypt(String content) {
        if (!isInitSuccess) {
            log.error("eSight encrypt init fail");
            return DEFAULT_FAIL_VALUE;
        }
        try {
            char[] result = (char[])decryptMethod.invoke(cipherManager, content.toCharArray(), keyLocal, "common_local");
            return new String(result);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("use eSight decrypt error", (Throwable)e);
            return DEFAULT_FAIL_VALUE;
        }
    }

    private ESightEncryptManager() {
    }

    static {
        ESightEncryptManager.initESightEncryptManager();
    }

    private static class ESightEncryptManagerHolder {
        private static final ESightEncryptManager INSTANCE = new ESightEncryptManager();

        private ESightEncryptManagerHolder() {
        }
    }
}

