/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.validate;

import com.huawei.ism.tool.base.utils.KeyValue;
import com.huawei.ism.tool.base.validate.AbstractValidator;
import java.text.Normalizer;

public abstract class FormatValidator
extends AbstractValidator {
    private static final String USER_NAME_REGEX = "^[a-zA-Z_][0-9a-zA-Z_-]*";

    @Override
    public boolean validate(Object object, String objectDesc, Object ... params) {
        if (null == object || "".equals(object)) {
            return true;
        }
        KeyValue<String, String> kv = this.getFormatAndPrompt();
        if (!Normalizer.normalize(object.toString(), Normalizer.Form.NFKC).matches(kv.getKey())) {
            super.setErrMsgKey("validate.error.format", objectDesc, kv.getValue());
            return false;
        }
        return true;
    }

    protected abstract KeyValue<String, String> getFormatAndPrompt();

    public static class DomainNameValidator
    extends FormatValidator {
        @Override
        protected KeyValue<String, String> getFormatAndPrompt() {
            return new KeyValue<String, String>("^[a-zA-Z][0-9a-zA-Z-\\._]*", "validate.error.domainname");
        }
    }

    public static class NameFormatValidator
    extends FormatValidator {
        @Override
        protected KeyValue<String, String> getFormatAndPrompt() {
            return new KeyValue<String, String>(FormatValidator.USER_NAME_REGEX, "validate.error.username");
        }
    }
}

