/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform.context;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractContext {
    private Map<String, Map<String, Object>> objListMap = new ConcurrentHashMap<String, Map<String, Object>>();
    private Map<String, Object> objMap = new ConcurrentHashMap<String, Object>();
    private String pluginId = null;

    public List<String> getUuids(String type) {
        ArrayList<String> stringList = new ArrayList<String>();
        Map<String, Object> objList = this.objListMap.get(type);
        if (null != objList) {
            stringList.addAll(objList.keySet());
        }
        return stringList;
    }

    public List<Object> getObjectList(String type) {
        ArrayList<Object> objList = new ArrayList<Object>();
        Map<String, Object> dataList = this.objListMap.get(type);
        if (null != dataList) {
            objList.addAll(dataList.values());
        }
        return objList;
    }

    public Object getObject(String type, String uuid) {
        Map<String, Object> dataList = this.objListMap.get(type);
        if (null != dataList) {
            return dataList.get(uuid);
        }
        return null;
    }

    public Object getSingleObject(String type) {
        return this.objMap.get(type);
    }

    public synchronized void saveObjectToList(String type, String uuid, Object data) {
        Map<String, Object> dataList = this.objListMap.get(type);
        if (null == dataList) {
            dataList = new ConcurrentHashMap<String, Object>();
            this.objListMap.put(type, dataList);
        }
        dataList.put(uuid, data);
    }

    public void saveSingleObject(String type, Object object) {
        this.objMap.put(type, object);
    }

    public void removeObjectList(String type) {
        Map<String, Object> dataList = this.objListMap.get(type);
        if (null != dataList) {
            dataList.clear();
        }
    }

    public void removeSingleObject(String type) {
        this.objMap.remove(type);
    }

    public void clearAll() {
        this.objListMap.clear();
        this.objMap.clear();
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public void fireToolStarted() {
        ApplicationContext.getInstance().fireToolStarted(this.pluginId);
    }

    public void fireToolStopped() {
        ApplicationContext.getInstance().fireToolStopped(this.pluginId);
    }

    public void forceToolStopped() {
        ApplicationContext.getInstance().forceToolStopped(this.pluginId);
    }
}

