/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.platform.util;

import com.huawei.ism.tool.framework.platform.context.ILanguageListener;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageChangeLock;
import com.huawei.ism.tool.framework.platform.util.LanguageConfigKeeper;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import org.slf4j.Logger;

public final class LanguageManager {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(LanguageManager.class);
    private static LanguageManager instance = new LanguageManager();
    private static final Object LOCK = new Object();
    private LanguageConfigKeeper keeper = new LanguageConfigKeeper();
    private Locale currentLanguage = null;
    private LanguageCfg curLanguageCfg = LanguageCfg.EN;
    private List<ILanguageListener> listeners = new ArrayList<ILanguageListener>();
    private final LanguageChangeLock languageChangeLock = new LanguageChangeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LanguageManager getInstance() {
        Object object = LOCK;
        synchronized (object) {
            return instance;
        }
    }

    public static synchronized boolean isEnglish() {
        return Locale.ENGLISH.equals(LanguageManager.getInstance().getCurrentLanguage());
    }

    public void removeListener(ILanguageListener listener) {
        this.listeners.remove(listener);
    }

    public void addListener(ILanguageListener listener) {
        this.listeners.add(listener);
    }

    public Locale getCurrentLanguage() {
        return this.currentLanguage;
    }

    public LanguageCfg getCurLanguageCfg() {
        return this.curLanguageCfg;
    }

    public void setCurLanguageCfg(Locale curLanguageCfg) {
        for (LanguageCfg lancfg : LanguageCfg.values()) {
            if (!curLanguageCfg.toString().equalsIgnoreCase(lancfg.toString())) continue;
            this.curLanguageCfg = lancfg;
        }
    }

    public void setCurrentLanguage(Locale currentLocale) {
        Locale locale;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("currentLocale: " + currentLocale);
        }
        if (!Locale.SIMPLIFIED_CHINESE.equals(locale = currentLocale)) {
            locale = Locale.ENGLISH;
        }
        this.currentLanguage = locale;
        Locale.setDefault(this.currentLanguage);
        if (ApplicationContext.getInstance().isWindowsOS()) {
            JComponent.setDefaultLocale(this.currentLanguage);
        }
        for (ILanguageListener listener : this.listeners) {
            listener.fireLanguageChanged(this.currentLanguage);
        }
        this.keeper.saveCurrentLocale(locale);
        UserOpDataSaveUtil.updateUserInfo("isEnglish", String.valueOf(Locale.ENGLISH.equals(this.currentLanguage)));
    }

    public boolean isLanguageChangeLock() {
        return this.languageChangeLock.isLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockLanguageChange(String reason) {
        LanguageChangeLock languageChangeLock = this.languageChangeLock;
        synchronized (languageChangeLock) {
            this.languageChangeLock.setLock(true);
            this.languageChangeLock.setLockReason(reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLockLanguageChange() {
        LanguageChangeLock languageChangeLock = this.languageChangeLock;
        synchronized (languageChangeLock) {
            this.languageChangeLock.setLock(false);
        }
    }

    private LanguageManager() {
        Locale language = this.keeper.getCurrentLocale();
        this.setCurLanguageCfg(language);
        this.setCurrentLanguage(language);
    }

    public static enum LanguageCfg {
        ZH_CN,
        EN,
        DEFAULT;

    }
}

