/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.entity;

import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.resource.PublicServiceResource;
import java.util.Arrays;
import java.util.Locale;

public enum ItDeviceType {
    FUIONSTOR_EXP_NEW_NODE("NewNode"),
    Host("Host"),
    Switch("Switch"),
    DPA("Dpa"),
    Storage("Storage"),
    OCEAN_CYBER("OCEAN_CYBER"),
    COMPUTE_STORAGE("COMPUTE_STORAGE"),
    Database("Database"),
    UltraPath("UltraPath"),
    T3000("T3000"),
    DStorage("DStorage"),
    Server("Server"),
    FUSIONCUBE("FusionCube"),
    A3000("A3000"),
    OCEANSTOR_2910("OceanStor 2910"),
    DATATURBO("DataTurbo"),
    OCEAN_STOR_A310("OceanStor A310"),
    FUSION_STORAGE("fusionStorage"),
    FUSION_COMPUTE("fusionCompute"),
    DME_NODE("DME"),
    A800_NODE("OceanStor A800"),
    A800_OM("OceanStor DataTurbo Manager");

    private String name = null;

    private ItDeviceType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        Locale loc = LanguageManager.getInstance().getCurrentLanguage();
        if (this == Storage && "replaceCert".equals(System.getProperty("deviceAddProperties"))) {
            return PublicServiceResource.getInstance().getString(loc, "it.device.type.flash");
        }
        return PublicServiceResource.getInstance().getString(loc, "it.device.type." + this.getName().replace(" ", ".").toLowerCase(loc));
    }

    public String toString() {
        return this.getDescription();
    }

    public static ItDeviceType of(String itDevTypeName) {
        try {
            return ItDeviceType.valueOf(itDevTypeName);
        }
        catch (IllegalArgumentException e) {
            return Arrays.stream(ItDeviceType.values()).filter(type -> type.getName().equals(itDevTypeName)).findFirst().orElseThrow(() -> e);
        }
    }
}

