/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.framework.pubservice.scenedata;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.pubservice.scenedata.SceneXmlData;
import com.huawei.ism.tool.framework.pubservice.scenedata.SecureObjectInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class SceneDataSerialize<T> {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SceneXmlData.class);
    private static final String TXT_PATH = SceneUtils.getSceneFilePath("sceneSettingData.txt");
    private static File file = new File(TXT_PATH);
    private static final List<String> TRUST_CLASS_LIST = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean serialize(T object) {
        ObjectOutputStream oo = null;
        try {
            oo = new ObjectOutputStream(new FileOutputStream(file));
            oo.writeObject(object);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("serialize exception", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != oo) {
                try {
                    oo.close();
                }
                catch (IOException e) {
                    LOGGER.error("close exception", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T deserialize() {
        ObjectInputStream ois = null;
        try {
            ois = new SecureObjectInputStream(new FileInputStream(file), TRUST_CLASS_LIST);
            Object object = ois.readObject();
            return (T)object;
        }
        catch (FileNotFoundException e) {
            LOGGER.error("deserialize FileNotFoundException {}.", (Object)file.getName());
        }
        catch (IOException e) {
            LOGGER.error("deserialize IOException", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("deserialize ClassNotFoundException", (Throwable)e);
        }
        finally {
            if (null != ois) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    LOGGER.error("close exception", (Throwable)e);
                }
            }
        }
        return null;
    }

    static {
        TRUST_CLASS_LIST.add("java.util.HashMap");
        TRUST_CLASS_LIST.add("com.huawei.ism.tool.framework.pubservice.scenedata.UpgradeSceneData");
    }
}

