/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.a800switch;

import com.huawei.ism.tool.a800switch.SwitchParamHandler;
import com.huawei.ism.tool.a800switch.SwitchSTelnetMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SwitchSTelnetParam
implements SwitchParamHandler {
    private static final String KEY_SSH_RSA = "ssh-rsa ";
    private String username;
    private SwitchSTelnetMode authMode;
    private String password;
    private String cipherKey;
    private int port;

    @Override
    public Map<String, String> buildParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("{username}", this.username);
        params.put("{password}", this.password);
        params.put("{cipherKey}", this.getCompatibleCipherKey());
        params.put("{port}", String.valueOf(this.port));
        return params;
    }

    private String getCompatibleCipherKey() {
        if (StringUtils.isEmpty((CharSequence)this.cipherKey) || this.cipherKey.startsWith(KEY_SSH_RSA)) {
            return this.cipherKey;
        }
        return KEY_SSH_RSA + this.cipherKey;
    }

    @Override
    public List<String> getSensitiveKeys() {
        return Arrays.asList(this.password, this.cipherKey);
    }

    private static int $default$port() {
        return 22;
    }

    SwitchSTelnetParam(String username, SwitchSTelnetMode authMode, String password, String cipherKey, int port) {
        this.username = username;
        this.authMode = authMode;
        this.password = password;
        this.cipherKey = cipherKey;
        this.port = port;
    }

    public static SwitchSTelnetParamBuilder builder() {
        return new SwitchSTelnetParamBuilder();
    }

    public SwitchSTelnetMode getAuthMode() {
        return this.authMode;
    }

    public static class SwitchSTelnetParamBuilder {
        private String username;
        private SwitchSTelnetMode authMode;
        private String password;
        private String cipherKey;
        private boolean port$set;
        private int port$value;

        SwitchSTelnetParamBuilder() {
        }

        public SwitchSTelnetParamBuilder username(String username) {
            this.username = username;
            return this;
        }

        public SwitchSTelnetParamBuilder authMode(SwitchSTelnetMode authMode) {
            this.authMode = authMode;
            return this;
        }

        public SwitchSTelnetParamBuilder password(String password) {
            this.password = password;
            return this;
        }

        public SwitchSTelnetParamBuilder cipherKey(String cipherKey) {
            this.cipherKey = cipherKey;
            return this;
        }

        public SwitchSTelnetParamBuilder port(int port) {
            this.port$value = port;
            this.port$set = true;
            return this;
        }

        public SwitchSTelnetParam build() {
            int port$value = this.port$value;
            if (!this.port$set) {
                port$value = SwitchSTelnetParam.$default$port();
            }
            return new SwitchSTelnetParam(this.username, this.authMode, this.password, this.cipherKey, port$value);
        }

        public String toString() {
            return "SwitchSTelnetParam.SwitchSTelnetParamBuilder(username=" + this.username + ", authMode=" + (Object)((Object)this.authMode) + ", password=" + this.password + ", cipherKey=" + this.cipherKey + ", port$value=" + this.port$value + ")";
        }
    }
}

