/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class ProxySOCKS5 {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ProxySOCKS5.class);
    private static final int DEFAULTPORT = 1080;
    private static final int DEFAULTTIMEOUT = 3600000;
    private String proxyHost;
    private int proxyPort;
    private InputStream in;
    private OutputStream out;
    private Socket socket;
    private String user;
    private String passwd;
    private String dstHost;
    private int dstPort;

    public ProxySOCKS5(String host, int port) {
        this.proxyHost = host;
        this.proxyPort = port;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getUser() {
        return this.user;
    }

    public String getPasswd() {
        return AESEncrypt.decrypt((String)this.passwd);
    }

    public void setUserPasswd(String ur, String pwd) {
        this.user = ur;
        this.setPassword(pwd);
    }

    private void setPassword(String pwd) {
        this.passwd = AESEncrypt.encrypt((String)pwd);
    }

    public void setDest(String host, int port) {
        this.dstHost = host;
        this.dstPort = port;
    }

    public void connect(String host, int port, int timeout) throws ToolException {
        if (null == host) {
            return;
        }
        try {
            this.socket = ProxySOCKS5.createSocket(this.proxyHost, this.proxyPort, timeout);
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            this.socket.setTcpNoDelay(true);
            byte[] buf = new byte[1024];
            this.writeHeadInfo(buf, 0);
            this.fill(this.in, buf, 2);
            boolean check = false;
            switch (buf[1] & 0xFF) {
                case 0: {
                    check = true;
                    break;
                }
                case 2: {
                    if (StringUtils.hasNULLStr(this.user, this.getPasswd())) break;
                    this.writeUserInfo(buf);
                    this.fill(this.in, buf, 2);
                    if (buf[1] != 0) break;
                    check = true;
                    break;
                }
            }
            this.checkIsOk(check);
            if (timeout > 0) {
                this.socket.setSoTimeout(timeout);
            }
            this.writeSocketInfo(host, port, buf);
        }
        catch (RuntimeException e) {
            LOGGER.error("RuningTime stream error.", e);
        }
        catch (Exception e) {
            LOGGER.error("Close stream error.", e);
            try {
                this.socket.close();
            }
            catch (Exception eee) {
                LOGGER.error("Close stream error.", eee);
            }
            String message = "ProxySOCKS5: " + e;
            throw new ToolException(message, e);
        }
    }

    private void checkIsOk(boolean check) throws ToolException {
        if (!check) {
            try {
                this.socket.close();
            }
            catch (Exception eee) {
                LOGGER.error("Close stream error.", eee);
            }
            throw new ToolException("fail in SOCKS5 proxy");
        }
    }

    private void writeSocketInfo(String host, int port, byte[] buf) throws IOException, ToolException {
        int index = 0;
        buf[index++] = 5;
        buf[index++] = 1;
        buf[index++] = 0;
        byte[] hostb = ProxySOCKS5.str2byte(host);
        int len = hostb.length;
        buf[index++] = 3;
        buf[index++] = (byte)len;
        System.arraycopy(hostb, 0, buf, index, len);
        index += len;
        buf[index++] = (byte)(port >>> 8);
        buf[index++] = (byte)(port & 0xFF);
        this.out.write(buf, 0, index);
        this.fill(this.in, buf, 4);
        if (buf[1] != 0) {
            try {
                this.socket.close();
            }
            catch (Exception eee) {
                LOGGER.error("Close stream error.", eee);
            }
            throw new ToolException("ProxySOCKS5: server returns " + buf[1]);
        }
        switch (buf[3] & 0xFF) {
            case 1: {
                this.fill(this.in, buf, 6);
                break;
            }
            case 3: {
                this.fill(this.in, buf, 1);
                this.fill(this.in, buf, (buf[0] & 0xFF) + 2);
                break;
            }
            case 4: {
                this.fill(this.in, buf, 18);
                break;
            }
        }
    }

    private void writeUserInfo(byte[] buf) throws IOException {
        int index = 0;
        buf[index++] = 1;
        buf[index++] = (byte)this.user.length();
        System.arraycopy(ProxySOCKS5.str2byte(this.user), 0, buf, index, this.user.length());
        index += this.user.length();
        String pwd = this.getPasswd();
        buf[index++] = (byte)pwd.length();
        System.arraycopy(ProxySOCKS5.str2byte(pwd), 0, buf, index, pwd.length());
        this.out.write(buf, 0, index += pwd.length());
        com.huawei.ism.tool.base.utils.StringUtils.cleanPwd((String)pwd);
    }

    private int writeHeadInfo(byte[] buf, int index) throws IOException {
        buf[index++] = 5;
        buf[index++] = 2;
        buf[index++] = 0;
        buf[index++] = 2;
        this.out.write(buf, 0, index);
        return index;
    }

    static byte[] str2byte(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    static Socket createSocket(String host, int port, int timeout) throws ToolException {
        if (timeout == 0) {
            try {
                Socket socket = new Socket(host, port);
                return socket;
            }
            catch (Exception e) {
                LOGGER.error("socket exception .", e);
                throw new ToolException(e.toString(), e);
            }
        }
        Socket[] sockp = new Socket[1];
        ArrayList<Exception> ee = new ArrayList<Exception>(1);
        String message = "";
        Thread tmp = ProxySOCKS5.getThread(host, port, sockp, ee);
        ProxySOCKS5.tmpThreadStart(host, tmp);
        try {
            tmp.join(timeout);
            message = "timeout: ";
        }
        catch (InterruptedException eee) {
            LOGGER.error("Close stream error.", eee);
        }
        if (sockp[0] == null || !sockp[0].isConnected()) {
            message = message + "socket is not established";
            if (!ee.isEmpty()) {
                message = ((Exception)ee.get(0)).toString();
            }
            tmp.interrupt();
            throw new ToolException(message);
        }
        Socket socket = sockp[0];
        return socket;
    }

    private static Thread getThread(final String host, final int port, final Socket[] sockets, final List<Exception> exceptions) {
        return new Thread(new Runnable(){

            @Override
            public void run() {
                sockets[0] = null;
                try {
                    sockets[0] = new Socket(host, port);
                }
                catch (Exception e) {
                    LOGGER.error("socket exception .", e);
                    exceptions.add(e);
                    ProxySOCKS5.closeSocket(sockets);
                    sockets[0] = null;
                }
            }
        });
    }

    private static void tmpThreadStart(String host, Thread tmp) {
        tmp.setName("Opening Socket " + host);
        tmp.setUncaughtExceptionHandler((thread, exception) -> LOGGER.error("{}  error {}", (Object)thread.getName(), (Object)exception.getMessage()));
        tmp.start();
    }

    private static void closeSocket(Socket[] sockp) {
        if (sockp[0] != null && sockp[0].isConnected()) {
            try {
                sockp[0].close();
            }
            catch (Exception eee) {
                LOGGER.error("Close stream error.", eee);
            }
        }
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void close() {
        StreamUtils.closeStream((OutputStream)this.out, (InputStream)this.in);
        StreamUtils.closeResource(null, (Closeable)this.socket);
        this.in = null;
        this.out = null;
        this.socket = null;
    }

    public static int getDefaultPort() {
        return 1080;
    }

    private void fill(InputStream input, byte[] buf, int len) throws ToolException, IOException {
        int result;
        for (int start = 0; start < len; start += result) {
            result = input.read(buf, start, len - start);
            if (result > 0) continue;
            throw new ToolException("ProxySOCKS5: stream is closed");
        }
    }

    public Socket connect() throws IOException {
        try {
            this.connect(this.dstHost, this.dstPort, 3600000);
        }
        catch (Exception e) {
            LOGGER.error("Close connect.", e);
            throw new IOException(e.getMessage(), e);
        }
        return this.getSocket();
    }

    public String toString() {
        return "ProxySOCKS5{proxyHost='" + this.proxyHost + '\'' + ", proxyPort=" + this.proxyPort + '}';
    }
}

