/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.ISshJudge;
import com.huawei.ism.tool.obase.connection.MultiRouteNode;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionCreator;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.util.CommonUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SshConnectionManager {
    private static final Logger log = LoggerFactory.getLogger(SshConnectionManager.class);
    private static final Map<String, User> RUSER_MAP = new ConcurrentHashMap<String, User>();
    private static final String CONCURRENT = "concurrent";
    private static ConcurrentHashMap<String, DevConnectionPool> connectionPools = new ConcurrentHashMap();
    private static final Object LOCK = new Object();

    public static Map<String, User> getRuserMap() {
        return RUSER_MAP;
    }

    public static User getDevRUser(String key) {
        return RUSER_MAP.get(key);
    }

    public static void removeDevRUser(String key) {
        RUSER_MAP.remove(key);
    }

    public static ConcurrentHashMap<String, DevConnectionPool> getConnectionPools() {
        return connectionPools;
    }

    private SshConnectionManager() {
    }

    public static boolean hasConnection(DevNode devNode) {
        ICliConnection connection;
        String key = SshConnectionManager.getKey(devNode);
        String connKey = SshConnectionManager.getConnKey(devNode);
        DevConnectionPool connectionPool = connectionPools.get(key);
        return connectionPool != null && (connection = connectionPool.getConnection(connKey)) instanceof SshConnection && connection.isConnected();
    }

    public static ICliConnection getSshConnection(DevNode devNode) throws ToolException {
        return SshConnectionManager.getSshConnection(devNode, null);
    }

    public static ICliConnection getSshConnection(DevNode devNode, ISshJudge sshJudge) throws ToolException {
        return SshConnectionManager.getSshConnection(devNode, sshJudge, false, false);
    }

    public static ICliConnection getSshConnection(DevNode devNode, ISshJudge sshJudge, boolean isPwdWillExpireBreak) throws ToolException {
        return SshConnectionManager.getSshConnection(devNode, sshJudge, isPwdWillExpireBreak, false);
    }

    public static ICliConnection getSshConnection(DevNode devNode, ISshJudge sshJudge, boolean isPwdWillExpireBreak, boolean isDeviceMgr) throws ToolException {
        ICliConnection connection;
        String key = SshConnectionManager.getKey(devNode);
        String connKey = SshConnectionManager.getConnKey(devNode);
        SshConnectionManager.specialConf4Host(devNode);
        DevConnectionPool connectionPool = connectionPools.get(key);
        if (connectionPool == null) {
            connectionPool = SshConnectionManager.getDevConnectionPool(key);
        }
        SshConnection conn = (connection = connectionPool.getConnection(connKey)) instanceof SshConnection ? (SshConnection)connection : null;
        DevNode dn = conn == null ? null : conn.getdNode();
        log.info("get conn from pool :{}  devInfo:{}", (Object)StringUtils.getCleanMessage((String)connKey), (Object)(dn == null ? "" : dn.getIp()));
        if (connection == null || !connection.isConnected()) {
            connection = SshConnectionManager.getSshConnectionWithoutCache(devNode, sshJudge, isPwdWillExpireBreak, isDeviceMgr);
            connectionPool.putConnection(connKey, connection);
        }
        return connection;
    }

    public static ICliConnection getSshConnectionWithoutCache(DevNode devNode, ISshJudge sshJudge, boolean isPwdWillExpireBreak, boolean isDeviceMgr) throws ToolException {
        SshConnectionCreator creator = new SshConnectionCreator(devNode, sshJudge, isPwdWillExpireBreak, isDeviceMgr);
        ICliConnection connection = SshConnectionManager.createSshConnectionImpl(devNode, creator);
        ApplicationContext.getInstance().setHost(false);
        return connection;
    }

    public static ICliConnection getCyberEngineSshConnection(DevNode devNode, ISshJudge sshJudge, boolean isPwdWillExpireBreak, boolean isDeviceMgr) throws ToolException {
        String key = SshConnectionManager.getKey(devNode);
        String connKey = SshConnectionManager.getConnKey(devNode);
        DevConnectionPool connectionPool = connectionPools.get(key);
        if (connectionPool == null) {
            connectionPool = SshConnectionManager.getDevConnectionPool(key);
        }
        ICliConnection connection = connectionPool.getConnection(connKey);
        Optional.ofNullable(connection).filter(SshConnection.class::isInstance).map(SshConnection.class::cast).map(SshConnection::getdNode).map(DevNode::getIp).ifPresent(ip -> log.info("get conn from pool :{} devInfo:{}", (Object)StringUtils.getCleanMessage((String)connKey), ip));
        if (connection == null || !connection.isConnected()) {
            connection = SshConnectionManager.createCyberEngineSshConnImpl(devNode, new SshConnectionCreator(devNode, sshJudge, isPwdWillExpireBreak, isDeviceMgr));
            ApplicationContext.getInstance().setHost(false);
            connectionPool.putConnection(connKey, connection);
        }
        return connection;
    }

    @NotNull
    private static synchronized DevConnectionPool getDevConnectionPool(String key) {
        DevConnectionPool connectionPool = DevConnectionPool.createInstance();
        connectionPools.remove(key);
        DevConnectionPool tempPool = connectionPools.putIfAbsent(key, connectionPool);
        if (tempPool != null) {
            log.info("Connection add first.");
        }
        return connectionPool;
    }

    private static ICliConnection createCyberEngineSshConnImpl(DevNode devNode, SshConnectionCreator creator) throws ToolException {
        SshConnection connection = null;
        try {
            connection = creator.createKAdminConn();
            SshConnectionManager.setDevInfo(devNode, connection);
        }
        catch (ToolException e) {
            SshConnectionManager.handleCreateConException(devNode, e);
        }
        return connection;
    }

    private static ICliConnection createSshConnectionImpl(DevNode devNode, SshConnectionCreator creator) throws ToolException {
        SshConnection connection = null;
        try {
            connection = creator.create();
            SshConnectionManager.setDevInfo(devNode, connection);
        }
        catch (ToolException e) {
            SshConnectionManager.handleCreateConException(devNode, e);
        }
        return connection;
    }

    private static void setDevInfo(DevNode devNode, ICliConnection connection) {
        if (devNode != null && connection instanceof SshConnection) {
            SshConnection conn = (SshConnection)CommonUtil.convertObject((Object)connection, SshConnection.class);
            conn.setdNode(devNode);
        }
    }

    private static void handleCreateConException(DevNode devNode, ToolException e) throws ToolException {
        if (null != devNode.getSocks5Proxy() && "ssh.connect.unknow.error".equals(e.getErrorId().trim())) {
            throw new ToolException("ssh.connect.socket5.error", true, (Throwable)e);
        }
        throw e;
    }

    private static void specialConf4Host(DevNode devNode) {
        if (ItDeviceType.Host.equals((Object)devNode.getItDeviceType())) {
            ApplicationContext.getInstance().setHost(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConnection(DevNode devNode) {
        Object object = LOCK;
        synchronized (object) {
            String key = SshConnectionManager.getKey(devNode);
            DevConnectionPool connectionPool = connectionPools.get(key);
            if (null != connectionPool) {
                connectionPool.closeConnections();
            }
            connectionPools.remove(key);
        }
    }

    public static void releaseAllConnection() {
        connectionPools.forEach((key, pool) -> {
            log.info("release conn key={}", key);
            pool.closeConnections();
            connectionPools.remove(key);
        });
    }

    public static void releaseConnection(ICliConnection connection) {
        if (null == connection) {
            return;
        }
        try {
            Set poolKeys = connectionPools.keySet();
            for (String poolKey : poolKeys) {
                boolean result;
                DevConnectionPool devConnectionPool = connectionPools.get(poolKey);
                if (devConnectionPool == null || !(result = devConnectionPool.closeConnection(connection))) continue;
                if (devConnectionPool.isEmpty()) {
                    connectionPools.remove(poolKey);
                }
                return;
            }
        }
        catch (Exception e) {
            log.error("NullPointerException but not error", e);
        }
        connection.close();
    }

    private static String getKey(DevNode devNode) {
        if (devNode == null) {
            return "";
        }
        DeviceType type = devNode.getDeviceType();
        if (type == null) {
            return devNode.getDeviceSerialNumber();
        }
        return devNode.getDeviceSerialNumber() + devNode.getIp();
    }

    private static String getConnKey(DevNode devNode) {
        String sshForwardKey = SshConnectionManager.getSshForwardKey(devNode);
        if (devNode.isSshqueue()) {
            return devNode.getIp() + devNode.getDeviceSerialNumber() + sshForwardKey + CONCURRENT;
        }
        return devNode.getIp() + devNode.getDeviceSerialNumber() + sshForwardKey;
    }

    @NotNull
    private static String getSshForwardKey(DevNode devNode) {
        if (CollectionUtil.isEmpty(devNode.getSshForwardList())) {
            return "";
        }
        return devNode.getSshForwardList().stream().map(MultiRouteNode::getHost).filter(Objects::nonNull).collect(Collectors.joining("_"));
    }

    public static void checkDeleteConnections() {
        try {
            log.info("SshConnectionManager.checkDeleteConnections");
            Set poolKeys = connectionPools.keySet();
            HashSet<String> removeKeys = new HashSet<String>();
            for (String poolKey : poolKeys) {
                DevConnectionPool connectionPool = connectionPools.get(poolKey);
                connectionPool.checkInvalidConnections();
                if (!connectionPool.isEmpty()) continue;
                removeKeys.add(poolKey);
            }
            for (String removeKey : removeKeys) {
                connectionPools.remove(removeKey);
            }
        }
        catch (RuntimeException re) {
            log.error("NullPointerException but not error");
        }
        catch (Exception e) {
            log.error("Exception happened in: ", e);
        }
    }

    private static class DevConnectionPool {
        private ConcurrentHashMap<String, ICliConnection> connections = new ConcurrentHashMap();

        private DevConnectionPool() {
        }

        public static DevConnectionPool createInstance() {
            return new DevConnectionPool();
        }

        public ICliConnection getConnection(String id) {
            return this.connections.get(id);
        }

        public boolean isEmpty() {
            return this.connections.isEmpty();
        }

        public void putConnection(String id, ICliConnection connection) {
            this.connections.put(id, connection);
        }

        public void closeConnections() {
            Collection<ICliConnection> connCollection = this.connections.values();
            for (ICliConnection connection : connCollection) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    log.error("", e);
                }
            }
        }

        public void checkInvalidConnections() {
            Set connKeys = this.connections.keySet();
            HashSet<String> removeKeys = new HashSet<String>();
            for (String connKey : connKeys) {
                ICliConnection connection = this.connections.get(connKey);
                if (connection != null && connection.isConnected()) continue;
                log.info("the connection has been disconnected!!:{}", (Object)connection);
                removeKeys.add(connKey);
            }
            for (String removeKey : removeKeys) {
                this.connections.remove(removeKey);
            }
        }

        public boolean closeConnection(ICliConnection connection) {
            if (!this.connections.containsValue(connection)) {
                return false;
            }
            for (String threadID : this.connections.keySet()) {
                ICliConnection current = this.connections.get(threadID);
                if (!current.equals(connection)) continue;
                connection.close();
                this.connections.remove(threadID);
                return true;
            }
            return false;
        }
    }
}

