/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection.support;

import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.connection.support.SftpProgressMonitor;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.SftpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.sshd.sftp.client.SftpClient;
import org.slf4j.Logger;

public class SftpPermWrapper {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SftpPermWrapper.class);
    private SshConnection originalConnection;
    private SftpProgressMonitor monitor;
    private SftpClient sftpChannel;
    private InputStream inputStream;
    private String localPath;

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public SshConnection getOriginalConnection() {
        return this.originalConnection;
    }

    public SftpPermWrapper(SshConnection originalConnection, SftpProgressMonitor monitor, SftpClient sftpChannel, String localPath) {
        this.originalConnection = originalConnection;
        this.monitor = monitor;
        this.sftpChannel = sftpChannel;
        this.localPath = localPath;
    }

    public SftpPermWrapper(SshConnection originalConnection, SftpProgressMonitor monitor, SftpClient sftpChannel, InputStream inputStream) {
        this.originalConnection = originalConnection;
        this.monitor = monitor;
        this.sftpChannel = sftpChannel;
        this.inputStream = inputStream;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public void setLocalPath(String localPath) {
        this.localPath = localPath;
    }

    public void setOriginalConnection(SshConnection originalConnection) {
        this.originalConnection = originalConnection;
    }

    public SftpProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(SftpProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public SftpClient getSftpChannel() {
        return this.sftpChannel;
    }

    public void setSftpChannel(SftpClient sftpChannel) {
        this.sftpChannel = sftpChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadWithPermHandle(String devFilePath) {
        try {
            String[] fileUpdInfo = SftpUtils.getUploadAuthPath(this.originalConnection, devFilePath);
            boolean needRetry = fileUpdInfo != null && fileUpdInfo.length == 2;
            LOGGER.error("upload to sftp needRetry:" + needRetry);
            if (!needRetry) {
                this.doUpload(devFilePath);
                return;
            }
            String[] serverPathRight = SftpUtils.getFilePermDetail(fileUpdInfo[1]);
            int tryTimes = 0;
            int origomRight = SftpUtils.convertRightToInt(serverPathRight);
            LOGGER.error("upload to sftp needRetry origomRight:{}", (Object)origomRight);
            try {
                boolean isScuccess = false;
                while (tryTimes < 3) {
                    String[] serverPathInfoClone = (String[])serverPathRight.clone();
                    LOGGER.error("upload to sftp needRetry serverPathInfoClone.");
                    try {
                        LOGGER.error("upload to sftp needRetry tryTimes:{}", (Object)(++tryTimes));
                        this.doUpload(devFilePath);
                        LOGGER.error("upload to sftp needRetry tryTimes end");
                        isScuccess = true;
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error("upload to sftp error.", e);
                        serverPathInfoClone[3 - tryTimes] = "111";
                        int rightToChmod = SftpUtils.convertRightToInt(serverPathInfoClone);
                        if (rightToChmod == -1) continue;
                        this.originalConnection.execCmd("chmod " + rightToChmod + " " + fileUpdInfo[0]);
                    }
                }
                if (!isScuccess) {
                    throw new EncapsulatedRuntimeException("exec upload file error");
                }
            }
            finally {
                LOGGER.error("upload to sftp recover right start.");
                if (origomRight != -1) {
                    LOGGER.error("upload to sftp recover right execute.");
                    this.originalConnection.execCmd("chmod " + origomRight + " " + fileUpdInfo[0]);
                    LOGGER.error("upload to sftp recover right execute success.");
                }
                LOGGER.error("upload to sftp recover right end.");
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("", e);
            throw new EncapsulatedRuntimeException("put stream error.");
        }
    }

    public void doUpload(String serverPath) throws IOException {
        int size;
        OutputStream outputStream = this.sftpChannel.write(serverPath);
        byte[] buffer = new byte[8192];
        do {
            if ((size = this.inputStream.read(buffer)) <= 0) continue;
            outputStream.write(buffer, 0, size);
        } while (size > 0);
    }
}

