/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.flow;

import com.huawei.ism.tool.obase.flow.Branch;
import com.huawei.ism.tool.obase.flow.Flow;
import com.huawei.ism.tool.obase.flow.FlowException;
import com.huawei.ism.tool.obase.flow.ICondition;
import com.huawei.ism.tool.obase.flow.IFlow;
import com.huawei.ism.tool.obase.flow.IFlowListener;
import com.huawei.ism.tool.obase.flow.IStepContainer;
import com.huawei.ism.tool.obase.flow.Step;
import com.huawei.ism.tool.obase.flow.ui.IFlowUI;
import com.huawei.ism.tool.obase.flow.ui.Title;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FlowFactory {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(FlowFactory.class);
    private Map<String, Class<?>> stepMap = new HashMap();
    private Map<String, Class<?>> branchMap = new HashMap();
    private Map<String, Class<?>> conditionMap = new HashMap();
    private Map<String, Class<?>> listenerMap = new HashMap();
    private Map<Class<?>, Object> instanceMap = new HashMap();
    private Map<String, Title> titleMap = new HashMap<String, Title>();
    private ClassLoader clsLoader = null;
    private InputStream defStream = null;
    private Document defDoc = null;
    private InputStream flowStream = null;
    private Document flowDoc = null;

    public FlowFactory(InputStream defStream, InputStream flowStream, ClassLoader clsLoader) {
        this.flowStream = flowStream;
        this.defStream = defStream;
        this.clsLoader = clsLoader;
    }

    public FlowFactory(String defXmlPath, String flowXmlPath, ClassLoader clsLoader) {
        this(clsLoader.getResourceAsStream(defXmlPath), clsLoader.getResourceAsStream(flowXmlPath), clsLoader);
    }

    public Title getFlowTitle() {
        try {
            Document doc = this.getFlowDoc(this.flowStream);
            if (null == doc) {
                return null;
            }
            HashMap<String, Title> map = new HashMap<String, Title>();
            Element root = doc.getDocumentElement();
            Element res = XmlUtils.getChild(root, "resource");
            this.buildTitleMap(res, map);
            Element flowEm = XmlUtils.getChild(root, "flow");
            return (Title)map.get(XmlUtils.getAttribute(flowEm, "title"));
        }
        catch (FlowException e) {
            LOGGER.error("Get flow title error.", e);
            return null;
        }
    }

    public IFlow createFlow(IFlowUI flowUI) throws FlowException {
        Document defDocu = this.getDefDoc(this.defStream);
        if (null == defDocu) {
            throw new FlowException("Read define xml error.");
        }
        this.parseDefToMaps(defDocu);
        Document flowDocu = this.getFlowDoc(this.flowStream);
        if (null != flowDocu) {
            Flow flow = this.parseFlow(flowDocu);
            flow.setFlowUI(flowUI);
            return flow;
        }
        throw new FlowException("Read flow xml error.");
    }

    private Document getDefDoc(InputStream stream) throws FlowException {
        if (null == this.defDoc) {
            this.defDoc = this.getDoc(stream);
        }
        return this.defDoc;
    }

    private Document getFlowDoc(InputStream stream) throws FlowException {
        if (null == this.flowDoc) {
            this.flowDoc = this.getDoc(stream);
        }
        return this.flowDoc;
    }

    private void parseDefToMaps(Document defDocu) throws FlowException {
        Element root = defDocu.getDocumentElement();
        try {
            this.buildClazzMap(root, "step", this.stepMap);
            this.buildClazzMap(root, "branch", this.branchMap);
            this.buildClazzMap(root, "condition", this.conditionMap);
            this.buildClazzMap(root, "listener", this.listenerMap);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Parse define xml error.", e);
            throw new FlowException("Parse define xml error.", e);
        }
    }

    private Flow parseFlow(Document flowDocu) throws FlowException {
        Element root = flowDocu.getDocumentElement();
        Element res = XmlUtils.getChild(root, "resource");
        this.buildTitleMap(res, this.titleMap);
        Element flowElement = XmlUtils.getChild(root, "flow");
        Title title = this.titleMap.get(XmlUtils.getAttribute(flowElement, "title"));
        if (null == title) {
            LOGGER.error("No attribute title in tag " + flowElement.getTagName());
            throw new FlowException("No attribute title in tag " + flowElement.getTagName());
        }
        Flow flow = new Flow(title);
        flow.setHelp(XmlUtils.getAttribute(flowElement, "help"));
        this.buildFlowSteps(flow, flowElement);
        this.buildFlowListeners(flow, flowElement);
        return flow;
    }

    private void buildFlowListeners(Flow flow, Element flowElement) throws FlowException {
        String listenersStr = XmlUtils.getAttribute(flowElement, "listeners");
        if (StringUtils.isNULLStr(listenersStr)) {
            return;
        }
        for (String name : listenersStr.split(",")) {
            IFlowListener listener = (IFlowListener)this.getClazzInstance(this.listenerMap, name, true);
            flow.addListener(listener);
        }
    }

    private void buildFlowSteps(Flow flow, Element flowElement) throws FlowException {
        StepContainer stepContainer = new StepContainer(flow);
        int i = 0;
        for (Element em : XmlUtils.getChildren(flowElement)) {
            int stage = i++;
            this.addStage(em, flow, stage);
            this.addStep(em, stepContainer, stage);
        }
    }

    private void addStage(Element em, Flow flow, int stageIndex) throws FlowException {
        Title title = this.titleMap.get(XmlUtils.getAttribute(em, "title"));
        if (null == title) {
            LOGGER.error("No attribute title in tag " + em.getTagName());
            throw new FlowException("No attribute title in tag " + em.getTagName());
        }
        flow.addStage(stageIndex, title);
    }

    private void addStep(Element stepEm, IStepContainer container, int stageIndex) throws FlowException {
        Step step = null;
        String tag = stepEm.getTagName();
        String name = XmlUtils.getAttribute(stepEm, "name");
        if ("step".equals(tag)) {
            step = (Step)this.getClazzInstance(this.stepMap, name);
            this.buildStep(stepEm, step, stageIndex);
            container.addStep(step);
        } else if ("branch".equals(tag)) {
            Branch branch = (Branch)this.getClazzInstance(this.branchMap, name);
            this.addSteps(stepEm, this.toStepContainer(branch), stageIndex);
            this.buildStep(stepEm, branch, stageIndex);
            container.addStep(branch);
        } else if ("sub-flow".equals(tag)) {
            this.addSteps(stepEm, container, stageIndex);
        } else {
            LOGGER.error("Parse flow error, wrong tag:" + tag);
            throw new FlowException("Parse flow error, wrong tag:" + tag);
        }
    }

    private void addSteps(Element parentEm, IStepContainer container, int stageIndex) throws FlowException {
        for (Element element : XmlUtils.getChildren(parentEm)) {
            this.addStep(element, container, stageIndex);
        }
    }

    private void buildTitleMap(Element resEm, Map<String, Title> map) throws FlowException {
        String zh = Locale.CHINESE.getLanguage();
        String en = Locale.ENGLISH.getLanguage();
        for (Element em : XmlUtils.getChildren(resEm, "title")) {
            String id = em.getAttribute("id");
            Title t = new Title();
            t.addName(zh, XmlUtils.getTextContentOfChild(em, "nameZh"));
            t.addName(en, XmlUtils.getTextContentOfChild(em, "nameEn"));
            t.addDesc(zh, XmlUtils.getTextContentOfChild(em, "descZh"));
            t.addDesc(en, XmlUtils.getTextContentOfChild(em, "descEn"));
            map.put(id, t);
        }
    }

    private void buildClazzMap(Element root, String tag, Map<String, Class<?>> clazzMap) throws ClassNotFoundException {
        for (Element step : XmlUtils.getChildren(root, tag)) {
            String name = step.getAttribute("name");
            Class<?> implClazz = this.clsLoader.loadClass(step.getAttribute("implClazz"));
            clazzMap.put(name, implClazz);
        }
    }

    private void buildStep(Element stepEm, Step step, int stageIndex) throws FlowException {
        String isAuto = XmlUtils.getAttribute(stepEm, "isAuto");
        step.setAuto(Boolean.parseBoolean(isAuto));
        String flag = XmlUtils.getAttribute(stepEm, "flag");
        step.setSelectFlag(flag);
        String cond = XmlUtils.getAttribute(stepEm, "condition");
        if (!StringUtils.isNULLStr(cond)) {
            step.setCondition((ICondition)this.getClazzInstance(this.conditionMap, cond));
        }
        step.setStageIndex(stageIndex);
    }

    private Object getClazzInstance(Map<String, Class<?>> map, String key) throws FlowException {
        return this.getClazzInstance(map, key, false);
    }

    private Object getClazzInstance(Map<String, Class<?>> clazzMap, String instanceName, boolean useExistInst) throws FlowException {
        Class<?> cls = clazzMap.get(instanceName);
        if (null == cls) {
            LOGGER.error("No define for " + instanceName);
            throw new FlowException("No define for " + instanceName);
        }
        try {
            Object instance = this.instanceMap.get(cls);
            if (useExistInst && null != instance) {
                return instance;
            }
            instance = cls.newInstance();
            this.instanceMap.put(cls, instance);
            return instance;
        }
        catch (InstantiationException e) {
            LOGGER.error("Instantiate class " + cls + " err", e);
            throw new FlowException("Instantiate class " + cls + " err", e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Constructor of class " + cls + " access error", e);
            throw new FlowException("Constructor of class " + cls + " access error", e);
        }
    }

    private Document getDoc(InputStream inputStream) throws FlowException {
        if (null == inputStream) {
            throw new FlowException("Flow/Define xml InputStream is null.");
        }
        Document doc = null;
        try {
            doc = XmlUtils.parseDocument(inputStream);
        }
        finally {
            StreamUtils.closeStream(null, inputStream);
        }
        return doc;
    }

    private IStepContainer toStepContainer(Branch branch) {
        return new AdaptorStepContainer(branch);
    }

    static class AdaptorStepContainer
    implements IStepContainer {
        private Branch br = null;

        public AdaptorStepContainer(Branch branch) {
            this.br = branch;
        }

        @Override
        public void addStep(Step step) throws FlowException {
            this.br.addOptionalStep(step.getSelectFlag(), step);
        }
    }

    private static class StepContainer
    implements IStepContainer {
        private Flow flow;

        public StepContainer(Flow flow) {
            this.flow = flow;
        }

        @Override
        public void addStep(Step step) {
            this.flow.addStep(step);
        }
    }
}

