/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.net.dhcp;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DHCPAddressPool {
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<String, String> ipAddressPool = new HashMap<String, String>();

    public Map<String, String> getIpaddressMap() {
        this.lock.readLock().lock();
        try {
            Map<String, String> map = this.ipAddressPool;
            return map;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void clearIpaddressPool() {
        this.lock.writeLock().lock();
        try {
            this.ipAddressPool.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public boolean isMacContain(String mac) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.ipAddressPool.containsKey(mac);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void addIpaddr(String mac, String ipaddr) {
        this.lock.writeLock().lock();
        try {
            ipaddr = ipaddr.replaceAll("/", "");
            this.ipAddressPool.put(mac, ipaddr);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String getIpaddrByMac(String mac) {
        this.lock.readLock().lock();
        try {
            String string = this.ipAddressPool.get(mac);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

