/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.net.dhcp.utils;

import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.net.dhcp.utils.DHCPServlet;
import com.huawei.ism.tool.obase.net.dhcp.utils.DHCPServletDispatcherThread;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class DHCPCoreServer
implements Runnable {
    protected static final int PACKET_SIZE = 1500;
    private static final Logger DHCPSERVERLOGGER = ToolLoggerFactory.getLogger(DHCPCoreServer.class);
    private static final int BOUNDED_QUEUE_SIZE = 20;
    private DHCPServlet servlet;
    private ThreadPoolExecutor threadPool;
    private InetSocketAddress sockAddress = null;
    private DatagramSocket serverSocket;
    private boolean stopped = false;

    private DHCPCoreServer(DHCPServlet servlet, InetSocketAddress serverIpaddress) {
        this.servlet = servlet;
        this.sockAddress = serverIpaddress;
    }

    public InetSocketAddress getServerIpaddress() {
        return this.sockAddress;
    }

    public static DHCPCoreServer initServer(DHCPServlet servlet, InetSocketAddress serverIpaddress, boolean isTimeOut, int timeOut) throws ToolException {
        if (servlet == null || serverIpaddress == null) {
            throw new IllegalArgumentException("servlet must not be null");
        }
        DHCPCoreServer server = new DHCPCoreServer(servlet, serverIpaddress);
        server.init(isTimeOut, timeOut);
        return server;
    }

    protected void init(boolean isTimeOut, int timeOut) throws ToolException {
        if (this.serverSocket != null) {
            throw new IllegalStateException("Server already initialized");
        }
        try {
            this.serverSocket = new DatagramSocket(null);
            this.serverSocket.setBroadcast(true);
            this.serverSocket.bind(this.sockAddress);
            if (isTimeOut) {
                this.serverSocket.setSoTimeout(timeOut);
            }
            this.threadPool = new ThreadPoolExecutor(10, 30, 10000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(20), new ServerThreadFactory());
            this.threadPool.prestartAllCoreThreads();
            this.servlet.setServer(this);
        }
        catch (Exception e) {
            this.serverSocket = null;
            DHCPSERVERLOGGER.error("Cannot open socket", e);
            throw new ToolException("Unable to init server", e);
        }
    }

    protected void dispatch() {
        try {
            DatagramPacket requestDatagram = new DatagramPacket(new byte[1500], 1500);
            this.serverSocket.receive(requestDatagram);
            DHCPServletDispatcherThread dispatcher = new DHCPServletDispatcherThread(this, this.servlet, requestDatagram);
            this.threadPool.execute(dispatcher);
        }
        catch (IOException e) {
            DHCPSERVERLOGGER.error("Dispatch package error.", e);
        }
    }

    protected void sendResponse(DatagramPacket responseDatagram) {
        if (responseDatagram == null) {
            DHCPSERVERLOGGER.error("Response datagram is null.");
            return;
        }
        try {
            this.serverSocket.send(responseDatagram);
        }
        catch (IOException e) {
            DHCPSERVERLOGGER.error("Send response error.", e);
        }
    }

    private synchronized boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void run() {
        if (this.serverSocket == null) {
            throw new IllegalStateException("Listening socket is not open - terminating");
        }
        while (!this.isStopped()) {
            try {
                this.dispatch();
            }
            catch (Exception e) {
                DHCPSERVERLOGGER.error("Unexpected Exception", e);
            }
        }
    }

    public synchronized void stopServer() {
        if (!this.stopped) {
            this.stopped = true;
            this.threadPool.shutdown();
            this.serverSocket.close();
        }
    }

    private static class ServerThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix = "DHCPCoreServer-" + POOL_NUMBER.getAndIncrement() + "-thread-";

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, this.namePrefix + this.threadNumber.getAndIncrement());
        }
    }
}

