/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.net.dhcp.utils;

import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.net.dhcp.IIpAddressDispatchStratage;
import com.huawei.ism.tool.obase.net.dhcp.utils.DHCPCoreServer;
import com.huawei.ism.tool.obase.net.dhcp.utils.DHCPOption;
import com.huawei.ism.tool.obase.net.dhcp.utils.DHCPPacket;
import com.huawei.ism.tool.obase.net.dhcp.utils.DHCPResponseFactory;
import com.huawei.ism.tool.obase.net.dhcp.utils.ToolNetUtil;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.slf4j.Logger;

public class DHCPServlet {
    private static final Logger DHCPLOGGER = ToolLoggerFactory.getLogger(DHCPServlet.class);
    private DHCPCoreServer server = null;
    private IIpAddressDispatchStratage ipaddressStratage;

    public DHCPServlet(IIpAddressDispatchStratage ipaddressStratage) {
        this.ipaddressStratage = ipaddressStratage;
    }

    public DHCPPacket serviceDatagram(DatagramPacket requestDatagram) throws ToolException {
        DHCPPacket request = DHCPPacket.getPacket(requestDatagram);
        if (request == null) {
            return null;
        }
        DHCPPacket response = this.service(request);
        return response;
    }

    protected DHCPPacket service(DHCPPacket request) {
        if (this.checkReqInvalid(request)) {
            return null;
        }
        Byte dhcpMessageType = request.getDHCPMessageType();
        if (dhcpMessageType == null) {
            DHCPLOGGER.info("no DHCP message type");
            return null;
        }
        if (1 == request.getOp()) {
            switch (dhcpMessageType) {
                case 1: {
                    return this.doDiscover(request);
                }
                case 3: {
                    if (this.ipaddressStratage.isIpAddressOver()) {
                        return null;
                    }
                    DHCPPacket response = this.doRequest(request);
                    return response;
                }
                case 8: {
                    return this.doInform(request);
                }
                case 4: {
                    return this.doDecline(request);
                }
                case 7: {
                    return this.doRelease(request);
                }
            }
            if (DHCPLOGGER.isInfoEnabled()) {
                DHCPLOGGER.info("Unsupported message type " + dhcpMessageType);
            }
            return null;
        }
        if (request.getOp() == 2) {
            DHCPLOGGER.info("BOOTREPLY received from client");
            return null;
        }
        if (DHCPLOGGER.isInfoEnabled()) {
            DHCPLOGGER.info("Unknown Op: " + request.getOp());
        }
        return null;
    }

    private boolean checkReqInvalid(DHCPPacket request) {
        if (request == null) {
            return true;
        }
        if (!request.isDhcp()) {
            DHCPLOGGER.info("BOOTP packet rejected");
            return true;
        }
        return false;
    }

    protected DHCPPacket doDiscover(DHCPPacket request) {
        String clientMac = request.getChaddrMac();
        if (DHCPLOGGER.isInfoEnabled()) {
            DHCPLOGGER.info("Process discover request to client: " + clientMac);
        }
        DHCPOption option = new DHCPOption(6, this.getServerIp().getAddress().getAddress());
        String netMask = this.ipaddressStratage.getNetMask();
        byte[] mask = ToolNetUtil.getMaskByte(netMask);
        DHCPOption optionMask = new DHCPOption(1, mask);
        DHCPOption[] options = new DHCPOption[]{option, optionMask};
        try {
            String discoverIp = "";
            discoverIp = this.ipaddressStratage.isClientMacInDiscoverPool(clientMac) ? this.ipaddressStratage.getDisocoververIp(clientMac) : this.ipaddressStratage.getNextIp(clientMac);
            if (null == discoverIp) {
                return null;
            }
            DHCPPacket offer = DHCPResponseFactory.makeDHCPOffer(request, InetAddress.getByName(discoverIp), 6, this.getServerIp().getAddress(), "Discover request successful.", options);
            if (DHCPLOGGER.isInfoEnabled()) {
                DHCPLOGGER.info("Send discover package to client: " + clientMac + " response ip: " + discoverIp + " netmask: " + netMask);
            }
            this.ipaddressStratage.addDiscoveredIp(clientMac, discoverIp);
            return offer;
        }
        catch (IOException e) {
            DHCPLOGGER.error("Do discover error.", e);
        }
        catch (ToolException e) {
            DHCPLOGGER.error("Do discover error.", e);
        }
        catch (Exception e1) {
            DHCPLOGGER.error("Do discover error.", e1);
        }
        return null;
    }

    protected DHCPPacket doRequest(DHCPPacket request) {
        DHCPOption oldOption;
        String clientMac = request.getChaddrMac();
        if (DHCPLOGGER.isInfoEnabled()) {
            DHCPLOGGER.info("Process request from client: " + clientMac);
        }
        if (null != (oldOption = request.getOption((byte)50)) && !this.ipaddressStratage.isClientMacInDiscoverPool(clientMac)) {
            InetAddress oldClientIpAddress = oldOption.getValueAsInetAddr();
            if (null != oldClientIpAddress) {
                String oldIPStr = oldClientIpAddress.getHostAddress();
                DHCPLOGGER.error("Client " + clientMac + " already request with ip: " + oldIPStr + ", Response with a nak package.");
            }
            return this.makeNakResponse(request, "You had request a ip last time.Please rediscover again.");
        }
        String discoverIp = this.ipaddressStratage.getDisocoververIp(clientMac);
        if (null == discoverIp) {
            DHCPLOGGER.error("Can not find ip from discover ip pool for client :" + clientMac + ", Send nak package to client.");
            return this.makeNakResponse(request, "Please discover first.");
        }
        DHCPOption serverNameOption = new DHCPOption(6, this.getServerIp().getAddress().getAddress());
        String netMask = this.ipaddressStratage.getNetMask();
        byte[] mask = ToolNetUtil.getMaskByte(netMask);
        DHCPOption maskOption = new DHCPOption(1, mask);
        DHCPOption[] options = new DHCPOption[]{serverNameOption, maskOption};
        try {
            DHCPPacket offer = DHCPResponseFactory.makeDHCPAck(request, InetAddress.getByName(discoverIp), 3600, this.getServerIp().getAddress(), "Request ip address successful.", options);
            offer.setOffer(true);
            return offer;
        }
        catch (ToolException e) {
            DHCPLOGGER.error("Do request error.", e);
        }
        catch (IOException e) {
            DHCPLOGGER.error("Do request error.", e);
        }
        catch (Exception e1) {
            DHCPLOGGER.error("Do request error.", e1);
        }
        return null;
    }

    protected DHCPPacket doInform(DHCPPacket request) {
        String clientMac = request.getChaddrMac();
        if (DHCPLOGGER.isInfoEnabled()) {
            DHCPLOGGER.info("Send inform package to client: " + clientMac);
        }
        DHCPOption option = new DHCPOption(6, this.getServerIp().getAddress().getAddress());
        byte[] mask = ToolNetUtil.getMaskByte(this.ipaddressStratage.getNetMask());
        DHCPOption optionMask = new DHCPOption(1, mask);
        DHCPOption[] options = new DHCPOption[]{option, optionMask};
        try {
            String offerIp = this.ipaddressStratage.getOfferIp(clientMac);
            if (null == offerIp) {
                DHCPLOGGER.error("Can not find offer ip from ip pool for client :" + clientMac + ", Send nak package to client.");
                return this.makeNakResponse(request, "Please discover first.");
            }
            DHCPPacket offer = DHCPResponseFactory.makeDHCPAck(request, InetAddress.getByName(offerIp), 3600, this.getServerIp().getAddress(), "Inform request successful.", options);
            return offer;
        }
        catch (Exception e) {
            DHCPLOGGER.error("Do inform error.", e);
            return null;
        }
    }

    protected DHCPPacket doDecline(DHCPPacket request) {
        if (DHCPLOGGER.isInfoEnabled()) {
            DHCPLOGGER.info("Send decline package to client: " + request.getChaddrMac());
        }
        return null;
    }

    protected DHCPPacket doRelease(DHCPPacket request) {
        if (DHCPLOGGER.isInfoEnabled()) {
            DHCPLOGGER.info("Send release package to client: " + request.getChaddrMac());
        }
        return null;
    }

    private DHCPPacket makeNakResponse(DHCPPacket request, String message) {
        DHCPPacket nakResponse = null;
        try {
            nakResponse = DHCPResponseFactory.makeDHCPNak(request, this.getServerIp().getAddress(), message);
        }
        catch (ToolException e) {
            DHCPLOGGER.error("Anwser nak package error.Nak message :" + message, e);
        }
        return nakResponse;
    }

    protected void postProcess(DatagramPacket requestDatagram, DatagramPacket responseDatagram) {
    }

    public synchronized DHCPCoreServer getServer() {
        return this.server;
    }

    public synchronized InetSocketAddress getServerIp() {
        return this.server.getServerIpaddress();
    }

    public synchronized void setServer(DHCPCoreServer server) {
        this.server = server;
    }

    public void addOfferIP(String mac, String ipAddress) {
        this.ipaddressStratage.addOfferedIp(mac, ipAddress);
    }
}

