/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.processor.cli;

import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.constant.CliCmdModel;
import com.huawei.ism.tool.obase.entity.TSonData;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.processor.ICmdProcessor;
import com.huawei.ism.tool.obase.processor.parser.ICmdReturnParser;
import java.util.List;
import java.util.concurrent.Callable;

public class CliProcessor
implements ICmdProcessor,
Callable<Object> {
    protected static final int NO_TIMEOUT = -1;
    private CliCmdModel cmdModel = null;
    private String description = null;
    private String command = null;
    private String id = "";
    private ICliConnection connection = null;
    private ICmdReturnParser checker = null;

    @Override
    public Object call() throws ToolException {
        return this.execCmd();
    }

    @Override
    public List<TSonData> execCmd() throws ToolException {
        if (null == this.connection) {
            throw new ToolException("The connection of processor which command is \"" + this.getCommand() + "\" is null");
        }
        String cmdReturn = this.executeCli(-1);
        return this.checker.parser(cmdReturn);
    }

    @Override
    public List<TSonData> execCmd(int timeout) throws ToolException {
        if (null == this.connection) {
            throw new ToolException("The connection of processor which command is \"" + this.getCommand() + "\" is null");
        }
        String cmdReturn = this.executeCli(timeout);
        return this.checker.parser(cmdReturn);
    }

    protected String executeCli(int timeout) throws ToolException {
        this.connection.setCLIMode(this.cmdModel);
        String cmdReturn = "";
        cmdReturn = -1 == timeout ? this.connection.execCmd(this.command) : this.connection.execCmdWithTimout(this.command, timeout);
        return cmdReturn;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desp) {
        this.description = desp;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public void setCmdModel(CliCmdModel cmdModel) {
        this.cmdModel = cmdModel;
    }

    public void setChecker(ICmdReturnParser checker) {
        this.checker = checker;
    }

    public void setConnection(ICliConnection connection) {
        this.connection = connection;
    }

    public String getCommand() {
        return this.command;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String str) {
        this.id = str;
    }
}

