/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component.wizard;

import com.huawei.ism.tool.obase.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.util.CommonUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class WizardTitlePane
extends JPanel {
    private static final long serialVersionUID = -5556262082689561118L;
    private static final int CLOSE_BUTTON_RIGHT_SPACE = 15;
    private static final int HELP_BUTTON_RIGHT_SPACE = 10;
    private static final int ICON_SIZE = 16;
    private PropertyChangeListener propertyChangeListener;
    private Action closeAction;
    private Action helpAction;
    private JButton helpButton;
    private JButton closeButton;
    private boolean isShowMinimize;
    private boolean isShowMaxsize;
    private JButton minimizeButton;
    private JButton maxSizeButton;
    private boolean isGetDefaultCollectionParam;
    private WindowListener listener;
    private Window window;
    private JRootPane jRootPane;
    private IHelpActionCallBack helpActionObserver;
    private int originX;
    private int originY;
    private int originWidth;
    private int originHeight;
    private Action minimizeAction;
    private Action maxSizeAction;

    public JButton getCloseButton() {
        return this.closeButton;
    }

    public JButton getHelpButton() {
        return this.helpButton;
    }

    public WizardTitlePane(JRootPane root) {
        this.jRootPane = root;
        this.installSubcomponents();
        this.installDefaults();
    }

    public WizardTitlePane(JRootPane root, boolean isShowMinimize, boolean isShowMaxsize) {
        this.jRootPane = root;
        this.isShowMaxsize = isShowMaxsize;
        this.isShowMinimize = isShowMinimize;
        this.installSubcomponents();
        this.installDefaults();
    }

    public void setHelpActionObserver(IHelpActionCallBack helpObserver) {
        this.helpActionObserver = helpObserver;
    }

    @Override
    public Dimension getPreferredSize() {
        int width = this.jRootPane.getWidth();
        return new Dimension(width, this.computeHeight());
    }

    private int computeHeight() {
        FontMetrics fm = this.jRootPane.getFontMetrics(this.getFont());
        int fontHeight = fm.getHeight();
        int titleBarHeight = UIManager.getInt("IsmDialog.TitleBarHeight");
        int finalHeight = Math.max(fontHeight += 7, titleBarHeight);
        return finalHeight;
    }

    public void uninstall() {
        this.removeListeners();
        this.window = null;
        this.removeAll();
    }

    private void loadListeners() {
        if (this.window != null) {
            this.listener = this.createWindowListener();
            this.window.addWindowListener(this.listener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void removeListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.listener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    public JRootPane getRootPane() {
        return this.jRootPane;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.removeListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            this.setActive(this.window.isActive());
            this.loadListeners();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeListeners();
        this.window = null;
    }

    private void installSubcomponents() {
        this.closeAction = new CloseAction();
        this.helpAction = new HelpAction();
        this.createButtons();
        boolean hasHelpIcon = true;
        Window win = SwingUtilities.getWindowAncestor(this.jRootPane);
        if (win instanceof ToolWizardDialog) {
            hasHelpIcon = ((ToolWizardDialog)win).isHasHelpIcon();
        }
        this.setLayout(new TitlePaneLayout());
        if (!ApplicationContext.getInstance().isCallHomeEnv() && hasHelpIcon) {
            this.add(this.helpButton);
        }
        if (this.isShowMinimize) {
            this.add(this.minimizeButton);
        }
        if (this.isShowMaxsize) {
            this.add(this.maxSizeButton);
        }
        this.add(this.closeButton);
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    private void close() {
        Window win = this.getWindow();
        if (win != null) {
            win.dispatchEvent(new WindowEvent(win, 201));
        }
    }

    private JButton createTitleButton(Action action) {
        JButton btn = new JButton();
        btn.setFocusPainted(false);
        btn.setFocusable(false);
        btn.setOpaque(true);
        btn.setText(null);
        btn.putClientProperty("paintActive", Boolean.TRUE);
        btn.setAction(action);
        btn.setBackground(UIManager.getColor("IsmArmorStyle.BaseColor"));
        btn.setBorderPainted(false);
        btn.setContentAreaFilled(false);
        btn.setIconTextGap(0);
        this.setBackground(UIManager.getColor("IsmArmorStyle.BaseColor"));
        btn.setBounds(0, 0, 16, 16);
        return btn;
    }

    private void createButtons() {
        this.helpButton = this.createTitleButton(this.helpAction);
        this.closeButton = this.createTitleButton(this.closeAction);
        this.setButtonIcon(this.helpButton, "dialog_help_normal", "dialog_help_rollover", "dialog_help_selected");
        this.closeButton = this.createTitleButton(this.closeAction);
        this.setButtonIcon(this.closeButton, "dialog_close_normal", "dialog_close_rollover", "dialog_close_selected");
        if (this.isShowMinimize) {
            this.minimizeAction = new MinimizeAction();
            this.minimizeButton = this.createTitleButton(this.minimizeAction);
            this.setButtonIcon(this.minimizeButton, "titleBar_minimize_normal", "titleBar_minimize_rollover", "titleBar_minimize_selected");
        }
        if (this.isShowMaxsize) {
            this.maxSizeAction = new MaxSizeAction();
            this.maxSizeButton = this.createTitleButton(this.maxSizeAction);
            this.setButtonIcon(this.maxSizeButton, "titleBar_maxsize_normal", "titleBar_maxsize_rollover", "titleBar_maxsize_selected");
        }
    }

    private void setButtonIcon(JButton btn, String normalIconKey, String rolloverIconKey, String selectedIconKey) {
        if (null != btn) {
            String prefix = "TitleBar.";
            Icon normalIcon = UIManager.getIcon(prefix + normalIconKey);
            btn.setIcon(normalIcon);
            btn.setDisabledIcon(normalIcon);
            btn.setName(prefix + normalIconKey);
            Icon rolloverIcon = UIManager.getIcon(prefix + rolloverIconKey);
            btn.setRolloverIcon(rolloverIcon);
            btn.setRolloverSelectedIcon(rolloverIcon);
            btn.setName(prefix + rolloverIconKey);
            Icon selectedIcon = UIManager.getIcon(prefix + selectedIconKey);
            btn.setSelectedIcon(selectedIcon);
            btn.setPressedIcon(selectedIcon);
            btn.setName(prefix + selectedIconKey);
            btn.setPreferredSize(new Dimension(normalIcon.getIconWidth(), normalIcon.getIconHeight()));
        }
    }

    private void setActive(boolean isActive) {
        Boolean activeB = isActive ? Boolean.TRUE : Boolean.FALSE;
        this.closeButton.putClientProperty("paintActive", activeB);
        this.helpButton.putClientProperty("paintActive", activeB);
        this.getRootPane().repaint();
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window dialogWindow = this.getWindow();
        if (dialogWindow instanceof Dialog) {
            return ((Dialog)dialogWindow).getTitle();
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        JRootPane pane = this.getRootPane();
        Window wind = this.getWindow();
        boolean leftToRight = wind == null ? pane.getComponentOrientation().isLeftToRight() : wind.getComponentOrientation().isLeftToRight();
        int width = this.getWidth();
        int height = this.getHeight();
        int xOffset = 0;
        ImageIcon icon = ResourceUtil.getImage("wizard_title_background.png");
        graphics.drawImage(icon.getImage(), 0, 0, width, height, this);
        xOffset += leftToRight ? 11 : -width - 11;
        String title = this.getTitle();
        if (title != null) {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            graphics.setColor(Color.WHITE);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            graphics.drawString(title, xOffset, yOffset);
        }
    }

    private void setMaxBackButton() {
        this.setButtonIcon(this.maxSizeButton, "titleBar_maxsizeback_normal", "titleBar_maxsizeback_rollover", "titleBar_maxsizeback_selected");
    }

    private void setMaxButton() {
        this.setButtonIcon(this.maxSizeButton, "titleBar_maxsize_normal", "titleBar_maxsize_rollover", "titleBar_maxsize_selected");
    }

    private void getDefaultAllocationParam() {
        if (!this.isGetDefaultCollectionParam) {
            this.originWidth = this.getWindow().getWidth();
            this.originHeight = this.getWindow().getHeight();
            this.originX = this.getWindow().getX();
            this.originY = this.getWindow().getY();
            this.isGetDefaultCollectionParam = true;
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            WizardTitlePane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            WizardTitlePane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent changeEvent) {
            String proName = changeEvent.getPropertyName();
            if ("resizable".equals(proName) || "state".equals(proName)) {
                if ("resizable".equals(proName)) {
                    WizardTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(proName)) {
                WizardTitlePane.this.repaint();
            } else if ("componentOrientation".equals(proName)) {
                WizardTitlePane.this.revalidate();
                WizardTitlePane.this.repaint();
            } else if ("iconImage".equals(proName)) {
                WizardTitlePane.this.revalidate();
                WizardTitlePane.this.repaint();
            }
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int height = WizardTitlePane.this.computeHeight();
            return new Dimension(height, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container parent) {
            int buttonHeight = 16;
            int buttonWidth = 16;
            if (WizardTitlePane.this.closeButton != null && WizardTitlePane.this.closeButton.getIcon() != null) {
                buttonHeight = WizardTitlePane.this.closeButton.getIcon().getIconHeight();
                buttonWidth = WizardTitlePane.this.closeButton.getIcon().getIconWidth();
            }
            ArrayList<JButton> buttonList = new ArrayList<JButton>();
            if (WizardTitlePane.this.closeButton != null) {
                buttonList.add(WizardTitlePane.this.closeButton);
            }
            if (WizardTitlePane.this.maxSizeButton != null) {
                buttonList.add(WizardTitlePane.this.maxSizeButton);
            }
            if (WizardTitlePane.this.minimizeButton != null) {
                buttonList.add(WizardTitlePane.this.minimizeButton);
            }
            if (WizardTitlePane.this.helpButton != null) {
                buttonList.add(WizardTitlePane.this.helpButton);
            }
            int spacing = 15;
            boolean leftToRight = WizardTitlePane.this.window == null ? WizardTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : WizardTitlePane.this.window.getComponentOrientation().isLeftToRight();
            int width = WizardTitlePane.this.getWidth();
            int xValue = leftToRight ? width : 0;
            xValue += leftToRight ? -spacing - buttonWidth : spacing;
            int height = WizardTitlePane.this.getHeight();
            int yValue = (height - buttonHeight) / 2;
            for (int i = 0; i < buttonList.size(); ++i) {
                ((JButton)buttonList.get(i)).setBounds(xValue - i * (10 + buttonWidth), yValue, buttonWidth, buttonHeight);
            }
        }
    }

    private class HelpAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private HelpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (null == WizardTitlePane.this.helpActionObserver) {
                return;
            }
            WizardTitlePane.this.helpActionObserver.doHelpActionWork();
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = -2838961894571122928L;

        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            WizardTitlePane.this.close();
        }
    }

    private class MinimizeAction
    extends AbstractAction {
        private static final long serialVersionUID = 3746729890256144263L;

        private MinimizeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFrame frm = (JFrame)CommonUtil.convertObject((Object)WizardTitlePane.this.getWindow().getParent(), JFrame.class);
            frm.setExtendedState(1);
            frm.setVisible(true);
        }
    }

    private class MaxSizeAction
    extends AbstractAction {
        private static final long serialVersionUID = 7715999111584388393L;

        private MaxSizeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFrame frm = (JFrame)CommonUtil.convertObject((Object)WizardTitlePane.this.getWindow().getParent(), JFrame.class);
            WizardTitlePane.this.getDefaultAllocationParam();
            if (frm.getExtendedState() == 0) {
                frm.setExtendedState(6);
                WizardTitlePane.this.getWindow().setBounds(0, 0, (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth(), (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight());
                WizardTitlePane.this.setMaxBackButton();
            } else {
                WizardTitlePane.this.getWindow().setBounds(WizardTitlePane.this.originX, WizardTitlePane.this.originY, WizardTitlePane.this.originWidth, WizardTitlePane.this.originHeight);
                frm.setExtendedState(0);
                WizardTitlePane.this.setMaxButton();
            }
        }
    }
}

