/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.dialogs;

import com.huawei.ism.tool.obase.config.validate.AbstractValidator;
import com.huawei.ism.tool.obase.ui.dialogs.IDialogCallback;
import com.huawei.ism.tool.obase.ui.dialogs.IValidateMsgDisplayer;
import com.huawei.ism.tool.obase.ui.dialogs.IValidatorNameUser;
import com.huawei.ism.tool.obase.ui.dialogs.UiValidator;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public abstract class PublicDialog
extends JDialog
implements IValidatorNameUser {
    private static final long serialVersionUID = 539018767316840745L;
    private JButton okBtn = UiMethod.createButton(ResourceUtil.getString("text.ok"), 'O');
    private JButton cancelBtn = UiMethod.createButton(ResourceUtil.getString("text.cancel"), 'C');
    private JPanel contentPanel = new JPanel();
    private JButton helpBtn = UiMethod.createButton(ResourceUtil.getString("text.help"), 'H');
    private IDialogCallback parentComponent = null;
    private JButton appBtn = UiMethod.createButton(ResourceUtil.getString("text.apply"), 'P');
    private JPanel btnPanel = new JPanel();
    private Component marginComp = Box.createHorizontalStrut(10);
    private Component helpComp = Box.createHorizontalStrut(12);
    private Component cancelComp = Box.createHorizontalStrut(12);
    private UiValidator validator = new UiValidator();
    private boolean isSupAppBtn = false;

    public PublicDialog() {
        this.initComponment();
        this.initCancelBtnListener();
    }

    public PublicDialog(JDialog parent) {
        super(parent);
        this.initComponment();
        this.initCancelBtnListener();
    }

    public PublicDialog(JDialog parent, boolean isSupAppBtn) {
        super(parent);
        this.isSupAppBtn = isSupAppBtn;
        this.initComponment();
        this.initCancelBtnListener();
    }

    public PublicDialog(JFrame parent) {
        super(parent);
        this.initComponment();
        this.initCancelBtnListener();
    }

    public PublicDialog(JFrame parent, boolean isSupAppBtn) {
        super(parent);
        this.isSupAppBtn = isSupAppBtn;
        this.initComponment();
        this.initCancelBtnListener();
    }

    public PublicDialog(Window parent, Image image) {
        super(parent);
        this.setIconImage(image);
        this.initComponment();
        this.initCancelBtnListener();
    }

    public PublicDialog(Window parent) {
        super(parent);
        this.initComponment();
        this.initCancelBtnListener();
    }

    public PublicDialog(Window parent, boolean isSupAppBtn) {
        super(parent);
        this.isSupAppBtn = isSupAppBtn;
        this.initComponment();
        this.initCancelBtnListener();
    }

    public void showCloseButton() {
        this.okBtn.setVisible(false);
        this.cancelBtn.setText(ResourceUtil.getString("toolbase.public.dialog.txt.close"));
    }

    @Override
    public void doNoting() {
    }

    private void initUI() {
        JComponent btnComp = this.buildBtnPanel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JSeparator sp = new JSeparator();
        jPanel.add((Component)sp, "North");
        jPanel.add((Component)btnComp, "East");
        jPanel.add((Component)this.getBtnPanel(), "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.contentPanel);
        this.getContentPane().add((Component)jPanel, "South");
    }

    protected void initComponment() {
        this.initUI();
        this.setCompNames();
    }

    protected JPanel getBtnPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        return buttonPanel;
    }

    protected JComponent buildBtnPanel() {
        this.btnPanel.setLayout(new BoxLayout(this.btnPanel, 0));
        this.btnPanel.add(Box.createHorizontalGlue());
        this.btnPanel.add(this.okBtn);
        this.btnPanel.add(Box.createHorizontalStrut(10));
        this.btnPanel.add(this.appBtn);
        this.btnPanel.add(this.marginComp);
        this.btnPanel.add(this.cancelBtn);
        this.btnPanel.add(this.cancelComp);
        this.btnPanel.add(this.helpBtn);
        this.btnPanel.add(this.helpComp);
        if (this.isSupAppBtn) {
            this.setAppButtonVisible(true);
            this.setHelpButtonVisiable(true);
        } else {
            this.setAppButtonVisible(false);
            this.setHelpButtonVisiable(false);
        }
        return UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(0), this.btnPanel, Box.createVerticalStrut(0)});
    }

    public void setAppButtonVisible(boolean isVisible) {
        if (!isVisible) {
            this.appBtn.setVisible(isVisible);
            this.btnPanel.remove(this.marginComp);
            this.btnPanel.remove(this.appBtn);
        }
    }

    public void setCancelButtonVisible(boolean isVisible) {
        if (!isVisible) {
            this.cancelBtn.setVisible(isVisible);
            this.btnPanel.remove(this.cancelComp);
            this.btnPanel.remove(this.cancelBtn);
        }
    }

    public void setHelpButtonVisiable(boolean isVisiable) {
        if (!isVisiable) {
            this.helpBtn.setVisible(isVisiable);
            this.btnPanel.remove(this.helpComp);
            this.btnPanel.remove(this.helpBtn);
        }
    }

    protected void initCancelBtnListener() {
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PublicDialog.this.dispose();
            }
        });
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public void setCompNames() {
        this.okBtn.setName("_Button_okBtn");
        this.cancelBtn.setName("_Button_cancelBtn");
        this.helpBtn.setName("_Button_helpBtn");
        this.appBtn.setName("_Button_appBtn");
    }

    public void addValidation(JComponent comp, JLabel lable, String validatorName, Object ... params) {
        this.validator.addValidation(comp, lable, validatorName, params);
    }

    public void addValidations(JComponent comp, JLabel lable, String ... validatorNames) {
        this.validator.addValidations(comp, lable, validatorNames);
    }

    protected void addValidation(JComponent comp, JLabel lable, AbstractValidator abstractValidator, Object ... params) {
        this.validator.addValidation(comp, lable, abstractValidator, params);
    }

    protected void addValidations(JComponent comp, JLabel lable, AbstractValidator ... vs) {
        this.validator.addValidations(comp, lable, vs);
    }

    protected void addValidator(AbstractValidator av) {
        this.validator.append(av);
    }

    protected boolean validateInput() {
        return this.validator.validateInput(this);
    }

    protected boolean validateInput(IValidateMsgDisplayer msgDisplayer) {
        return this.validator.validateInput(msgDisplayer);
    }

    public JButton getAppBtn() {
        return this.appBtn;
    }

    public JButton getOkBtn() {
        return this.okBtn;
    }

    public void setOkBtn(JButton okBtn) {
        this.okBtn = okBtn;
    }

    public IDialogCallback getParentComponent() {
        return this.parentComponent;
    }

    public void setParentComponent(IDialogCallback parentComponent) {
        this.parentComponent = parentComponent;
    }

    public JButton getCancelBtn() {
        return this.cancelBtn;
    }

    public void setCancelBtn(JButton cancelBtn) {
        this.cancelBtn = cancelBtn;
    }

    public void setContentPanel(JPanel contentPanel) {
        this.contentPanel = contentPanel;
    }

    public void removeButPanel() {
        this.getContentPane().removeAll();
        this.getContentPane().add(this.contentPanel);
    }

    private static class ButtonPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private ButtonPanel() {
        }

        @Override
        public void paint(Graphics graphics) {
            Color oldColor = graphics.getColor();
            graphics.setColor(new Color(0xD6D6D6));
            graphics.fillRect(0, this.getHeight() - 4, this.getWidth(), 4);
            graphics.setColor(oldColor);
            super.paint(graphics);
        }
    }
}

