/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.dialogs;

import com.huawei.ism.tool.obase.config.resource.PromptResource;
import com.huawei.ism.tool.obase.config.validate.AbstractValidator;
import com.huawei.ism.tool.obase.config.validate.CommonValidators;
import com.huawei.ism.tool.obase.config.validate.ValidatorChain;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.dialogs.IValidateMsgDisplayer;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IPAddressField;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;

public class UiValidator {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(UiValidator.class);
    private static final Map<String, Class<? extends AbstractValidator>> VCLASSMAP = new HashMap<String, Class<? extends AbstractValidator>>();
    private ValidatorChain customizedValidators = new ValidatorChain();
    private List<ComponentValidation> compValidations = new ArrayList<ComponentValidation>();

    public void addValidation(JComponent component, JLabel lable, String validatorName, Object ... params) {
        AbstractValidator av = this.newValidatorInstance(validatorName);
        if (null != av) {
            ComponentValidation cv = new ComponentValidation(component, lable.getText(), av, params);
            this.compValidations.add(cv);
        }
    }

    public void addValidations(JComponent component, JLabel lable, String ... validatorNames) {
        ArrayList<AbstractValidator> validators = new ArrayList<AbstractValidator>();
        for (String vName : validatorNames) {
            AbstractValidator av = this.newValidatorInstance(vName);
            if (null == av) continue;
            validators.add(av);
        }
        AbstractValidator[] vArr = new AbstractValidator[validators.size()];
        this.addValidations(component, lable, validators.toArray(vArr));
    }

    public void addValidation(JComponent component, JLabel lable, AbstractValidator validator, Object ... params) {
        ComponentValidation cv = new ComponentValidation(component, lable.getText(), validator, params);
        this.compValidations.add(cv);
    }

    public void addValidations(JComponent component, JLabel lable, AbstractValidator ... validators) {
        ValidatorChain vChain = new ValidatorChain(Arrays.asList(validators));
        this.addValidation(component, lable, vChain, new Object[0]);
    }

    public void append(AbstractValidator validator) {
        this.customizedValidators.append(validator, new Object[0]);
    }

    public boolean validateInput(Window parent) {
        return this.validateInput(new ValidateMsgDisplayer(parent));
    }

    public boolean validateInput(IValidateMsgDisplayer msgDisplayer) {
        boolean valid = true;
        PromptResource.setLoc(new Locale(ApplicationContext.getInstance().getCurrentLanguage().getLanguage()));
        JComponent component = null;
        AbstractValidator validator = null;
        String value = "";
        for (ComponentValidation cv : this.compValidations) {
            component = cv.getComponent();
            validator = cv.getValidator();
            if (component instanceof JTextComponent) {
                value = ((JTextComponent)component).getText();
            } else if (component instanceof IPAddressField) {
                String ip = ((IPAddressField)component).getIPText();
                value = ip = ip.trim().replace(". . .", "");
            }
            if (validator.validate(value, cv.getName(), cv.getParams())) continue;
            valid = false;
            msgDisplayer.display(validator.getErrMsg());
            component.requestFocusInWindow();
            break;
        }
        if (valid && !(valid = this.customizedValidators.validate(null, null, new Object[0]))) {
            msgDisplayer.display(this.customizedValidators.getErrMsg());
        }
        return valid;
    }

    private AbstractValidator newValidatorInstance(String vName) {
        Class<? extends AbstractValidator> validatorClass = VCLASSMAP.get(vName);
        if (null == validatorClass) {
            return null;
        }
        try {
            return validatorClass.newInstance();
        }
        catch (InstantiationException e1) {
            LOGGER.error("Instantiation exception.", e1);
        }
        catch (IllegalAccessException e1) {
            LOGGER.error("Illegal access exception.", e1);
        }
        return null;
    }

    static {
        VCLASSMAP.put("CommonValidators.NotNull", CommonValidators.NotNull.class);
        VCLASSMAP.put("CommonValidators.NoChinese", CommonValidators.NoChinese.class);
        VCLASSMAP.put("CommonValidators.Mask", CommonValidators.Mask.class);
        VCLASSMAP.put("CommonValidators.Mac", CommonValidators.Mac.class);
        VCLASSMAP.put("CommonValidators.Macs", CommonValidators.Macs.class);
        VCLASSMAP.put("CommonValidators.Ipv4", CommonValidators.Ipv4.class);
        VCLASSMAP.put("CommonValidators.Max", CommonValidators.Max.class);
        VCLASSMAP.put("CommonValidators.Ipv4v6", CommonValidators.Ipv4v6.class);
    }

    private static class ComponentValidation {
        private JComponent component;
        private String name;
        private Object[] params;
        private AbstractValidator validator;

        public ComponentValidation(JComponent component, String name, AbstractValidator validator, Object ... params) {
            this.component = component;
            this.validator = validator;
            this.params = params;
            this.name = name.endsWith(":") ? name.substring(0, name.length() - 1) : name;
        }

        public JComponent getComponent() {
            return this.component;
        }

        public String getName() {
            return this.name;
        }

        public Object[] getParams() {
            return this.params;
        }

        public AbstractValidator getValidator() {
            return this.validator;
        }
    }

    private static class ValidateMsgDisplayer
    implements IValidateMsgDisplayer {
        private Window parent;

        public ValidateMsgDisplayer(Window parent) {
            this.parent = parent;
        }

        @Override
        public void display(String msg) {
            DialogUtils.showInfoDialog((Window)this.parent, (String)msg);
        }
    }
}

