/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.wizard;

import com.huawei.ism.tool.obase.entity.KeyValue;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.flow.FlowFactory;
import com.huawei.ism.tool.obase.flow.ui.Title;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.ui.wizard.FlowWizardDialog;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.text.IsmTextArea;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRadioButton;

public class FlowSelectionDialog
extends PublicDialog {
    public static final String PARARM_FLOW_TITLE = "flow_title";
    public static final String PARARM_LAN_LOCALE = "lan_locale";
    public static final String PARARM_CLS_LOADER = "clsLoader";
    public static final String PARARM_SELECTLISTENER = "selectListener";
    private transient List<FlowFactory> factoryList = new ArrayList<FlowFactory>();
    private Locale loc = null;
    private IFlowSelectListener selectListener = null;
    private transient FlowFactory selectedFactory = null;
    private JFrame parent = null;
    private transient Image image;

    public FlowSelectionDialog(JFrame parent, Map<String, Object> params, List<KeyValue<InputStream, InputStream>> flowList, Image image) {
        super((Window)parent, image);
        this.parent = parent;
        this.loc = (Locale)params.get(PARARM_LAN_LOCALE);
        this.selectListener = (IFlowSelectListener)params.get(PARARM_SELECTLISTENER);
        this.image = image;
        for (KeyValue<InputStream, InputStream> flow : flowList) {
            this.factoryList.add(new FlowFactory(flow.getKey(), flow.getValue(), (ClassLoader)params.get(PARARM_CLS_LOADER)));
        }
        this.setResizable(false);
        this.setHelpButtonVisiable(false);
        this.setAppButtonVisible(false);
        this.setTitle(String.valueOf(params.get(PARARM_FLOW_TITLE)));
        this.setModal(true);
        if (flowList.size() > 1) {
            this.initUI();
            this.initListeners();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            super.setVisible(false);
            return;
        }
        if (this.factoryList.size() > 1) {
            super.setVisible(true);
        } else if (this.factoryList.size() == 1) {
            this.showFlow(this.factoryList.get(0));
        }
    }

    private void showFlow(FlowFactory flowFactory) {
        FlowWizardDialog wizard = null;
        try {
            wizard = new FlowWizardDialog((Window)this.parent, this.loc, flowFactory, this.image);
        }
        catch (ToolException e) {
            DialogUtils.showErrorDialog((JDialog)this, (String)e.getErrorLocaleDescription());
            return;
        }
        if (null != this.selectListener) {
            this.selectListener.fireFlowSelected(wizard);
        }
        wizard.setSize(this.getSize());
        wizard.setLocation(this.getLocation());
        wizard.setVisible(true);
    }

    private void initUI() {
        this.getContentPanel().setLayout(new BorderLayout());
        this.getContentPanel().add((Component)UiMethod.buildFrameSpace(this.buildFlowSelectPanel(), 12), "North");
    }

    private JComponent buildFlowSelectPanel() {
        ButtonGroup btnGroup = new ButtonGroup();
        Component[] compArr = new JComponent[this.factoryList.size() * 3];
        int compArrIdx = 0;
        for (FlowFactory flowFactory : this.factoryList) {
            Title title = flowFactory.getFlowTitle();
            if (null == title) continue;
            JRadioButton rdBtn = new JRadioButton(title.getName(this.loc));
            btnGroup.add(rdBtn);
            this.bindSelectListener(rdBtn, flowFactory);
            compArr[compArrIdx++] = UCD.buildHorizotalBox(null, (Component[])new Component[]{rdBtn, Box.createHorizontalGlue()});
            IsmTextArea descTxt = UCD.createTextArea((String)title.getDesc(this.loc));
            compArr[compArrIdx++] = UCD.buildHorizotalBox(null, (Component[])new Component[]{Box.createHorizontalStrut(12), descTxt});
            compArr[compArrIdx++] = Box.createVerticalStrut(12);
        }
        btnGroup.getElements().nextElement().setSelected(true);
        this.selectedFactory = this.factoryList.get(0);
        return UCD.buildVerticalBox(null, (Component[])compArr);
    }

    private void bindSelectListener(JRadioButton btn, final FlowFactory flowFactory) {
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                FlowSelectionDialog.this.selectedFactory = flowFactory;
            }
        });
    }

    private void initListeners() {
        JButton okBtn = this.getOkBtn();
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent paramActionEvent) {
                FlowSelectionDialog.this.doOk();
            }
        });
    }

    private void doOk() {
        this.setVisible(false);
        this.dispose();
        this.showFlow(this.selectedFactory);
    }

    private void readObject(ObjectInputStream inStream) {
    }

    public static interface IFlowSelectListener
    extends Serializable {
        public void fireFlowSelected(FlowWizardDialog var1);
    }
}

