/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.obase.info.monitorenter.util.encoding.EncodingDetect;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonEncodeDetectUtils {
    private static final String DEFAUL_CODE = "Unicode";
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonEncodeDetectUtils.class);
    private static final int BOM_SIZE = 4;

    public static String endcodeDetect(String filePath) throws Exception {
        if (null != filePath) {
            return CommonEncodeDetectUtils.endcodeDetect(new File(filePath));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String endcodeDetect(File file) throws Exception {
        if (null == file || !file.exists()) {
            LOGGER.info("***[file not exist]***");
            throw new Exception("file not exist");
        }
        FileInputStream input = new FileInputStream(file);
        String encoding = DEFAUL_CODE;
        byte[] bom = new byte[4];
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the result is:" + ((InputStream)input).read(bom, 0, 4));
            }
            if (StringUtils.isNULLStr(encoding = CommonEncodeDetectUtils.encodeDetectByBom(bom))) {
                encoding = EncodingDetect.detect(file);
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("***[encoding= " + encoding + "***]");
            }
        }
        catch (Exception e) {
            LOGGER.error("***[encode detect error]***", e);
        }
        finally {
            StreamUtils.closeStream(null, input);
        }
        if (StringUtils.isNULLStr(encoding)) {
            encoding = DEFAUL_CODE;
        }
        return encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodeDetectByBom(File file) {
        if (null == file || !file.exists()) {
            LOGGER.info("***[file not exist]***");
            return "";
        }
        FileInputStream input = null;
        try {
            String encoding;
            input = new FileInputStream(file);
            byte[] bom = new byte[4];
            String string = encoding = CommonEncodeDetectUtils.encodeDetectByBom(bom);
            return string;
        }
        catch (Exception e) {
            LOGGER.error("***[encode detect error]***", e);
            String string = "";
            return string;
        }
        finally {
            StreamUtils.closeStream(null, input);
        }
    }

    private static String encodeDetectByBom(byte[] bom) {
        String encoding = "";
        if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            encoding = "UTF-32BE";
        } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            encoding = "UTF-32LE";
        } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            encoding = "UTF-8";
        } else if (bom[0] == -2 && bom[1] == -1) {
            encoding = "UTF-16BE";
        } else if (bom[0] == -1 && bom[1] == -2) {
            encoding = "UTF-16LE";
        } else {
            LOGGER.info("can not detect code by bom.");
        }
        return encoding;
    }
}

