/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.framework.pubservice.entity.enums.SVPModuleInfo;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DeviceType;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.CliResolverUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;

public final class DeviceTypeUtil {
    public static final String LDAP_USER_NAME_PREFIX = "domain/";
    static List<String> NEW_DORADO_LIST = Arrays.asList("OceanStor 2910", "OceanStor 5310", "OceanStor 5510", "OceanStor 5510S", "OceanStor 5610", "OceanStor 5810-HS", "OceanStor 6810", "OceanStor 18510", "OceanStor 18500K", "OceanStor 18810", "OceanStor 5300K", "OceanStor 5500K", "OceanStor 5320", "OceanStor 2200", "OceanStor 2220", "OceanStor 5120", "OceanStor 2600", "OceanStor 2620", "OceanStor 5210", "OceanStor 5220", "OceanStor 5310 Capacity Flash", "OceanStor 5510 Capacity Flash", "OceanStor A300");
    private static final String[] HVS_KEY_ARR = new String[]{"HVS", "18800", "18500", "18800F"};
    private static final String[] NO_SVP_VERSION_KEYS = new String[]{"kunpeng"};
    private static final String OCEAN_DORADO_SERIES_KEY = "OceanStor Dorado";
    private static final List<String> MICRO_TYPES = Arrays.asList("OceanStor Micro 1300", "OceanStor Micro 1500", "OceanDisk 1600", "OceanDisk 1300", "OceanDisk 1500", "OceanDisk 1500T", "OceanDisk 1600T", "OceanDisk 1610", "OceanDisk 1610T");
    private static final String CHANGETODEVELOPER = "change user_mode current_mode user_mode=developer";
    private static final String EXIT = "exit";
    private static final String DEVELOPER = "developer:/>";
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DeviceTypeUtil.class);
    private static final String ARRT_SEP = ":";
    private static final String LINE_SEP = System.lineSeparator();

    private DeviceTypeUtil() {
    }

    public static boolean isHVS(DeviceType type) {
        if (null == type) {
            return false;
        }
        return DeviceTypeUtil.isHVS(type.toString());
    }

    public static boolean isHVS(String devType) {
        if (null == devType) {
            return false;
        }
        for (String hvsKey : HVS_KEY_ARR) {
            if (!devType.contains(hvsKey)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDeviceHasSVPModule(String productVersion, String deviceType) {
        if (deviceType == null) {
            return false;
        }
        if (!DeviceTypeUtil.isHVS(deviceType)) {
            return false;
        }
        for (String noSvpVersionKey : NO_SVP_VERSION_KEYS) {
            if (StringUtils.isNULLStr(productVersion) || !productVersion.toUpperCase(Locale.ENGLISH).contains(noSvpVersionKey.toUpperCase(Locale.ENGLISH))) continue;
            return false;
        }
        if (deviceType.toUpperCase(Locale.ENGLISH).contains(OCEAN_DORADO_SERIES_KEY.toUpperCase(Locale.ENGLISH))) {
            return false;
        }
        return !NEW_DORADO_LIST.contains(deviceType) && !MICRO_TYPES.contains(deviceType);
    }

    public static boolean isDeviceHasSVPModule(String productVersion, String deviceType, boolean hasSVP) {
        if (deviceType == null) {
            return false;
        }
        if (!hasSVP) {
            return false;
        }
        for (String noSvpVersionKey : NO_SVP_VERSION_KEYS) {
            if (StringUtils.isNULLStr(productVersion) || !productVersion.toUpperCase(Locale.ENGLISH).contains(noSvpVersionKey.toUpperCase(Locale.ENGLISH))) continue;
            return false;
        }
        return !deviceType.toUpperCase(Locale.ENGLISH).contains(OCEAN_DORADO_SERIES_KEY.toUpperCase(Locale.ENGLISH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SvpOptional isSupportSVPCmd(ICliConnection con) {
        boolean enterDeveloperMode = DeviceTypeUtil.changeDeveloperMode(con);
        if (!enterDeveloperMode) {
            LOGGER.info("change user mode to developer failed.");
            return SvpOptional.EXCEPTION;
        }
        String querySVPSupportCmd = "show svp support";
        try {
            String cliResult = con.execCmdWithTimout(querySVPSupportCmd, 15);
            String cliResultNorm = Normalizer.normalize(cliResult, Normalizer.Form.NFKC);
            if (CliResolverUtils.isCLIResultInValid(cliResultNorm)) {
                LOGGER.info(" Does not support SVP Optional!");
                SvpOptional svpOptional = SvpOptional.NOT_SUPPORT;
                return svpOptional;
            }
            String[] lines = cliResultNorm.split(LINE_SEP);
            String isSVPEnabled = "";
            for (String line : lines) {
                if (!line.contains(ARRT_SEP)) continue;
                String[] attrVal = line.split(ARRT_SEP);
                isSVPEnabled = attrVal.length > 1 ? attrVal[1] : "";
                break;
            }
            if (isSVPEnabled.trim().equalsIgnoreCase("yes")) {
                LOGGER.info("Support SVP Optional, and svp is enabled!");
                SvpOptional svpOptional = SvpOptional.SUPPORT_YES;
                return svpOptional;
            }
            if (isSVPEnabled.trim().equalsIgnoreCase("no")) {
                LOGGER.info("Support SVP Optional, but svp is not enabled!");
                SvpOptional svpOptional = SvpOptional.SUPPORT_NO;
                return svpOptional;
            }
        }
        catch (ToolException e) {
            LOGGER.error("Query svp support info error!", e);
            SvpOptional svpOptional = SvpOptional.EXCEPTION;
            return svpOptional;
        }
        finally {
            DeviceTypeUtil.exitDeveloperMode(con);
        }
        LOGGER.error("Query svp support info exception!");
        return SvpOptional.EXCEPTION;
    }

    private static void exitDeveloperMode(ICliConnection con) {
        try {
            con.execCmd(EXIT);
        }
        catch (ToolException e) {
            LOGGER.error("exit\u3000developer exception!", e);
        }
    }

    public static boolean changeDeveloperMode(ICliConnection con) {
        boolean enterDeveloperMode = false;
        try {
            String sshResult = "";
            sshResult = con.execCmdWithTimout(CHANGETODEVELOPER, 15);
            sshResult = Normalizer.normalize(sshResult, Normalizer.Form.NFKC);
            for (int i = 0; i <= 2; ++i) {
                if (sshResult.trim().toLowerCase(Locale.ENGLISH).endsWith("(y/n)")) {
                    sshResult = con.execCmd("y");
                }
                if (!sshResult.contains(DEVELOPER)) continue;
                enterDeveloperMode = true;
                break;
            }
        }
        catch (ToolException e) {
            LOGGER.error("change user mode to developer failed...", e);
        }
        catch (NullPointerException e) {
            LOGGER.error("change user mode to developer failed...", e);
        }
        return enterDeveloperMode;
    }

    public static boolean hasSVPModule(DevNode devNode) {
        if (null == devNode || null == devNode.getDeviceType()) {
            return false;
        }
        boolean hasSVP = SVPModuleInfo.OLD_TOOLBOX.getName().equalsIgnoreCase(devNode.getHighDevSVPModuleInfo()) ? DeviceTypeUtil.isDeviceHasSVPModule(devNode.getProductVersion(), devNode.getDeviceType().toString()) : DeviceTypeUtil.isDeviceHasSVPModule(devNode.getProductVersion(), devNode.getDeviceType().toString(), SVPModuleInfo.NEW_TOOLBOX_HASSVP.getName().equalsIgnoreCase(devNode.getHighDevSVPModuleInfo()));
        return hasSVP;
    }

    public static enum SvpOptional {
        NOT_SUPPORT,
        SUPPORT_YES,
        SUPPORT_NO,
        EXCEPTION;

    }
}

