/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.in.CommonMethod;
import com.huawei.ism.tool.obase.utils.in.ComponentDefine;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileAssistant {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileAssistant.class);
    private static final int EXECUTE_COMPRESS_SUCCESS = 1;
    private static final int EXECUTE_COMPRESS_FAILD = -1;
    private static final int MAX_NUM = 99999;
    private static final String CMD_TAR = "\"%s\" a -ttar \"%s\" -r \"%s\"";
    private static final String CMD_GZ = "\"%s\" a -tgzip \"%s\" \"%s\"";

    private FileAssistant() {
    }

    public static void clearDir(String dir) {
        if (StringUtils.isNULLStr(dir)) {
            return;
        }
        File file = new File(dir);
        if (!file.exists()) {
            return;
        }
        FileUtils.deleteFile((File)file);
    }

    public static String getRandomTmpDir(String preFix) {
        if (StringUtils.isNULLStr(preFix)) {
            return "";
        }
        SecureRandom rad = new SecureRandom();
        int nextIntValue = rad.nextInt(99999);
        String ret = preFix + "_" + nextIntValue;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFileContent(String filePath) {
        if (StringUtils.isNULLStr(filePath)) {
            return "";
        }
        FileInputStream in = null;
        String str = "";
        try {
            in = new FileInputStream(filePath);
            int len = in.available();
            byte[] bs = new byte[len];
            if (in.read(bs) <= 0) {
                String string = str;
                return string;
            }
            str = new String(bs, Charset.defaultCharset());
        }
        catch (IOException e) {
            LOGGER.error("Get file content error.", e);
        }
        catch (Exception e1) {
            LOGGER.error("Get file content error.", e1);
        }
        finally {
            StreamUtils.closeStream(null, in);
        }
        return str;
    }

    public static void clearEmptyLogFile() {
        String workPath = ApplicationContext.getInstance().getWorkPath();
        File logDir = new File(workPath + File.separator + "logs" + File.separator + "runlog");
        File[] logsFiles = logDir.listFiles();
        if (null == logsFiles) {
            return;
        }
        for (File file : logsFiles) {
            if (0L != file.length() || file.delete()) continue;
            LOGGER.error("Delete file: " + file.getName() + " error!");
        }
    }

    public static synchronized boolean compressFile7z(String aimFileName, String ... sourceDir) {
        if (StringUtils.hasNULLStr(sourceDir) || StringUtils.isNULLStr(aimFileName)) {
            LOGGER.info("path is null.");
            return false;
        }
        StringBuffer sb = new StringBuffer();
        for (String file : sourceDir) {
            sb.append(ComponentDefine.getMarks() + file + ComponentDefine.getMarks() + " ");
        }
        StringBuffer cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(" a -t7z").append(" ").append(ComponentDefine.getMarks()).append(aimFileName).append(ComponentDefine.getMarks()).append(" ").append(sb.toString());
        if (!FileAssistant.executeCmd(cmd.toString(), true)) {
            LOGGER.error("Compress " + sb.toString() + " error");
            return false;
        }
        return true;
    }

    public static synchronized boolean compressFile7zByMX0(String resultsFileName, String ... sourceDirs) {
        if (StringUtils.hasNULLStr(sourceDirs) || StringUtils.isNULLStr(resultsFileName)) {
            LOGGER.error("path is null.");
            return false;
        }
        StringBuffer sb = new StringBuffer();
        for (String file : sourceDirs) {
            sb.append(ComponentDefine.getMarks() + file + ComponentDefine.getMarks() + " ");
        }
        StringBuffer cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(" a -t7z -mx0").append(" ").append(ComponentDefine.getMarks()).append(resultsFileName).append(ComponentDefine.getMarks()).append(" ").append(sb.toString());
        if (!FileAssistant.executeCmd(cmd.toString(), true)) {
            LOGGER.error("Compress " + sb.toString() + " error");
            return false;
        }
        return true;
    }

    public static synchronized boolean compressDirTo7ZFile(String resultsFileName, String sourceDirs, String zipRule) {
        if (StringUtils.hasNULLStr(sourceDirs) || StringUtils.isNULLStr(resultsFileName)) {
            LOGGER.error("path is null.");
            return false;
        }
        String cmdTemp = "\"%s\" a %s \"%s\" \"%s\"";
        String cmd = String.format(Locale.ROOT, cmdTemp, FileAssistant.get7zPath(), zipRule, resultsFileName, sourceDirs);
        String result = "";
        try {
            result = FileAssistant.executeCmdAndGetResult(cmd, true);
        }
        catch (Exception e) {
            LOGGER.error("7z compress error", e);
            return false;
        }
        if (FileAssistant.isNotContainError(result)) {
            return true;
        }
        if (FileAssistant.isOccuredTmpFile(result)) {
            return FileAssistant.renameMiddleFile(resultsFileName);
        }
        return false;
    }

    public static synchronized ArrayList<String> compressDirTo7ZFileWithResDump(String resultsFileName, String sourceDirs, String zipRule) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (StringUtils.isNULLStr(sourceDirs) || StringUtils.isNULLStr(resultsFileName)) {
            LOGGER.error("path is null.");
            resultList.add("false");
            resultList.add("");
            return resultList;
        }
        String cmdTemp = "\"%s\" a %s \"%s\" \"%s\"";
        String cmd = String.format(Locale.ROOT, cmdTemp, FileAssistant.get7zPath(), zipRule, resultsFileName, sourceDirs);
        String result = "";
        try {
            result = FileAssistant.executeCmdAndGetResult(cmd, true);
        }
        catch (IOException e) {
            LOGGER.error("7z compress error", e);
            resultList.add("false");
            resultList.add(result);
            return resultList;
        }
        if (FileAssistant.isNotContainError(result) || FileAssistant.isOccuredTmpFile(result) && FileAssistant.renameMiddleFile(resultsFileName)) {
            resultList.add("true");
            resultList.add(result);
            return resultList;
        }
        resultList.add("false");
        resultList.add(result);
        return resultList;
    }

    private static boolean isOccuredTmpFile(String result) {
        return result.contains(".tmp") && result.contains("move");
    }

    private static boolean renameMiddleFile(String sourceFilePath) {
        LOGGER.info("rename {}.tmp", (Object)sourceFilePath);
        File middleFile = new File(sourceFilePath + ".tmp");
        if (!middleFile.exists()) {
            return false;
        }
        File sourceFile = new File(sourceFilePath);
        if (sourceFile.exists()) {
            FileUtils.deleteFile((File)sourceFile);
        }
        for (int i = 0; i < 3; ++i) {
            if (middleFile.renameTo(sourceFile)) {
                return true;
            }
            LOGGER.info("rename {}.tmp fail, sleep 3 seconds", (Object)sourceFile);
            ConnUtils.sleep(3000);
        }
        return false;
    }

    public static synchronized boolean compressFileZipSaveMode(String aimFileName, String ... sourceDir) {
        if (StringUtils.hasNULLStr(sourceDir) || StringUtils.isNULLStr(aimFileName)) {
            LOGGER.info("path is null.");
            return false;
        }
        StringBuffer sb = new StringBuffer();
        for (String file : sourceDir) {
            sb.append(ComponentDefine.getMarks() + file + ComponentDefine.getMarks() + " ");
        }
        StringBuffer cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(" a -tzip -mx0").append(" ").append(ComponentDefine.getMarks()).append(aimFileName).append(ComponentDefine.getMarks()).append(" ").append(sb.toString());
        if (!FileAssistant.executeCmd(cmd.toString(), true)) {
            LOGGER.error("Compress " + sb.toString() + " error");
            return false;
        }
        return true;
    }

    public static synchronized boolean compressFileZip(String aimFileName, String ... sourceDir) {
        if (StringUtils.hasNULLStr(sourceDir) || StringUtils.isNULLStr(aimFileName)) {
            LOGGER.info("path is null.");
            return false;
        }
        StringBuffer sb = new StringBuffer();
        for (String file : sourceDir) {
            sb.append(ComponentDefine.getMarks() + file + ComponentDefine.getMarks() + " ");
        }
        StringBuffer cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(" a -tzip").append(" ").append(ComponentDefine.getMarks()).append(aimFileName).append(ComponentDefine.getMarks()).append(" ").append(sb);
        if (!FileAssistant.executeCmd(cmd.toString(), true)) {
            LOGGER.error("Compress " + sb.toString() + " error");
            return false;
        }
        return true;
    }

    public static synchronized boolean compressTgzFile(String aimFileName, String ... sourceDir) {
        if (StringUtils.hasNULLStr(sourceDir) || StringUtils.isNULLStr(aimFileName)) {
            LOGGER.info("path is null.");
            return false;
        }
        String tempName = aimFileName.replace(".tgz", ".tar");
        StringBuffer sb = new StringBuffer();
        for (String file : sourceDir) {
            sb.append(ComponentDefine.getMarks() + file + ComponentDefine.getMarks() + " ");
        }
        StringBuffer cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(" a ").append(ComponentDefine.getMarks()).append(tempName).append(ComponentDefine.getMarks()).append(" ").append(sb.toString());
        if (!FileAssistant.executeCmd(cmd.toString(), true)) {
            LOGGER.error("Compress " + sb.toString() + " error");
            return false;
        }
        if (!FileAssistant.compressFile2AnyFileType(tempName, aimFileName)) {
            FileUtils.deleteFile((File)new File(tempName));
            return false;
        }
        FileUtils.deleteFile((File)new File(tempName));
        return true;
    }

    public static boolean compressFile2AnyFileType(String curFilePath, String targetPath) {
        StringBuffer cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(" a ").append(ComponentDefine.getMarks()).append(targetPath).append(ComponentDefine.getMarks()).append(" ").append(ComponentDefine.getMarks()).append(curFilePath).append(ComponentDefine.getMarks());
        if (!FileAssistant.executeCmd(cmd.toString(), true)) {
            LOGGER.error("Compress " + curFilePath + " error");
            return false;
        }
        return true;
    }

    public static synchronized void deCopmressZipUnLimited(String targetWithPath, String zipFilePath) {
        if (StringUtils.hasNULLStr(targetWithPath, zipFilePath)) {
            LOGGER.info("path is null.");
            return;
        }
        FileAssistant.deCopmressZip(targetWithPath, zipFilePath);
    }

    private static void deCopmressZip(String targetWithPath, String zipFilePath) {
        StringBuffer cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(" x ").append(ComponentDefine.getMarks()).append(zipFilePath).append(ComponentDefine.getMarks()).append(" -o").append(ComponentDefine.getMarks()).append(targetWithPath).append(ComponentDefine.getMarks()).append(" -y");
        if (!FileAssistant.executeCmd(cmd.toString(), true) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Decompress zip file " + zipFilePath + " with 7z error!");
        }
    }

    public static synchronized void deCopmressZipFile(String targetPath, String zipSourceFilePath, String ... targetFiles) {
        if (StringUtils.hasNULLStr(targetFiles) || StringUtils.hasNULLStr(targetPath, zipSourceFilePath)) {
            LOGGER.info("path is null.");
            return;
        }
        if (!FileUtils.fileSize2GInvalid((File)new File(zipSourceFilePath))) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the file size is over 2G. " + zipSourceFilePath);
            }
            return;
        }
        StringBuffer targetFileSb = new StringBuffer();
        for (String targetFile : targetFiles) {
            targetFileSb.append(targetFile);
            targetFileSb.append(" ");
        }
        String targets = targetFileSb.toString().trim();
        StringBuffer cmdSb = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(" x ").append(ComponentDefine.getMarks()).append(zipSourceFilePath).append(ComponentDefine.getMarks()).append(" -o").append(ComponentDefine.getMarks()).append(targetPath).append(ComponentDefine.getMarks()).append(ComponentDefine.getMarks()).append(targets).append(" -r -y");
        if (!FileAssistant.executeCmd(cmdSb.toString(), true) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Decompress " + targets + "from zip file " + zipSourceFilePath + " with 7z error !");
        }
    }

    public static synchronized int deCopmressZipFileWithPassword(String targetPath, String zipFilePath, String password, String ... targetFiles) {
        if (StringUtils.hasNULLStr(targetFiles) || StringUtils.hasNULLStr(targetPath, zipFilePath)) {
            LOGGER.info("path is null.");
            return 1;
        }
        if (!FileUtils.fileSize2GInvalid((File)new File(zipFilePath))) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the file size is over 2G. " + zipFilePath);
            }
            return 1;
        }
        StringBuffer targetFileSb = new StringBuffer();
        for (String targetFile : targetFiles) {
            targetFileSb.append(targetFile);
            targetFileSb.append(" ");
        }
        String targetFile = targetFileSb.toString().trim();
        StringBuffer cmdSb = FileAssistant.getCmdStringBuffer(targetPath, zipFilePath, targetFile);
        String result = FileAssistant.executeCmdWithPassword(cmdSb.toString(), password);
        if (-1 != result.indexOf("Wrong password")) {
            return -1;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Decompress " + targetFile + "from zip file " + zipFilePath + " with 7zresult: " + result);
        }
        if (-1 != result.toLowerCase(Locale.ENGLISH).indexOf("password")) {
            try {
                if (!FileAssistant.executeCmd(password, false) && LOGGER.isInfoEnabled()) {
                    LOGGER.info("Decompress " + targetFile + "from zip file " + zipFilePath + " with 7z error !");
                }
            }
            catch (Exception e) {
                LOGGER.error("executeCmd Password error!!!", e);
            }
        }
        return 1;
    }

    private static StringBuffer getCmdStringBuffer(String targetPath, String zipFilePath, String targetFile) {
        return new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(" x ").append(ComponentDefine.getMarks()).append(zipFilePath).append(ComponentDefine.getMarks()).append(" -o").append(ComponentDefine.getMarks()).append(targetPath).append(ComponentDefine.getMarks()).append(" ").append(targetFile).append(" -r -y");
    }

    public static synchronized void deCopmressTotalZipFile(String targetWithPath, String zipFilePath) {
        if (StringUtils.hasNULLStr(targetWithPath, zipFilePath)) {
            LOGGER.info("path is null.");
            return;
        }
        if (!FileUtils.fileSize2GInvalid((File)new File(zipFilePath))) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the file size is over 2G. " + zipFilePath);
            }
            return;
        }
        FileAssistant.deCopmressZip(targetWithPath, zipFilePath);
    }

    public static synchronized void batchDeCompressByFilter(String targetWithPath, String zipFilePath, String filterFlag) {
        FileAssistant.batchDeCompressByFilter(targetWithPath, zipFilePath, filterFlag, "e");
    }

    public static synchronized void batchDeCompressByFilter(String targetWithPath, String zipFilePath, String filterFlag, String mode) {
        if (StringUtils.hasNULLStr(targetWithPath, zipFilePath)) {
            LOGGER.info("path is null.");
            return;
        }
        StringBuffer cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(" ").append(mode).append(" ").append(ComponentDefine.getMarks()).append(zipFilePath).append(File.separator).append(filterFlag).append(ComponentDefine.getMarks()).append(" -o").append(ComponentDefine.getMarks()).append(targetWithPath).append(ComponentDefine.getMarks()).append(" -aou").append(" -y");
        if (!FileAssistant.executeCmd(cmd.toString(), true)) {
            LOGGER.error("Batch deCompress error!");
        }
    }

    public static synchronized boolean deCompressTgz(String targetPath, String gzFilePath) {
        if (StringUtils.hasNULLStr(targetPath, gzFilePath)) {
            LOGGER.info("path is null.");
            return false;
        }
        File gzFile = new File(gzFilePath);
        if (!FileUtils.fileSize2GInvalid((File)gzFile)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the file size is over 2G. " + gzFilePath);
            }
            return false;
        }
        String tarFileName = targetPath + File.separator + gzFile.getName().replace(".tgz", ".tar");
        if (!FileAssistant.deCopmressAllZipFile(targetPath, gzFilePath)) {
            LOGGER.info("deCopmress tgz file to tar file failed!");
            return false;
        }
        if (!FileAssistant.deCopmressAllZipFile(targetPath, tarFileName)) {
            LOGGER.info("deCopmress tar file failed!");
            return false;
        }
        File tarFile = new File(tarFileName);
        if (!tarFile.delete()) {
            LOGGER.error("Delete file " + tarFileName + " error!");
        }
        return true;
    }

    public static synchronized boolean deCopmressAllZipFile(String targetWithPath, String zipFilePath) {
        if (StringUtils.hasNULLStr(targetWithPath, zipFilePath)) {
            LOGGER.info("path is null.");
            return false;
        }
        if (!FileUtils.fileSize2GInvalid((File)FilePathUtils.checkFile((File)new File(zipFilePath)))) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the file size is over 2G. " + zipFilePath);
            }
            return false;
        }
        StringBuffer cmdBuffer = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(" x ").append(ComponentDefine.getMarks()).append(zipFilePath);
        cmdBuffer.append(ComponentDefine.getMarks()).append(" -o").append(ComponentDefine.getMarks()).append(targetWithPath).append(ComponentDefine.getMarks()).append(" -y");
        if (!FileAssistant.executeCmd(cmdBuffer.toString(), true)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Decompress zip file " + zipFilePath + " with 7z error!");
            }
            return false;
        }
        return true;
    }

    public static String executeCmdWithPassword(String cmd, String pwssword) {
        Process pro = null;
        try {
            LOGGER.info("Execute command ******");
            pro = OSCmdUtils.createCmdProcess(cmd);
        }
        catch (Exception e) {
            LOGGER.error("Execute command ****** error: ", e);
            return "";
        }
        return CommonMethod.executePassword(pro, pwssword);
    }

    public static boolean executeCmdInPath(String cmd) {
        Process pro = null;
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Execute command " + cmd);
            }
            pro = OSCmdUtils.createCmdProcess("cmd.exe /C " + cmd);
            String result = CommonMethod.getProcessResult(pro);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("executeCmd result:" + result);
            }
            return FileAssistant.isNotContainError(result);
        }
        catch (Exception e) {
            LOGGER.error("Execute " + cmd + " error: ", e);
            return false;
        }
    }

    public static boolean executeCmdInPathWithoutResult(String cmd) {
        cmd = "cmd.exe /C " + cmd;
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Execute command " + cmd);
            }
            OSCmdUtils.executeCmd(cmd);
        }
        catch (Exception e) {
            LOGGER.error("Execute " + cmd + " error: ", e);
            return false;
        }
        return true;
    }

    @Deprecated
    public static synchronized void deCompressTarGzFile(String targetPath, String tarGzFilePath) {
        if (StringUtils.hasNULLStr(targetPath, tarGzFilePath)) {
            LOGGER.info("path is null.");
            return;
        }
        if (!FileUtils.fileSize2GInvalid((File)new File(tarGzFilePath))) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the file size is over 2G. " + tarGzFilePath);
            }
            return;
        }
        String tarFileName = tarGzFilePath.split("\\.gz")[0];
        FileAssistant.deCopmressTotalZipFile(tarFileName, tarGzFilePath);
        FileAssistant.deCopmressTotalZipFile(targetPath, tarFileName);
        File tarFile = new File(tarFileName);
        if (!tarFile.delete()) {
            LOGGER.error("Delete file " + tarFileName + " error!");
        }
    }

    public static synchronized void deCompressTarGzFile2TargetDir(String targetPath, String tarGzFilePath) {
        if (StringUtils.hasNULLStr(targetPath, tarGzFilePath)) {
            LOGGER.info("path is null.");
            return;
        }
        if (!tarGzFilePath.endsWith(".tar.gz")) {
            LOGGER.error("the file extension does not matched tar.gz patten.");
            return;
        }
        if (!FileUtils.fileSize2GInvalid((File)new File(tarGzFilePath))) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the file size is over 2G. " + tarGzFilePath);
            }
            return;
        }
        String tarFileName = tarGzFilePath.split("\\.gz")[0];
        FileAssistant.deCopmressTotalZipFile(targetPath, tarGzFilePath);
        FileAssistant.deCopmressTotalZipFile(targetPath, tarFileName);
        File tarFile = new File(tarFileName);
        if (!tarFile.delete()) {
            LOGGER.error("Delete file " + tarFileName + " error!");
        }
    }

    public static synchronized void deCompressTarbz2File(String targetPath, String tarGzFilePath) {
        if (StringUtils.hasNULLStr(targetPath, tarGzFilePath)) {
            LOGGER.info("path is null.");
            return;
        }
        if (!FileUtils.fileSize2GInvalid((File)new File(tarGzFilePath))) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the file size is over 2G. " + tarGzFilePath);
            }
            return;
        }
        if (!tarGzFilePath.endsWith(".bz2")) {
            return;
        }
        String tarFileName = tarGzFilePath.split("\\.bz2")[0];
        File file = new File(tarFileName);
        String tarbz2FileName = file.getName();
        String[] tmp = tarbz2FileName.split("\\.tar");
        FileAssistant.deCopmressTotalZipFile(targetPath, tarGzFilePath);
        FileAssistant.deCopmressTotalZipFile(targetPath + File.separator + tmp[0], tarFileName);
        File tarFile = new File(tarFileName);
        if (!tarFile.delete()) {
            LOGGER.error("Delete file " + tarFileName + " error!");
        }
    }

    public static synchronized void deCompressTarbz2FileWithName(String targetPath, String tarGzFilePath) {
        if (StringUtils.hasNULLStr(targetPath, tarGzFilePath)) {
            LOGGER.info("path is null.");
            return;
        }
        if (!FileUtils.fileSize2GInvalid((File)new File(tarGzFilePath))) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the file size is over 2G. " + tarGzFilePath);
            }
            return;
        }
        String tarFileName = tarGzFilePath.split("\\.bz2")[0];
        FileAssistant.deCopmressTotalZipFile(targetPath, tarGzFilePath);
        FileAssistant.deCopmressTotalZipFile(targetPath, tarFileName);
        File tarFile = new File(tarFileName);
        if (!tarFile.delete()) {
            LOGGER.error("Delete file " + tarFileName + " error!");
        }
    }

    public static synchronized void deCompressTgzFile(String targetPath, String gzFilePath) {
        if (StringUtils.hasNULLStr(targetPath, gzFilePath)) {
            LOGGER.info("path is null.");
            return;
        }
        File gzFile = new File(gzFilePath);
        if (!FileUtils.fileSize2GInvalid((File)gzFile)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("the file size is over 2G. " + gzFilePath);
            }
            return;
        }
        String tarFileName = targetPath + File.separator + gzFile.getName().replace(".tgz", ".tar");
        FileAssistant.deCopmressTotalZipFile(targetPath, gzFilePath);
        FileAssistant.deCopmressTotalZipFile(targetPath, tarFileName);
        File tarFile = new File(tarFileName);
        if (!tarFile.delete()) {
            LOGGER.error("Delete file " + tarFileName + " error!");
        }
    }

    public static boolean delFile(String filePath) {
        if (StringUtils.hasNULLStr(filePath)) {
            LOGGER.info("path is null.");
            return false;
        }
        File sourceZipFile = new File(filePath);
        if (sourceZipFile.exists()) {
            return sourceZipFile.delete();
        }
        LOGGER.error("the filePath is not exist!:" + filePath);
        return true;
    }

    public static boolean delDirAndFile(String fileDir) {
        if (StringUtils.hasNULLStr(fileDir)) {
            LOGGER.info("path is null.");
            return false;
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("delete dir and file:" + fileDir);
        }
        File file2Del = new File(fileDir);
        FileAssistant.clearFileDir(file2Del);
        if (!file2Del.delete()) {
            FileAssistant.delDirWithOsCmd(FilePathUtils.getCanonicalPath((File)file2Del));
        }
        return true;
    }

    public static boolean delDirWithOsCmd(String dirPath) {
        String path = null;
        if (StringUtils.hasNULLStr(dirPath)) {
            LOGGER.info("Path is null.");
            return false;
        }
        try {
            path = new File(dirPath).getCanonicalPath();
            LOGGER.info("delete ok......");
        }
        catch (IOException e) {
            LOGGER.error("Get Canonical path error. ");
            return false;
        }
        String osName = System.getProperty("os.name");
        if (null == osName) {
            throw new RuntimeException("cannot get the System Property of [os.name].");
        }
        if (osName.contains("Windows")) {
            return FileAssistant.executeCmdInPath("rd " + ComponentDefine.getMarks() + path + ComponentDefine.getMarks() + " " + "/Q /S");
        }
        if (osName.contains("Linux")) {
            return FileAssistant.executeCmd("rm -rf " + dirPath, true);
        }
        return false;
    }

    public static void clearFileDir(File filetoDelete) {
        if (null == filetoDelete) {
            return;
        }
        if (!filetoDelete.isDirectory()) {
            return;
        }
        File tmpFile = new File(filetoDelete.toURI().getPath());
        File[] files = tmpFile.listFiles();
        boolean isDelectSuccess = false;
        if (null == files || files.length == 0) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                FileAssistant.clearFileDir(file);
            }
            try {
                isDelectSuccess = file.delete();
            }
            catch (SecurityException e) {
                LOGGER.error("Delete file exception", e);
            }
            if (isDelectSuccess) continue;
            LOGGER.error("Delete file " + file.getName() + " error");
        }
    }

    public static Collection<String> listAllFile(String parentPath, String ... fileSuffix) {
        ArrayList<String> result = new ArrayList<String>();
        File path = new File(parentPath);
        File[] subFiles = path.listFiles();
        if (null != subFiles) {
            for (File file : subFiles) {
                String fileName = file.getName();
                String filePath = FilePathUtils.getCanonicalPath((File)file);
                if (FileAssistant.isMathFileSuffix(fileName, fileSuffix)) {
                    result.add(filePath);
                    continue;
                }
                if (!file.isDirectory()) continue;
                result.addAll(FileAssistant.listAllFile(filePath, fileSuffix));
            }
        }
        return result;
    }

    private static boolean isMathFileSuffix(String fileName, String ... fileSuffixs) {
        for (String suffix : fileSuffixs) {
            if (null == suffix || !fileName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static Collection<String> listAllFileWithNameIndex(String parentPath, String nameIndex) {
        ArrayList<String> result = new ArrayList<String>();
        File path = new File(parentPath);
        File[] subFiles = path.listFiles();
        if (null != subFiles) {
            for (File file : subFiles) {
                String fileName = file.getName();
                String filePath = FilePathUtils.getCanonicalPath((File)file);
                if (file.isDirectory() || -1 == fileName.indexOf(nameIndex)) continue;
                result.add(filePath);
            }
        }
        return result;
    }

    public static void clearFileDir(File filetoDelete, String except) {
        if (null == filetoDelete) {
            return;
        }
        URI uri = filetoDelete.toURI();
        File tmpFile = null;
        try {
            tmpFile = new File(uri.toURL().getPath());
        }
        catch (MalformedURLException e1) {
            LOGGER.error("Create file error.", e1);
        }
        if (null == tmpFile) {
            return;
        }
        if (!tmpFile.isDirectory()) {
            return;
        }
        File[] files = tmpFile.listFiles();
        if (null == files) {
            return;
        }
        boolean isDeleteSuccss = false;
        for (File file : files) {
            if (file.isDirectory()) {
                FileAssistant.clearFileDir(file);
            }
            if (-1 != file.getName().indexOf(except)) continue;
            try {
                isDeleteSuccss = file.delete();
            }
            catch (SecurityException e) {
                LOGGER.error("Delete file exception", e);
            }
            if (isDeleteSuccss) continue;
            LOGGER.error("Delete file " + file.getName() + " error");
        }
    }

    public static void mergeFiles(String sourceFile, String resultFile) {
        if (StringUtils.hasNULLStr(sourceFile, resultFile)) {
            LOGGER.info("path is null.");
            return;
        }
        String osName = System.getProperty("os.name");
        if (null == osName) {
            throw new RuntimeException("cannot get the System Property of [os.name].");
        }
        StringBuffer cmdSb = new StringBuffer();
        if (osName.contains("Windows")) {
            cmdSb.append("type").append(" ").append(ComponentDefine.getMarks()).append(sourceFile).append(ComponentDefine.getMarks()).append(">>").append(ComponentDefine.getMarks()).append(resultFile).append(ComponentDefine.getMarks());
        } else if (osName.contains("Linux")) {
            cmdSb.append("cat").append(" ").append(ComponentDefine.getMarks()).append(sourceFile).append(ComponentDefine.getMarks()).append(">>").append(ComponentDefine.getMarks()).append(resultFile).append(ComponentDefine.getMarks());
        }
        if (!FileAssistant.executeCmdInPath(cmdSb.toString()) && LOGGER.isInfoEnabled()) {
            LOGGER.info("Merge file " + sourceFile + " to " + resultFile + " error!");
        }
    }

    public static synchronized void deCompressFiles(String rootPath, List<String> includePaths) {
        if (StringUtils.hasNULLStr(rootPath)) {
            LOGGER.info("path is null.");
            return;
        }
        File file = new File(rootPath);
        File[] childrens = file.listFiles();
        if (null != childrens) {
            for (File child : childrens) {
                File[] files;
                if (child.isFile() || !includePaths.contains(child.getName()) || (files = child.listFiles()) == null) continue;
                for (File item : files) {
                    if (!item.getName().endsWith(".tgz")) continue;
                    try {
                        FileAssistant.deCompressTgzFile(child.getCanonicalPath(), item.getCanonicalPath());
                    }
                    catch (IOException e) {
                        LOGGER.error("Can get file CanonicalPath." + e);
                    }
                    if (item.delete()) continue;
                    LOGGER.error("Can not delete file: " + item.getName());
                }
            }
        }
    }

    public static String get7zPath() {
        StringBuilder path = new StringBuilder().append(ApplicationContext.getInstance().getWorkPath()).append(File.separator).append("utils").append(File.separator).append("7z").append(File.separator);
        if (ApplicationContext.getInstance().isWindowsOS()) {
            return path.append("7za").toString();
        }
        path.append("linux").append(File.separator);
        String arch = System.getProperty("os.arch");
        LOGGER.info("system arch is {}", (Object)arch);
        if (org.apache.commons.lang3.StringUtils.containsAnyIgnoreCase((CharSequence)arch, (CharSequence[])new CharSequence[]{"x86", "amd64", "i386"})) {
            return path.append("7za").toString();
        }
        return path.append("7zzs_arm64").toString();
    }

    public static String get7zPathByInfoGrab() {
        StringBuffer buffer = new StringBuffer().append(ApplicationContext.getInstance().getWorkPath()).append(File.separator).append("utils").append(File.separator).append("7za");
        return buffer.toString();
    }

    public static synchronized void compressFile7zToSplitVolume(String size, String aimFileName, String ... sourceDir) {
        if (StringUtils.hasNULLStr(sourceDir)) {
            LOGGER.info("path is null.");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String file : sourceDir) {
            stringBuffer.append(ComponentDefine.getMarks() + file + ComponentDefine.getMarks() + " ");
        }
        StringBuffer cmdFor7z = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(" a -tzip").append(" ").append(ComponentDefine.getMarks()).append(aimFileName).append(ComponentDefine.getMarks()).append(" ").append(stringBuffer.toString()).append("-v").append(size);
        boolean reslut = FileAssistant.executeCmd(cmdFor7z.toString(), true);
        if (!reslut) {
            LOGGER.error("Compress " + stringBuffer.toString() + " error");
        } else {
            LOGGER.info("Compressed files has succeed!");
        }
    }

    public static synchronized void compressFile7zToSplitVolumeByPath(String path7z, String size, String aimFileName, String ... sourceDir) {
        if (StringUtils.hasNULLStr(sourceDir)) {
            LOGGER.info("path is null.");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (String file : sourceDir) {
            stringBuffer.append(ComponentDefine.getMarks() + file + ComponentDefine.getMarks() + " ");
        }
        StringBuffer cmdFor7z = new StringBuffer().append(ComponentDefine.getMarks()).append(path7z).append(ComponentDefine.getMarks()).append(" a -tzip").append(" ").append(ComponentDefine.getMarks()).append(aimFileName).append(ComponentDefine.getMarks()).append(" ").append(stringBuffer.toString()).append("-v").append(size);
        boolean reslut = FileAssistant.executeCmd(cmdFor7z.toString(), true);
        if (!reslut) {
            LOGGER.error("Compress " + stringBuffer.toString() + " error");
        } else {
            LOGGER.info("Compressed files has succeed!");
        }
    }

    public static File recursivelyGet1stTargetFile(File baseDir, String fileName) {
        try {
            if (null == baseDir || null == fileName || !baseDir.exists() || fileName.isEmpty()) {
                return null;
            }
            File destFile = null;
            File[] subDir = baseDir.listFiles();
            if (subDir == null) {
                return null;
            }
            for (File currntFile : subDir) {
                if (currntFile.isDirectory()) {
                    destFile = FileAssistant.recursivelyGet1stTargetFile(currntFile, fileName);
                    if (destFile == null) continue;
                    return destFile;
                }
                if (!currntFile.getName().toUpperCase(Locale.ENGLISH).contains(fileName.toUpperCase(Locale.ENGLISH))) continue;
                return currntFile;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String queryPackageFiles(String path) throws IOException {
        if (StringUtils.isNULLStr(path)) {
            LOGGER.info("path is null.");
            return "";
        }
        StringBuffer cmd = new StringBuffer().append(ComponentDefine.getMarks()).append(FileAssistant.get7zPath()).append(ComponentDefine.getMarks()).append(" l ").append(ComponentDefine.getMarks()).append(path).append(ComponentDefine.getMarks());
        return FileAssistant.executeCmdAndGetResult(cmd.toString(), true);
    }

    private static String executeCmdAndGetResult(String cmd, boolean log) throws IOException {
        if (log) {
            LOGGER.info("Execute command: {}", (Object)cmd);
        }
        Process pro = null;
        pro = ApplicationContext.getInstance().isWindowsOS() ? Runtime.getRuntime().exec(cmd) : Runtime.getRuntime().exec(new String[]{"sh", "-c", cmd});
        LOGGER.info("Execute command over");
        String processResult = CommonMethod.getProcessResult(pro);
        if (log) {
            LOGGER.info(processResult);
        }
        return processResult;
    }

    public static boolean executeCmd(String cmd, boolean log) {
        try {
            String result = FileAssistant.executeCmdAndGetResult(cmd, log);
            return FileAssistant.isNotContainError(result);
        }
        catch (IOException e) {
            LOGGER.error("Execute cmd io exception: ", e);
            return false;
        }
        catch (RuntimeException e) {
            LOGGER.error("Execute error: ", e);
            return false;
        }
    }

    private static boolean isNotContainError(String result) {
        return !result.toLowerCase(Locale.ENGLISH).contains("error");
    }

    public static boolean compress2TGZ(String targetDir, String fileName, String[] sources) {
        String tarFileName = targetDir + File.separator + fileName + ".tar";
        if (!FileAssistant.compress2Tar(tarFileName, sources)) {
            return false;
        }
        String gzFileName = tarFileName + ".gz";
        if (!FileAssistant.compress2Gz(gzFileName, tarFileName)) {
            return false;
        }
        FileUtils.deleteAllInFolder((String)targetDir, (File[])new File[]{new File(gzFileName)});
        return true;
    }

    public static boolean compress2Tar(String target, String ... sources) {
        String cmd = String.format(Locale.ENGLISH, CMD_TAR, FileAssistant.get7zPath(), target, String.join((CharSequence)"\" \"", sources));
        return FileAssistant.executeCmd(cmd, true);
    }

    public static boolean compress2Gz(String target, String source) {
        String cmd = String.format(Locale.ENGLISH, CMD_GZ, FileAssistant.get7zPath(), target, source);
        return FileAssistant.executeCmd(cmd, true);
    }
}

