/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.UnZipLimit;
import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZipAssistant {
    private static final Logger log = LoggerFactory.getLogger(GZipAssistant.class);
    private String zipfileName = null;

    public GZipAssistant(String zipfileName) {
        this.zipfileName = zipfileName;
    }

    private synchronized ArchiveInputStream getInputStream() {
        FileInputStream fis = null;
        ArchiveInputStream in = null;
        try {
            fis = new FileInputStream(this.zipfileName);
            GZIPInputStream is = new GZIPInputStream(new BufferedInputStream(fis));
            in = new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)is);
        }
        catch (FileNotFoundException e) {
            log.error("[FileNotFoundException] The tgz file is not found.");
        }
        catch (IOException e) {
            log.error("[IOException] The tgz file operate error.");
        }
        catch (ArchiveException e) {
            log.error("[ArchiveException]The tgz file operate error.");
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String searchFile(List<String> fileList) {
        String fileName = null;
        TarArchiveEntry entry = null;
        ArchiveInputStream in = this.getInputStream();
        if (in == null) {
            log.error("the tgz file is error");
            return null;
        }
        try {
            entry = (TarArchiveEntry)in.getNextEntry();
            String name = "";
            while (entry != null) {
                name = entry.getName();
                if (fileList.contains(name)) {
                    fileName = name;
                    break;
                }
                entry = (TarArchiveEntry)in.getNextEntry();
            }
        }
        catch (IOException e) {
            log.error("search file failed exception!", e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                log.error("close file failed exception!", e);
            }
        }
        return fileName;
    }

    public synchronized BufferedReader getFileBuffer(String fileName) {
        FileInputStream fis = null;
        ArchiveInputStream in = null;
        BufferedReader result = null;
        try {
            fis = new FileInputStream(this.zipfileName);
            GZIPInputStream is = new GZIPInputStream(new BufferedInputStream(fis));
            in = new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)is);
            InputStreamReader isr = new InputStreamReader((InputStream)in, "UTF-8");
            result = new BufferedReader(isr);
            TarArchiveEntry entry = (TarArchiveEntry)in.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (log.isInfoEnabled()) {
                    log.info("The entryfile name:{}", (Object)StringUtils.getCleanMessage((String)name));
                }
                if (name.equals(fileName)) {
                    return result;
                }
                entry = (TarArchiveEntry)in.getNextEntry();
            }
        }
        catch (FileNotFoundException e) {
            log.error("File {} not found exception! ", (Object)new File(this.zipfileName).getName());
        }
        catch (IOException e) {
            log.error("Read file occured IO exception! ", e);
        }
        catch (ArchiveException e) {
            log.error("Read file occured exception! ", e);
        }
        log.error("The file {} doesn't exist!", (Object)fileName);
        return null;
    }

    public synchronized Map<String, BufferedReader> getFileBufferMap(List<String> fileNameList) {
        FileInputStream fis = null;
        ArchiveInputStream in = null;
        BufferedReader result = null;
        HashMap<String, BufferedReader> resMap = new HashMap<String, BufferedReader>();
        try {
            fis = new FileInputStream(this.zipfileName);
            GZIPInputStream is = new GZIPInputStream(new BufferedInputStream(fis));
            in = new ArchiveStreamFactory().createArchiveInputStream("tar", (InputStream)is);
            InputStreamReader isr = new InputStreamReader((InputStream)in, "UTF-8");
            result = new BufferedReader(isr);
            TarArchiveEntry entry = (TarArchiveEntry)in.getNextEntry();
            while (entry != null) {
                String name = entry.getName();
                if (name.indexOf("/") != -1) {
                    name = name.substring(name.lastIndexOf("/") + 1);
                }
                if (fileNameList.contains(name)) {
                    resMap.put(name, result);
                    return resMap;
                }
                entry = (TarArchiveEntry)in.getNextEntry();
            }
        }
        catch (FileNotFoundException e) {
            log.error("File {} not found exception! ", (Object)new File(this.zipfileName).getName());
        }
        catch (ArchiveException e) {
            log.error("ArchiveException: ", e);
        }
        catch (IOException e) {
            log.error("Read file occured IO exception! ", e);
        }
        log.error("Doesn't exist the file in the tgz file.");
        return null;
    }

    /*
     * Exception decompiling
     */
    public synchronized List<String> getFileListByRe(String reStr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized String getFileNameFromMap(Map<String, BufferedReader> fileMap) {
        for (String fileName : fileMap.keySet()) {
            if (fileName == null) continue;
            return fileName;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public boolean extractFile(String extraceFileName, String destDir) throws IOException, ArchiveException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean bufferedOutWrite(BufferedInputStream bufferedInputStream, File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(FilePathUtils.checkFile((File)file)));
        try {
            int b;
            UnZipLimit unZipLimit = new UnZipLimit();
            while ((b = bufferedInputStream.read()) != -1) {
                unZipLimit.increaseFileSize((long)b);
                ZipUtils.checkUnzipRules((UnZipLimit)unZipLimit, (String)file.getCanonicalPath());
                bufferedOutputStream.write(b);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            StreamUtils.closeStream(bufferedOutputStream, null);
        }
    }

    private void initTempBuilder(String[] names, StringBuilder tempBuilder) {
        for (int i = 0; i < names.length - 1; ++i) {
            String str = names[i];
            tempBuilder.append(File.separator);
            tempBuilder.append(str);
        }
    }

    public static void closeBufferedReader(BufferedReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                log.error("closed inputStream occured exception! ", e);
            }
        }
    }

    private void mkFolders(String fileName) {
        File file = new File(fileName);
        boolean isSucc = false;
        if (!file.exists()) {
            isSucc = file.mkdirs();
        }
        if (!isSucc) {
            return;
        }
    }

    private File mkFile(String fileName) {
        File file = new File(fileName);
        boolean isSucc = false;
        try {
            isSucc = file.createNewFile();
        }
        catch (IOException e) {
            log.error("create new file occured exception! ", e);
        }
        if (isSucc) {
            return file;
        }
        return null;
    }
}

