/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.common.resourcemanager.CustomResourceManager;
import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.thread.ThreadPoolManager;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.obase.utils.PingUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.text.TextComponentsConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetUtil {
    private static final Logger log = LoggerFactory.getLogger(NetUtil.class);
    public static final int CONN_SOCKECT = 0;
    public static final int CONN_SSL_SOCKECT = 1;
    public static final String MASK_A = "255.0.0.0";
    public static final String MASK_B = "255.255.0.0";
    public static final String MASK_C = "255.255.255.0";
    public static final String CONST_IP = "IP";
    public static final String CONST_MASK = "MASK";
    public static final Map<String, String> LOCALIPMAP = new HashMap<String, String>();
    public static final String LOOPBACK_ADDRESS = "127.0.0.1";
    private static Map<String, String> ipSubMaskMap = new HashMap<String, String>();

    private NetUtil() {
    }

    private static String getLoopbackAddress() {
        return ResourceUtil.getString("LOOPBACK.ipV6.DEFAULT.ADDRESS");
    }

    public static void checkIPV4(String ip) {
        try {
            InetAddress val = InetAddress.getByName(ip);
            if (null == val) {
                return;
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("wrong IP scope:" + ip, e);
        }
    }

    public static long ipv4Str2Long(String ip) {
        NetUtil.checkIPV4(ip);
        String[] str = ip.split("\\.");
        long ipValue = 0L;
        for (int i = str.length - 1; i >= 0; --i) {
            int tmp = Integer.valueOf(str[i]);
            long longNumber = 0L;
            longNumber = (longNumber | (long)tmp) << 8 * (str.length - i - 1);
            ipValue |= longNumber;
        }
        return ipValue;
    }

    public static boolean isSubnetMaskV4(String mask) {
        int ipVal;
        if (mask == null) {
            throw new NullPointerException();
        }
        if (mask.indexOf(" ") > -1 || mask.indexOf("..") > -1) {
            return false;
        }
        try {
            ipVal = NetUtil.ipv4Str2Int(mask);
        }
        catch (Exception e) {
            log.error("", e);
            return false;
        }
        return Integer.bitCount(ipVal) + Integer.numberOfTrailingZeros(ipVal) >= 32;
    }

    public static boolean isSameSubnet(String subnetIP, String maskStr, String testIP) {
        int testIPValue;
        if (subnetIP == null || maskStr == null) {
            throw new NullPointerException();
        }
        if (null == testIP) {
            return false;
        }
        try {
            NetUtil.checkIPV4(subnetIP);
            NetUtil.checkIPV4(testIP);
        }
        catch (RuntimeException e) {
            return false;
        }
        NetUtil.checkIPV4(maskStr);
        if (!NetUtil.isSubnetMaskV4(maskStr)) {
            throw new IllegalArgumentException(maskStr + " is not a subnet mask");
        }
        int subnetIPValue = NetUtil.ipv4Str2Int(subnetIP);
        int maskValue = NetUtil.ipv4Str2Int(maskStr);
        return (maskValue & subnetIPValue) == (maskValue & (testIPValue = NetUtil.ipv4Str2Int(testIP)));
    }

    public static int ipv4Str2Int(String ip) {
        NetUtil.checkIPV4(ip);
        String[] str = ip.split("\\.");
        int ipVal = 0;
        for (int i = 0; i < 4; ++i) {
            int tmp = Integer.valueOf(str[i]);
            ipVal |= tmp;
            if (i == 3) continue;
            ipVal <<= 8;
        }
        return ipVal;
    }

    public static BigInteger ipv6Str2Int(String ip) {
        try {
            InetAddress addr = InetAddress.getByName(ip);
            BigInteger bi = new BigInteger(addr.getAddress());
            return bi;
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static NetworkInterface[] availableInterface() {
        Enumeration<NetworkInterface> networkInterfaces = null;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            log.warn("get local info error.", e);
            return new NetworkInterface[0];
        }
        ArrayList<NetworkInterface> netWorkInterfaces = new ArrayList<NetworkInterface>();
        if (null == networkInterfaces) {
            log.warn("networkInterfaces is null");
            throw new NullPointerException("networkInterfaces is null");
        }
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInfterface = networkInterfaces.nextElement();
            boolean available = false;
            Enumeration<InetAddress> iNetAddr = networkInfterface.getInetAddresses();
            while (iNetAddr.hasMoreElements()) {
                InetAddress element = iNetAddr.nextElement();
                if (element.isLoopbackAddress()) continue;
                available = true;
                break;
            }
            if (!available) continue;
            netWorkInterfaces.add(networkInfterface);
        }
        return netWorkInterfaces.toArray(new NetworkInterface[netWorkInterfaces.size()]);
    }

    public static String getLocalIP(String ip, int port) {
        boolean bool;
        List<String> ips = NetUtil.queryAllLocalIP();
        String localIp = LOCALIPMAP.get(ip = NetUtil.isCommandIPV6Addr(ip) ? NetUtil.getNormalIPV6Addr(ip) : ip);
        if (null != localIp && (bool = ips.contains(localIp))) {
            return localIp;
        }
        return NetUtil.queryLocalIP(ip, port);
    }

    private static List<String> queryAllLocalIP() {
        NetworkInterface[] networkInterfaces;
        ArrayList<String> ips = new ArrayList<String>();
        for (NetworkInterface networkInterface : networkInterfaces = NetUtil.availableInterface()) {
            Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                ips.add(address.getHostAddress());
            }
        }
        return ips;
    }

    /*
     * Exception decompiling
     */
    private static String getLocakIPv4Address(String ip, int port) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static String getLocalIPv6Address(String ip, int port) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void closeSocket(Socket sock) {
        try {
            if (null != sock) {
                sock.close();
            }
        }
        catch (Exception eee) {
            log.error("Close stream error.", eee);
        }
    }

    public static synchronized String queryLocalIP(final String ip, final int port) {
        Callable<String> task = new Callable<String>(){

            @Override
            public String call() {
                if (NetUtil.isValidIPV4(ip)) {
                    return NetUtil.getLocakIPv4Address(ip, port);
                }
                if (NetUtil.isValidIPV6(ip)) {
                    return NetUtil.getLocalIPv6Address(ip, port);
                }
                return null;
            }
        };
        Future futuer = ThreadPoolManager.getInstance().submit((Callable)task);
        String localIp = LOOPBACK_ADDRESS;
        localIp = NetUtil.handleLocalIp(ip, localIp);
        try {
            String tmp = (String)futuer.get(10L, TimeUnit.SECONDS);
            if (null != tmp && !"".equalsIgnoreCase(tmp) && !"0.0.0.0".equals(tmp)) {
                LOCALIPMAP.put(ip, tmp);
                localIp = tmp;
            }
        }
        catch (InterruptedException e1) {
            log.warn("Getting local ip by socket error.");
        }
        catch (ExecutionException e1) {
            log.warn("Getting local ip by socket error.");
        }
        catch (TimeoutException e1) {
            log.warn("Getting local ip by socket error.");
        }
        catch (Exception e2) {
            log.warn("Getting local ip by socket error.");
        }
        return localIp;
    }

    private static String handleLocalIp(String ip, String localIp) {
        try {
            List<String> ips = NetUtil.queryAllLocalIP();
            Collections.sort(ips);
            if (log.isInfoEnabled()) {
                log.info("local ips:" + ips);
            }
            String tmpIp = ip;
            if (NetUtil.isValidIPV4(ip)) {
                localIp = NetUtil.handleLocalIpv4(ips, tmpIp);
            } else if (NetUtil.isValidIPV6(ip)) {
                localIp = NetUtil.handleLocalIpv6(ips, tmpIp);
            }
        }
        catch (Exception e) {
            log.error("Get local IPAddress error", e);
        }
        return localIp;
    }

    private static String handleLocalIpv6(List<String> ips, String tmpIp) {
        int ind;
        String loopBackV6Default;
        String localIp = loopBackV6Default = NetUtil.getLoopbackAddress();
        block0: while (localIp.equals(loopBackV6Default) && null != tmpIp && -1 != (ind = tmpIp.lastIndexOf(58))) {
            tmpIp = tmpIp.substring(0, ind);
            for (String string : ips) {
                if (!string.contains(tmpIp)) continue;
                localIp = string;
                continue block0;
            }
        }
        if (loopBackV6Default.equals(localIp) && !ips.isEmpty()) {
            localIp = NetUtil.getIPv6Address(ips);
        }
        return localIp;
    }

    private static String handleLocalIpv4(List<String> ips, String tmpIp) {
        int ind;
        String localIp = LOOPBACK_ADDRESS;
        block0: while (null != tmpIp && -1 != (ind = tmpIp.lastIndexOf(46))) {
            tmpIp = tmpIp.substring(0, ind);
            for (String string : ips) {
                if (!string.contains(tmpIp)) continue;
                localIp = string;
                continue block0;
            }
        }
        if (LOOPBACK_ADDRESS.equals(localIp) && !ips.isEmpty()) {
            localIp = NetUtil.getIPv4Address(ips);
        }
        return localIp;
    }

    private static String getIPv4Address(List<String> ips) {
        for (String ip : ips) {
            if (!NetUtil.isValidIPV4(ip)) continue;
            return ip;
        }
        return LOOPBACK_ADDRESS;
    }

    private static String getIPv6Address(List<String> ips) {
        for (String ip : ips) {
            if (!NetUtil.isValidIPV6(ip)) continue;
            return ip;
        }
        return NetUtil.getLoopbackAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getFreeLocalPort() {
        SecureRandom random = new SecureRandom();
        while (true) {
            int testPort = random.nextInt(5000);
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket(testPort);
                int n = testPort;
                return n;
            }
            catch (IOException e) {
                log.error("Local port is in use:" + testPort);
                continue;
            }
            finally {
                try {
                    if (null == serverSocket) continue;
                    serverSocket.close();
                }
                catch (IOException e) {
                    log.error("Close socket error.");
                }
                continue;
            }
            break;
        }
    }

    public static boolean isValidSubNetMask(String ipAddress, String subNetMask) {
        int tmp1 = ~NetUtil.ipv4Str2Int(subNetMask);
        int tmp2 = tmp1 & NetUtil.ipv4Str2Int(ipAddress);
        if (0 == tmp2) {
            return false;
        }
        int tmp3 = tmp1 ^ tmp2;
        return 0 != tmp3;
    }

    public static boolean isValidIP(String ip) {
        return NetUtil.isValidIPV4(ip) || NetUtil.isValidIPV6(ip);
    }

    public static boolean isValidIPV4(String ip) {
        try {
            boolean part4;
            NetUtil.checkIpFormat(ip);
            String[] str = ip.split("\\.");
            int ipField1 = Integer.parseInt(str[0]);
            int ipField2 = Integer.parseInt(str[1]);
            int ipField3 = Integer.parseInt(str[2]);
            int ipField4 = Integer.parseInt(str[3]);
            boolean part1 = 1 <= ipField1 && 223 >= ipField1 && 127 != ipField1;
            boolean part2 = 0 <= ipField2 && 255 >= ipField2;
            boolean part3 = 0 <= ipField3 && 255 >= ipField3;
            boolean bl = part4 = 0 <= ipField4 && 255 >= ipField4;
            if (part1 && part2 && part3 && part4) {
                NetUtil.checkIPV4(ip);
                return true;
            }
        }
        catch (RuntimeException t) {
            return false;
        }
        catch (Exception t1) {
            return false;
        }
        return false;
    }

    private static void checkIpFormat(String ip) {
        Pattern pattern = Pattern.compile("\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}");
        Matcher mat = pattern.matcher(ip);
        if (!mat.matches()) {
            throw new IllegalArgumentException("wrong IP format: " + ip);
        }
    }

    public static void initLocalIPSubMaskMap() {
        ipSubMaskMap.clear();
        String osSystem = System.getProperty("os.name");
        if (null == osSystem) {
            throw new EncapsulatedRuntimeException("cannot get the System Property of [os.name].");
        }
        if (osSystem.indexOf("Windows") >= 0) {
            NetUtil.initIPSubMaskMapForWindows();
        } else if (osSystem.indexOf("Linux") >= 0) {
            NetUtil.initIPSubMaskMapForLinux();
        } else if (osSystem.indexOf("SunOS") >= 0) {
            NetUtil.initIPSubMaskMapForSolaris();
        }
        log.info(ipSubMaskMap.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initIPSubMaskMapForWindows() {
        Process process = null;
        try {
            process = OSCmdUtils.createCmdProcess("ipconfig");
        }
        catch (IOException e) {
            log.error("initIPSubMaskMapForWindows error", e);
        }
        if (null == process) {
            return;
        }
        InputStream in = process.getInputStream();
        InputStreamReader inReader = new InputStreamReader(in, Charset.defaultCharset());
        LineNumberReader lineReader = new LineNumberReader(inReader);
        try {
            ArrayList<String> vec = new ArrayList<String>();
            NetUtil.readProcessInfo(lineReader, vec);
            String ip = null;
            String mask = null;
            int index = 0;
            while (index + 1 < vec.size()) {
                ip = (String)vec.get(index);
                mask = (String)vec.get(index + 1);
                if (NetUtil.isSubnetMaskV4(mask)) {
                    ipSubMaskMap.put(ip, mask);
                    index += 2;
                    continue;
                }
                ++index;
            }
        }
        catch (IOException e) {
            log.error("initIPSubMaskMapForWindows error", e);
        }
        finally {
            StreamUtils.closeResource(null, lineReader);
            StreamUtils.closeResource(null, inReader);
            StreamUtils.closeStream(null, in);
            NetUtil.destroyPro(process);
        }
    }

    private static void readProcessInfo(LineNumberReader lineReader, List<String> vec) throws IOException {
        String line;
        while (null != (line = lineReader.readLine())) {
            if (0 >= line.trim().length()) continue;
            try {
                String[] result = line.split(":");
                if (1 >= result.length || 0 == result[1].trim().length() || !result[1].trim().matches("([0-9]*).([0-9]*).([0-9]*).([0-9]*)")) continue;
                vec.add(result[1].trim());
            }
            catch (Exception t) {
                log.error("Read process output error.", t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initIPSubMaskMapForLinux() {
        Process process = null;
        try {
            process = OSCmdUtils.createCmdProcess("ifconfig | grep \"inet addr\"");
        }
        catch (IOException e) {
            log.error("initIPSubMaskMapForLinux error", e);
        }
        if (null == process) {
            return;
        }
        InputStream in = process.getInputStream();
        InputStreamReader inReader = new InputStreamReader(in, Charset.defaultCharset());
        LineNumberReader lineReader = new LineNumberReader(inReader);
        try {
            NetUtil.parseCmdOutput(lineReader);
        }
        catch (IOException e) {
            log.error("initIPSubMaskMapForLinux error", e);
        }
        finally {
            StreamUtils.closeResource(null, lineReader);
            StreamUtils.closeResource(null, inReader);
            StreamUtils.closeStream(null, in);
            NetUtil.destroyPro(process);
        }
    }

    private static void parseCmdOutput(LineNumberReader lineReader) throws IOException {
        String line = null;
        while (null != (line = lineReader.readLine())) {
            String[] result;
            if (0 >= line.trim().length() || 1 >= (result = line.split(" ")).length) continue;
            String ip = null;
            String mask = null;
            for (String str : result) {
                String[] tmp = str.split(":");
                if (str.contains("inet addr")) {
                    ip = tmp[1];
                    continue;
                }
                if (!str.contains("mask")) continue;
                mask = tmp[1];
            }
            if (null == ip || null == mask) continue;
            ipSubMaskMap.put(ip, mask);
        }
    }

    private static void initIPSubMaskMapForSolaris() {
        List<String> retRes = NetUtil.executeNativeNetCmd("ifconfig -a");
        for (String newLine : retRes) {
            if (!newLine.toLowerCase(ResourceManager.getLocale()).contains("inet")) continue;
            try {
                String[] result = newLine.split("( )+");
                if (4 >= result.length) continue;
                String ip = result[1].trim();
                String mask = result[3].trim();
                if (!mask.matches("([0-9]{1,3}).([0-9]{1,3}).([0-9]{1,3}).([0-9]{1,3})")) {
                    mask = NetUtil.parseHexMaskToOctMask(mask);
                }
                ipSubMaskMap.put(ip, mask);
            }
            catch (RuntimeException t) {
            }
            catch (Exception t1) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> executeNativeNetCmd(String cmd) {
        ArrayList<String> result = new ArrayList<String>();
        Process process = null;
        LineNumberReader lineReader = null;
        try {
            process = OSCmdUtils.createCmdProcess(cmd);
            lineReader = new LineNumberReader(new InputStreamReader(process.getInputStream(), Charset.defaultCharset()));
            String line = null;
            while (null != (line = lineReader.readLine())) {
                if (0 >= line.trim().length()) continue;
                result.add(line.trim());
            }
        }
        catch (Exception t) {
            try {
                log.error("Execute native command error", t);
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, lineReader);
                NetUtil.destroyPro(process);
                throw throwable;
            }
            StreamUtils.closeResource(null, lineReader);
            NetUtil.destroyPro(process);
        }
        StreamUtils.closeResource(null, lineReader);
        NetUtil.destroyPro(process);
        return result;
    }

    private static String parseHexMaskToOctMask(String mask) {
        if (mask.length() != 8) {
            return null;
        }
        String str1 = mask.substring(0, 2);
        String str2 = mask.substring(2, 4);
        String str3 = mask.substring(4, 6);
        String str4 = mask.substring(6, 8);
        String strMask = Integer.parseInt(str1, 16) + "." + Integer.parseInt(str2, 16) + "." + Integer.parseInt(str3, 16) + "." + Integer.parseInt(str4, 16);
        if (!strMask.matches("([0-9]{1,3}).([0-9]{1,3}).([0-9]{1,3}).([0-9]{1,3})")) {
            return null;
        }
        return strMask;
    }

    public static String getSubNetMaskByIP(String ipAddr) {
        return ipSubMaskMap.get(ipAddr);
    }

    public static int getLocalPort() {
        int port = 0;
        Set<Integer> ports = NetUtil.readPortCfgFile();
        for (Integer tmp : ports) {
            try {
                port = NetUtil.getValidPort(tmp);
            }
            catch (Exception t) {
                port = 0;
            }
            if (0 == port) continue;
            break;
        }
        if (0 == port) {
            try {
                port = NetUtil.getValidPort(0);
            }
            catch (Exception e) {
                log.error("can not find available free port" + e);
            }
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getValidPort(int portParam) {
        int port = 0;
        ServerSocket socket = null;
        try {
            socket = new ServerSocket(portParam);
            port = socket.getLocalPort();
        }
        catch (Exception e) {
            log.error("", e);
        }
        finally {
            if (null != socket) {
                try {
                    socket.close();
                }
                catch (IOException e) {
                    log.error("", e);
                }
            }
        }
        return port;
    }

    private static Set<Integer> readPortCfgFile() {
        String[] tmpStr;
        HashSet<Integer> ports = new HashSet<Integer>();
        String portRangeStr = CustomResourceManager.getInstance().getString("custom.portrange");
        for (String str : tmpStr = portRangeStr.split(";")) {
            if (str.matches("([0-9]+-[0-9]+)")) {
                Set<Integer> resultInt = NetUtil.parsePortCfg(str);
                ports.addAll(resultInt);
                continue;
            }
            NetUtil.parsePortCfg(str, ports);
        }
        return ports;
    }

    private static Set<Integer> parsePortCfg(String strPorts) {
        String[] arr = strPorts.split("-");
        int startValue = -1;
        int endValue = -1;
        startValue = StringUtils.str2Int(arr[0]);
        endValue = StringUtils.str2Int(arr[1]);
        HashSet<Integer> pPorts = new HashSet<Integer>();
        pPorts.add(startValue);
        pPorts.add(endValue);
        while (++startValue != endValue) {
            pPorts.add(startValue);
        }
        return pPorts;
    }

    private static void parsePortCfg(String strPorts, Set<Integer> portList) {
        String[] strArray;
        for (String strArr : strArray = strPorts.split(",")) {
            Integer tmp = Integer.valueOf(strArr);
            if (null == tmp || 0 == tmp) continue;
            portList.add(tmp);
        }
    }

    public static boolean isValidIPV6(String ipv6) {
        if (null == ipv6) {
            return false;
        }
        Pattern pattern = Pattern.compile(TextComponentsConstants.getIPV6AddressRegrex());
        Matcher mat = pattern.matcher(ipv6);
        if (mat.matches()) {
            try {
                Inet6Address address = (Inet6Address)InetAddress.getByName(ipv6);
                if (null != address) {
                    return !address.isMulticastAddress() && !address.isLoopbackAddress() && !address.isAnyLocalAddress();
                }
                return false;
            }
            catch (UnknownHostException e) {
                return false;
            }
            catch (Exception e1) {
                String ipTmp = "";
                try {
                    InetAddress ipv6address = InetAddress.getByName(ipv6);
                    ipTmp = ipv6address.getHostAddress();
                }
                catch (UnknownHostException e) {
                    return false;
                }
                return NetUtil.isValidIPV4(ipv6) ? false : NetUtil.isValidIPV4(ipTmp);
            }
        }
        return false;
    }

    public static boolean isCommandIPV6Addr(String ip) {
        return ip.contains(":") && ip.contains("[") && !ip.contains("https://");
    }

    public static String getIPV6AddrForCmd(String ipv6Addr) {
        return "[" + ipv6Addr + "]";
    }

    public static String getNormalIPV6Addr(String ipv6Addr) {
        return ipv6Addr.replace("[", "").replace("]", "");
    }

    public static boolean isCommonAddress(String ip) {
        try {
            InetAddress address = InetAddress.getByName(ip);
            if (null != address) {
                boolean flag = !address.isMulticastAddress() && !address.isLoopbackAddress();
                return flag;
            }
            return false;
        }
        catch (RuntimeException runException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static Socket connect(String ip, int port, int connType, Proxy proxy) throws IOException {
        Socket socket = null;
        if (connType == 1) {
            SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            socket = factory.createSocket();
        } else if (connType == 0) {
            socket = proxy == null ? new Socket() : new Socket(proxy);
        } else {
            throw new IllegalArgumentException();
        }
        InetSocketAddress address = new InetSocketAddress(ip, port);
        socket.connect(address);
        socket.setReuseAddress(true);
        return socket;
    }

    public static boolean isIPv6Prefix(String prefix) {
        if (null == prefix) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher mat = pattern.matcher(prefix);
        return mat.matches() && !"".equals(prefix) && !prefix.startsWith("0") && Integer.parseInt(prefix) <= 128;
    }

    public static boolean isPortCannotReach(String host, int port) {
        return NetUtil.isPortCannotReach(host, port, 5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortCannotReach(String host, int port, int timeout) {
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(host, port), timeout);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            log.error("host not available: {} {} ", (Object)host, (Object)port);
            boolean bl = true;
            return bl;
        }
        finally {
            NetUtil.closeCocket(host, port, socket);
        }
    }

    public static boolean isPortCanReach(String host, int port, int timeout) {
        return !NetUtil.isPortCannotReach(host, port, timeout);
    }

    private static void closeCocket(String host, int port, Socket socket) {
        try {
            socket.close();
        }
        catch (IOException e) {
            log.warn("close socket error:" + host + " " + port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isHostConnectable(String host, int port, int checkTime) {
        Socket socket = new Socket();
        boolean result = false;
        try {
            socket.connect(new InetSocketAddress(host, port), checkTime);
            result = true;
        }
        catch (IOException e) {
            if (PingUtils.pingHost(host, " -n ", String.valueOf(1))) {
                boolean bl = true;
                return bl;
            }
            log.error("host not avalable:{} {}", com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)host), com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)String.valueOf(port)), e);
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            if (PingUtils.pingHost(host, " -n ", String.valueOf(1))) {
                boolean bl = true;
                return bl;
            }
            log.error("host not avalable:", e);
            boolean bl = result;
            return bl;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException e) {
                log.error("Close socket error..");
            }
        }
        return result;
    }

    public static boolean isHostConnectable(String host, int port) {
        return NetUtil.isHostConnectable(host, port, 4);
    }

    public static boolean isHostCanConnect(String host, int port, int seconds) {
        return NetUtil.isHostConnectable(host, port, seconds * 1000);
    }

    public static void destroyPro(Process process) {
        try {
            if (null != process) {
                process.destroy();
            }
        }
        catch (Exception t) {
            log.error("", t);
        }
    }
}

