/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.obase.utils.OSCmdUtils;
import com.huawei.ism.tool.obase.utils.StreamGobbler;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PingUtils {
    private static final Logger log = LoggerFactory.getLogger(PingUtils.class);

    private PingUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static String executeCmd(String cmd) {
        StreamGobbler errorGobbler = null;
        StreamGobbler outputGobbler = null;
        Process proc = null;
        try {
            proc = OSCmdUtils.createCmdProcess(cmd);
            InputStream ins = proc.getInputStream();
            InputStream err = proc.getErrorStream();
            outputGobbler = new StreamGobbler(ins);
            errorGobbler = new StreamGobbler(err);
            errorGobbler.start();
            outputGobbler.start();
            int ret = proc.waitFor();
            log.info("return info: {}", (Object)ret);
            errorGobbler.join();
            outputGobbler.join();
        }
        catch (IOException | InterruptedException e) {
            log.error("Execute cmd error.", e);
            NetUtil.destroyPro(proc);
        }
        catch (Exception e1) {
            log.error("Execute cmd error.", e1);
            {
                catch (Throwable throwable) {
                    NetUtil.destroyPro(proc);
                    throw throwable;
                }
            }
            NetUtil.destroyPro(proc);
        }
        NetUtil.destroyPro(proc);
        if (outputGobbler == null) {
            return "";
        }
        return outputGobbler.result.toString();
    }

    public static boolean pingHost(String host, String ... params) {
        String ret = "";
        if (ApplicationContext.getInstance().isWindowsOS()) {
            StringBuilder cmd = new StringBuilder("ping ").append(host);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    cmd.append(params[i]);
                }
            }
            ret = PingUtils.executeCmd(cmd.toString());
        } else {
            ret = PingUtils.executeCmd(PingUtils.getPingCmd(host) + host + " -c 4");
        }
        boolean result = PingUtils.checkLink(ret, host);
        if (!result) {
            log.error("Result of ping {} : {}", (Object)com.huawei.ism.tool.base.utils.StringUtils.getCleanMessage((String)host), (Object)ret);
        }
        return result;
    }

    public static boolean fastPingHost(String ip) {
        String cmd = "ping " + ip;
        String trimString = ip + " -c 4";
        cmd = ApplicationContext.getInstance().isWindowsOS() ? cmd + " -n 1 -w 2000" : PingUtils.getPingCmd(ip) + trimString;
        String ret = PingUtils.executeCmd(cmd);
        log.error("Result of ping {} : {}", (Object)ip, (Object)ret);
        return PingUtils.checkLink(ret, ip);
    }

    public static boolean pingHostOnePacket(String ip) {
        String cmd = "ping " + ip;
        String trimString = ip + " -c 4";
        cmd = ApplicationContext.getInstance().isWindowsOS() ? cmd + " -n 1" : PingUtils.getPingCmd(ip) + trimString;
        String ret = PingUtils.executeCmd(cmd);
        log.error("Result of ping " + ip + ": " + ret);
        return PingUtils.checkLink(ret, ip);
    }

    public static String getPingCmd(String ip) {
        String cmd = "";
        cmd = NetUtil.isValidIPV6(ip) ? "ping6 " : "ping ";
        return cmd;
    }

    private static boolean checkLink(String ret, String ip) {
        String[] rets;
        if (StringUtils.isNULLStr(ret)) {
            return false;
        }
        for (String current : rets = ret.split("\n")) {
            if (!PingUtils.checkLine(current, ip)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkLine(String ret, String ip) {
        if (StringUtils.isNULLStr(ret)) {
            return false;
        }
        if (ret.contains("TTL=")) {
            return true;
        }
        if (ret.contains("TTL =")) {
            return true;
        }
        if (ret.contains("TTL")) {
            return true;
        }
        if (ret.contains("ttl=")) {
            return true;
        }
        if (ret.toLowerCase(Locale.ENGLISH).contains("unreachable")) {
            return false;
        }
        if (ret.toLowerCase(Locale.ENGLISH).contains("reply from")) {
            return true;
        }
        return StringUtils.isIpv6Address(ip) && ret.contains("<");
    }
}

