/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.tool.obase.constant.ToolConstants;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamUtils {
    private static final Logger log = LoggerFactory.getLogger(StreamUtils.class);

    private StreamUtils() {
    }

    public static void writeInfo2File(byte[] message, String filePath) {
        try {
            StreamUtils.writeInfo2File(message, filePath, false);
        }
        catch (IOException e) {
            log.error("writeInfo2File error.", e);
        }
    }

    public static void writeInfo2FileThrowEx(byte[] message, String filePath) throws IOException {
        StreamUtils.writeInfo2File(message, filePath, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeInfo2File(byte[] message, String filePath, boolean isThrowEx) throws IOException {
        BufferedOutputStream outputStream;
        File outFile;
        block5: {
            outFile = new File(filePath);
            outputStream = null;
            if (outFile.exists() || outFile.createNewFile()) break block5;
            LoggerFactory.getLogger(StreamUtils.class).error("Can not create out file " + outFile);
            StreamUtils.closeStream(outputStream, null);
            return;
        }
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(outFile));
            outputStream.write(message);
            outputStream.flush();
        }
        catch (IOException e) {
            block6: {
                try {
                    LoggerFactory.getLogger(StreamUtils.class).error("Write file error... {}", (Object)outFile, (Object)e);
                    if (!isThrowEx) break block6;
                    throw e;
                }
                catch (Throwable throwable) {
                    StreamUtils.closeStream(outputStream, null);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(outputStream, null);
        }
        StreamUtils.closeStream(outputStream, null);
    }

    public static void closeStream(OutputStream output, InputStream input) {
        StreamUtils.closeResource(output, output);
        StreamUtils.closeResource(null, input);
    }

    public static void closeResource(Flushable flushable, Closeable closeable) {
        try {
            if (null != flushable) {
                flushable.flush();
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(StreamUtils.class).error("Close output stream error...", e);
        }
        try {
            if (null != closeable) {
                closeable.close();
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(StreamUtils.class).error("Close output stream error...", e);
        }
    }

    public static String readResourcesAsClassLoader(String name, Class<?> clazz) {
        ClassLoader classLoader = clazz.getClassLoader();
        if (null == classLoader) {
            throw new EncapsulatedRuntimeException("cannot get the class loader.");
        }
        InputStream input = classLoader.getResourceAsStream(name);
        log.info("read template file : /config/template/{}", (Object)name);
        return StreamUtils.readStringFormInputStream(input);
    }

    public static String readStringFormFile(File file) {
        InputStream in = StreamUtils.createInputStream(file);
        return StreamUtils.readStringFormInputStream(in);
    }

    public static String readStringFormFile(File file, String charset) {
        InputStream in = StreamUtils.createInputStream(file);
        return StreamUtils.readStringFormInputStream(in, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String readStringFormInputStream(InputStream input, String charset) {
        BufferedReader reader = null;
        StringBuffer buffer = new StringBuffer();
        String line = null;
        try {
            reader = new BufferedReader(new InputStreamReader(input, charset));
            while (null != (line = reader.readLine())) {
                buffer.append(line);
                buffer.append(ToolConstants.ENTER);
            }
        }
        catch (RuntimeException e) {
            log.error("Read error {}", (Object)buffer.toString(), (Object)e);
            StreamUtils.closeStream(null, input);
            StreamUtils.closeResource(null, reader);
        }
        catch (Exception e2) {
            log.error("Read error {}", (Object)buffer.toString(), (Object)e2);
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, input);
                    StreamUtils.closeResource(null, reader);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, input);
            StreamUtils.closeResource(null, reader);
        }
        StreamUtils.closeStream(null, input);
        StreamUtils.closeResource(null, reader);
        return buffer.toString();
    }

    public static String readStringFormInputStream(InputStream input) {
        return StreamUtils.readStringFormInputStream(input, "UTF-8");
    }

    public static InputStream createInputStream(File input) {
        try {
            return new FileInputStream(FilePathUtils.checkFile((File)input.getCanonicalFile()));
        }
        catch (FileNotFoundException e) {
            log.error("Can't found file {} .", (Object)input.getName());
        }
        catch (IOException e) {
            log.error("GetCanonicalFile failed.", e);
        }
        return null;
    }

    public static InputStream createFileInputStream(File input) throws ToolException {
        try {
            return new FileInputStream(FilePathUtils.checkFile((File)input.getCanonicalFile()));
        }
        catch (FileNotFoundException e) {
            log.error("Can't found file {} .", (Object)input.getName());
            throw new ToolException("Can't found file.");
        }
        catch (IOException e) {
            log.error("GetCanonicalFile failed.", e);
            throw new ToolException("GetCanonicalFile failed.", e);
        }
    }

    public static void copyFile(File sourceFile, File targetFile) {
        try {
            StreamUtils.copyFile(sourceFile, targetFile, false);
        }
        catch (IOException e) {
            log.error("copy file error.", e);
        }
    }

    public static void copyFileThrowEx(File sourceFile, File targetFile) throws IOException {
        StreamUtils.copyFile(sourceFile, targetFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void copyFile(File sourceFile, File targetFile, boolean isThrowEx) throws IOException {
        BufferedInputStream inBuff = null;
        BufferedOutputStream outBuff = null;
        try {
            int len;
            FileInputStream input = new FileInputStream(sourceFile);
            inBuff = new BufferedInputStream(input);
            FileOutputStream output = new FileOutputStream(targetFile);
            outBuff = new BufferedOutputStream(output);
            byte[] b = new byte[5120];
            while ((len = inBuff.read(b)) != -1) {
                outBuff.write(b, 0, len);
            }
        }
        catch (FileNotFoundException e) {
            block7: {
                log.error("file not found.");
                if (!isThrowEx) break block7;
                throw new IOException("file not found.");
            }
            StreamUtils.closeStream(outBuff, inBuff);
        }
        catch (IOException e2) {
            block8: {
                log.error("copyFile failed.", e2);
                if (!isThrowEx) break block8;
                throw e2;
                {
                    catch (Throwable throwable) {
                        StreamUtils.closeStream(outBuff, inBuff);
                        throw throwable;
                    }
                }
            }
            StreamUtils.closeStream(outBuff, inBuff);
        }
        StreamUtils.closeStream(outBuff, inBuff);
    }
}

