/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils.reflection;

import com.huawei.ism.tool.obase.utils.StringUtils;

public interface PrimitiveParser {
    public Object parseValue(String var1);

    public static class DoubleParser
    implements PrimitiveParser {
        @Override
        public Object parseValue(String value) {
            return StringUtils.isNULLStr(value) ? 0.0 : Double.parseDouble(value);
        }
    }

    public static class FloatParser
    implements PrimitiveParser {
        @Override
        public Object parseValue(String value) {
            return Float.valueOf(StringUtils.isNULLStr(value) ? 0.0f : Float.parseFloat(value));
        }
    }

    public static class LongParser
    implements PrimitiveParser {
        @Override
        public Object parseValue(String value) {
            return StringUtils.isNULLStr(value) ? 0L : Long.parseLong(value);
        }
    }

    public static class IntegerParser
    implements PrimitiveParser {
        @Override
        public Object parseValue(String value) {
            return StringUtils.isNULLStr(value) ? 0 : Integer.parseInt(value);
        }
    }

    public static class ShortParser
    implements PrimitiveParser {
        @Override
        public Object parseValue(String value) {
            return StringUtils.isNULLStr(value) ? (short)0 : Short.parseShort(value);
        }
    }

    public static class CharParser
    implements PrimitiveParser {
        @Override
        public Object parseValue(String value) {
            return Character.valueOf(StringUtils.isNULLStr(value) ? (char)'\u0000' : value.charAt(0));
        }
    }

    public static class ByteParser
    implements PrimitiveParser {
        @Override
        public Object parseValue(String value) {
            return StringUtils.isNULLStr(value) ? (byte)0 : Byte.parseByte(value);
        }
    }

    public static class BooleanParser
    implements PrimitiveParser {
        @Override
        public Object parseValue(String value) {
            return StringUtils.isNULLStr(value) ? false : Boolean.parseBoolean(value);
        }
    }
}

