/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.sdk.unified.log.configuration;

import com.huawei.ism.tool.sdk.unified.log.filter.sensitive.throwable.SensitiveThrowableFilter;
import com.huawei.ism.tool.sdk.unified.log.filter.sensitive.words.SensitiveWordsFilter;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.core.filter.CompositeFilter;

public class RequiredFiltersAutoConfigXmlConfiguration
extends XmlConfiguration {
    private static final Map<Class<?>, Function<Configuration, Filter>> REQUIRED_FILTER_TYPES;

    public RequiredFiltersAutoConfigXmlConfiguration(LoggerContext loggerContext, ConfigurationSource configSource) {
        super(loggerContext, configSource);
    }

    protected void doConfigure() {
        super.doConfigure();
        this.addRequiredFilters();
    }

    private void addRequiredFilters() {
        Filter filter = this.getFilter();
        REQUIRED_FILTER_TYPES.entrySet().stream().filter(entry -> !this.isRequiredFiltersExist((Class)entry.getKey(), filter)).map(Map.Entry::getValue).map(builder -> (Filter)builder.apply(this)).filter(Objects::nonNull).forEach(arg_0 -> ((RequiredFiltersAutoConfigXmlConfiguration)this).addFilter(arg_0));
    }

    private boolean isRequiredFiltersExist(Class<?> filterType, Filter filter) {
        if (filter == null) {
            return false;
        }
        if (filter instanceof CompositeFilter) {
            for (Filter oneFilter : ((CompositeFilter)filter).getFiltersArray()) {
                if (!this.isRequiredFiltersExist(filterType, oneFilter)) continue;
                return true;
            }
            return false;
        }
        return filterType.isAssignableFrom(filter.getClass());
    }

    static {
        LinkedHashMap<Class, Function<Configuration, Filter>> filterDefaultBuilders = new LinkedHashMap<Class, Function<Configuration, Filter>>();
        filterDefaultBuilders.put(SensitiveWordsFilter.class, SensitiveWordsFilter::buildOnRequired);
        filterDefaultBuilders.put(SensitiveThrowableFilter.class, SensitiveThrowableFilter::buildOnRequired);
        REQUIRED_FILTER_TYPES = Collections.unmodifiableMap(filterDefaultBuilders);
    }
}

