/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.sdk.unified.log.filter.sensitive.words.rule;

import com.huawei.ism.tool.sdk.unified.log.filter.sensitive.words.rule.SensitiveWordsRule;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.NotBlank;
import org.apache.logging.log4j.util.Strings;

@Plugin(name="PlainFilterRule", category="Core", elementType="SensitiveWordsRule", printObject=true)
public abstract class PlainFilterRule
implements SensitiveWordsRule {
    protected final String replacement;
    protected final Function<String, String> shieldedMsgGenerate;

    protected PlainFilterRule(String replacement) {
        this.replacement = replacement;
        this.shieldedMsgGenerate = this.replacement == null ? SensitiveWordsRule::getDefaultShieldedMsg : ignored -> this.replacement;
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<PlainFilterRule> {
        @NotBlank
        @PluginBuilderAttribute(value="target")
        private String target;
        @PluginBuilderAttribute(value="caseSensitive")
        private boolean caseSensitive = false;
        @PluginBuilderAttribute(value="separator")
        private String separator;
        @PluginBuilderAttribute(value="matchWords")
        private boolean matchWords = false;
        @PluginBuilderAttribute(value="replacement")
        private String replacement;

        public PlainFilterRule build() {
            String[] targets;
            String[] stringArray;
            if (Strings.isEmpty((CharSequence)this.separator)) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.target;
            } else {
                stringArray = targets = (String[])Arrays.stream(this.target.split(this.separator)).filter(Strings::isNotBlank).toArray(String[]::new);
            }
            if (this.matchWords) {
                return new MatchWords(targets, this.caseSensitive, this.replacement);
            }
            if (this.caseSensitive) {
                return new CaseSensitive(targets, this.replacement);
            }
            return new CaseInsensitive(targets, this.replacement);
        }

        public Builder setTarget(String target) {
            this.target = target;
            return this;
        }

        public Builder setCaseSensitive(boolean caseSensitive) {
            this.caseSensitive = caseSensitive;
            return this;
        }

        public Builder setSeparator(String separator) {
            this.separator = separator;
            return this;
        }

        public Builder setMatchWords(boolean matchWords) {
            this.matchWords = matchWords;
            return this;
        }

        public Builder setReplacement(String replacement) {
            this.replacement = replacement;
            return this;
        }

        public String getTarget() {
            return this.target;
        }

        public boolean isCaseSensitive() {
            return this.caseSensitive;
        }

        public String getSeparator() {
            return this.separator;
        }

        public boolean isMatchWords() {
            return this.matchWords;
        }

        public String getReplacement() {
            return this.replacement;
        }
    }

    private static class CaseInsensitive
    extends PlainFilterRule {
        private final String[] targets;

        private CaseInsensitive(String[] targets, String replacement) {
            super(replacement);
            this.targets = (String[])Arrays.stream(targets).map(String::toLowerCase).toArray(String[]::new);
        }

        @Override
        public String filterSensitiveWords(String line) {
            String lowerLine = line.toLowerCase(Locale.ROOT);
            for (String target : this.targets) {
                if (!lowerLine.contains(target)) continue;
                return (String)this.shieldedMsgGenerate.apply(target);
            }
            return null;
        }

        public String toString() {
            return "PlainFilterRule.CaseInsensitive{targets=" + Arrays.toString(this.targets) + ", replacement='" + this.replacement + '\'' + '}';
        }
    }

    private static class CaseSensitive
    extends PlainFilterRule {
        private final String[] targets;

        private CaseSensitive(String[] targets, String replacement) {
            super(replacement);
            this.targets = targets;
        }

        @Override
        public String filterSensitiveWords(String line) {
            for (String target : this.targets) {
                if (!line.contains(target)) continue;
                return (String)this.shieldedMsgGenerate.apply(target);
            }
            return null;
        }

        public String toString() {
            return "PlainFilterRule.CaseSensitive{targets=" + Arrays.toString(this.targets) + ", replacement='" + this.replacement + '\'' + '}';
        }
    }

    private static class MatchWords
    extends PlainFilterRule {
        private final Pattern[] patternTargets;

        private MatchWords(String[] targets, boolean caseSensitive, String replacement) {
            super(replacement);
            this.patternTargets = (Pattern[])Arrays.stream(targets).map(target -> Pattern.compile("\\b" + Pattern.quote(target) + "\\b", caseSensitive ? 0 : 2)).toArray(Pattern[]::new);
        }

        @Override
        public String filterSensitiveWords(String line) {
            for (Pattern pattern : this.patternTargets) {
                if (!pattern.matcher(line).find()) continue;
                return (String)this.shieldedMsgGenerate.apply(pattern.toString());
            }
            return null;
        }

        public String toString() {
            return "PlainFilterRule.MatchWords{patternTargets=" + Arrays.toString(this.patternTargets) + ", replacement='" + this.replacement + '\'' + '}';
        }
    }
}

