/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.collect.dstorage.entity;

import com.huawei.ism.tool.service.collect.dstorage.entity.CollectModule;
import com.huawei.ism.tool.service.common.entity.TaskDetail;
import com.huawei.ism.tool.service.rest.model.enumz.Status;
import java.util.Observable;

public class SubTaskDetail
extends TaskDetail {
    final String id;
    final String parentId;
    final CollectModule module;
    final String localPath;
    int collectPro;
    int downloadPro;
    boolean packed;

    public void updateCollectPro(int pro) {
        if (pro == this.collectPro) {
            return;
        }
        this.collectPro = pro;
        this.updateDetail();
    }

    public void fail(String errDesc) {
        this.description = errDesc;
        this.collectPro = 100;
        this.downloadPro = 100;
        this.status = Status.FAILED;
        this.changed = true;
        this.updateDetail();
    }

    public void success() {
        this.description = "";
        this.collectPro = 100;
        this.downloadPro = 100;
        this.status = Status.SUCCESS;
        this.changed = true;
        this.updateDetail();
    }

    @Override
    public void updateDetail() {
        this.updatePro();
        this.updateStatus();
        this.update();
    }

    private void updateStatus() {
        if (this.pro != 0 && this.pro < 100) {
            this.status = Status.RUNNING;
        }
    }

    private void updatePro() {
        int old = this.pro;
        this.pro = (this.collectPro + this.downloadPro) / 2;
        if (old == this.pro) {
            return;
        }
        this.changed = true;
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    SubTaskDetail(String id, String parentId, CollectModule module, String localPath, int collectPro, int downloadPro, boolean packed) {
        this.id = id;
        this.parentId = parentId;
        this.module = module;
        this.localPath = localPath;
        this.collectPro = collectPro;
        this.downloadPro = downloadPro;
        this.packed = packed;
    }

    public static SubTaskDetailBuilder builder() {
        return new SubTaskDetailBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public CollectModule getModule() {
        return this.module;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public int getCollectPro() {
        return this.collectPro;
    }

    public int getDownloadPro() {
        return this.downloadPro;
    }

    public boolean isPacked() {
        return this.packed;
    }

    public void setCollectPro(int collectPro) {
        this.collectPro = collectPro;
    }

    public void setDownloadPro(int downloadPro) {
        this.downloadPro = downloadPro;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubTaskDetail)) {
            return false;
        }
        SubTaskDetail other = (SubTaskDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCollectPro() != other.getCollectPro()) {
            return false;
        }
        if (this.getDownloadPro() != other.getDownloadPro()) {
            return false;
        }
        if (this.isPacked() != other.isPacked()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        CollectModule this$module = this.getModule();
        CollectModule other$module = other.getModule();
        if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
            return false;
        }
        String this$localPath = this.getLocalPath();
        String other$localPath = other.getLocalPath();
        return !(this$localPath == null ? other$localPath != null : !this$localPath.equals(other$localPath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubTaskDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCollectPro();
        result = result * 59 + this.getDownloadPro();
        result = result * 59 + (this.isPacked() ? 79 : 97);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        CollectModule $module = this.getModule();
        result = result * 59 + ($module == null ? 43 : $module.hashCode());
        String $localPath = this.getLocalPath();
        result = result * 59 + ($localPath == null ? 43 : $localPath.hashCode());
        return result;
    }

    public String toString() {
        return "SubTaskDetail(id=" + this.getId() + ", parentId=" + this.getParentId() + ", module=" + this.getModule() + ", localPath=" + this.getLocalPath() + ", collectPro=" + this.getCollectPro() + ", downloadPro=" + this.getDownloadPro() + ", packed=" + this.isPacked() + ")";
    }

    public void setPacked(boolean packed) {
        this.packed = packed;
    }

    public static class SubTaskDetailBuilder {
        private String id;
        private String parentId;
        private CollectModule module;
        private String localPath;
        private int collectPro;
        private int downloadPro;
        private boolean packed;

        SubTaskDetailBuilder() {
        }

        public SubTaskDetailBuilder id(String id) {
            this.id = id;
            return this;
        }

        public SubTaskDetailBuilder parentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        public SubTaskDetailBuilder module(CollectModule module) {
            this.module = module;
            return this;
        }

        public SubTaskDetailBuilder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public SubTaskDetailBuilder collectPro(int collectPro) {
            this.collectPro = collectPro;
            return this;
        }

        public SubTaskDetailBuilder downloadPro(int downloadPro) {
            this.downloadPro = downloadPro;
            return this;
        }

        public SubTaskDetailBuilder packed(boolean packed) {
            this.packed = packed;
            return this;
        }

        public SubTaskDetail build() {
            return new SubTaskDetail(this.id, this.parentId, this.module, this.localPath, this.collectPro, this.downloadPro, this.packed);
        }

        public String toString() {
            return "SubTaskDetail.SubTaskDetailBuilder(id=" + this.id + ", parentId=" + this.parentId + ", module=" + this.module + ", localPath=" + this.localPath + ", collectPro=" + this.collectPro + ", downloadPro=" + this.downloadPro + ", packed=" + this.packed + ")";
        }
    }
}

