/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.common;

import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DevInfoUtil {
    private static final Logger log = LoggerFactory.getLogger(DevInfoUtil.class);
    private static final List<String> VERSION_PREFIX_DISK = Arrays.asList("8.0.3", "8.1", "8.2");

    public static String getCompleteDevVersion(DevNode devNode) {
        if (devNode == null) {
            log.error("devNode is null");
            return "";
        }
        String productVersion = devNode.getProductVersion();
        String hotPatchVersion = devNode.getHotPatchVersion();
        return DevInfoUtil.buildCompleteProductVersion(productVersion, hotPatchVersion);
    }

    public static String buildCompleteProductVersion(String productVersion, String hotPatchVersion) {
        if (StringUtils.isNULLStr(productVersion)) {
            return "";
        }
        if (StringUtils.isNULLStr(hotPatchVersion)) {
            return productVersion;
        }
        if (hotPatchVersion.contains(productVersion)) {
            return hotPatchVersion;
        }
        if (productVersion.contains(hotPatchVersion)) {
            return productVersion;
        }
        return productVersion + "." + hotPatchVersion;
    }

    public static DevNode getActiveFsmNode(List<DevNode> fsmDevNodeList) {
        return fsmDevNodeList.stream().filter(DevInfoUtil::isActiveFsmNode).findFirst().get();
    }

    private static boolean isActiveFsmNode(DevNode devNode) {
        try {
            String res = "";
            res = devNode.isMiniSystem() ? SshConnectionManager.getSshConnection(devNode).execCmd("get_harole.sh") : SshConnectionManager.getSshConnection(devNode).execCmd("sh /opt/dfv/oam/oam-u/ha/ha/module/hacom/script/get_harole.sh");
            boolean bl = res.contains("active");
            return bl;
        }
        catch (ToolException e) {
            log.error("query active fsm node failed.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            SshConnectionManager.releaseConnection(devNode);
        }
    }

    public static boolean isSupportDiskPool(DevNode devNode) {
        boolean isSupportDiskPoolVersion = VERSION_PREFIX_DISK.stream().anyMatch(version -> devNode.getProductVersion().contains((CharSequence)version));
        return devNode.isDsStorage() && isSupportDiskPoolVersion || devNode.isDataTurbo() || devNode.isOceanStorA310();
    }

    private DevInfoUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

