/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.common;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileAssistant;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceFileUtil {
    private static final Logger log = LoggerFactory.getLogger(ResourceFileUtil.class);

    private ResourceFileUtil() {
    }

    public static File getResourceFileAndAddProductFile(DevNode devNode, String localPath, String resourceType) throws ToolException {
        String temp = ResourceFileUtil.getDstorageTmpPath() + File.separator + devNode.getDeviceSerialNumber();
        if (new File(temp).exists()) {
            FileUtils.clearDir(temp);
        }
        try {
            RestConnection conn = RestConnectionManager.getRestConnection((DevNode)devNode);
            String getResourceFilesUri = RestUtil.getResourceUri((DevNode)devNode);
            HashMap<String, String> reqParam = new HashMap<String, String>();
            reqParam.put("resource_type", resourceType);
            ResponseInfo resp = conn.execGetFile(getResourceFilesUri, reqParam, temp);
            Map restContentMap = resp.getContentMap();
            Long errorCode = (Long)restContentMap.get("errorCode");
            if (null != errorCode && 0L != errorCode) {
                throw new ToolException("Get inspection resource file failed, error code:" + errorCode);
            }
            Iterator entryItr = restContentMap.entrySet().iterator();
            String resourceZipFileName = null;
            while (entryItr.hasNext()) {
                Map.Entry contentEntry = entryItr.next();
                String key = (String)contentEntry.getKey();
                if (null == key || !key.contains(".zip")) continue;
                resourceZipFileName = key;
            }
            boolean zipSucc = false;
            File zipToDir = null;
            log.info("resourceZipFileName = {}", resourceZipFileName);
            String productDir = null;
            if (null != resourceZipFileName) {
                productDir = localPath + devNode.getDeviceSerialNumber();
                zipToDir = new File(productDir);
                File zipFile = new File(resourceZipFileName);
                zipSucc = FileAssistant.deCopmressAllZipFile(productDir, resourceZipFileName);
                zipFile.delete();
            }
            if (zipSucc) {
                File file = zipToDir;
                return file;
            }
            throw new ToolException("unzip inspection resource file failed.");
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)devNode);
        }
    }

    private static String getDstorageTmpPath() {
        return ApplicationContext.getInstance().getWorkPath() + File.separator + "temp" + File.separator + "Dstorage";
    }
}

