/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.common.util;

import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.NetUtil;

public class DistributeRestUriUtil {
    private static final String DEVICE_MANAGER_REST = "/deviceManager/rest/";
    private static final String LICENSE_URI = "/license/activelicense";
    private static final String LICENSE_COMMON_INFO_URI = "/dsware/service/license/queryLicenseInfo";
    private static final String QUERY_ALL_INFO = "/dsware/service/resource/queryAllDisk";
    private static final String QUERY_DISK_INFO = "/dsware/service/resource/queryDiskInfo";
    private static final String DS_STORAGE_COMMON = "/api/v2/common";
    private static final String DS_CLUSTER_URI = "/api/v2/cluster";
    private static final String DS_PRODUCT_URI = "/product";
    private static final String DS_SYSTEM_URI = "/esn";
    private static final String DS_NODES_URI = "/servers";
    private static final String HTTPS_PREFIX = "https://";
    private static final String PORT_CONNECTOR = ":";
    private static final int REST_CONN_PORT = 8088;
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";

    public static String getClusterProductInfoUri(DevNode devNode) {
        return DistributeRestUriUtil.getDstorageUrlHead(devNode).append(DS_CLUSTER_URI).append(DS_PRODUCT_URI).toString();
    }

    public static String getClusterEsnInfoUri(DevNode devNode) {
        return DistributeRestUriUtil.getDstorageUrlHead(devNode).append(DS_STORAGE_COMMON).append(DS_SYSTEM_URI).toString();
    }

    public static String getClusterNodesUri(DevNode devNode) {
        return DistributeRestUriUtil.getDstorageUrlHead(devNode).append(DS_CLUSTER_URI).append(DS_NODES_URI).toString();
    }

    public static String getDevicePartUri(DevNode devNode) {
        return DistributeRestUriUtil.getDstorageUrlHead(devNode).append(QUERY_ALL_INFO).toString();
    }

    public static String getActiveLicensesUri(DevNode devNode) {
        return DistributeRestUriUtil.getDstorageUrlHead(devNode).append(DEVICE_MANAGER_REST).append(devNode.getProductVersion()).append(LICENSE_URI).toString();
    }

    public static String getLoadLicensesUri(DevNode devNode) {
        return DistributeRestUriUtil.getDstorageUrlHead(devNode).append(LICENSE_COMMON_INFO_URI).toString();
    }

    public static String processIPByURL(String ip) {
        return NetUtil.isValidIPV6(ip) ? LEFT_BRACKET + ip + RIGHT_BRACKET : ip;
    }

    public static StringBuilder getDstorageUrlHead(DevNode devNode) {
        return new StringBuilder(HTTPS_PREFIX).append(DistributeRestUriUtil.processIPByURL(devNode.getIp())).append(PORT_CONNECTOR).append(8088);
    }

    public static String getQueryDiskInfoUrl(DevNode devNode, String nodeIp) {
        return DistributeRestUriUtil.getDstorageUrlHead(devNode).append(QUERY_DISK_INFO).append("?ip=").append(nodeIp).toString();
    }
}

