/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.deploy.conf;

import com.huawei.ism.tool.devicemanager.entity.ProductUniqueIdConfig;
import java.util.HashSet;
import java.util.Set;

public class PlatformStrategy {
    private static final Attribute NONE = new Attribute("--", "--", "--");
    private final ProductUniqueIdConfig.HardwarePlatform platform;
    private final Set<Attribute> attributes = new HashSet<Attribute>();

    public PlatformStrategy(ProductUniqueIdConfig.HardwarePlatform platform) {
        this.platform = platform;
    }

    public String getPlatformId() {
        return this.platform.getId();
    }

    public PlatformStrategy getSelf() {
        return this;
    }

    public void addAttribute(String name, String key, String value) {
        this.attributes.add(new Attribute(name, key, value));
    }

    public String findAttributeValue(String key) {
        return this.attributes.stream().filter(attribute -> attribute.getKey().equals(key)).findFirst().orElse(NONE).getValue();
    }

    public ProductUniqueIdConfig.HardwarePlatform getPlatform() {
        return this.platform;
    }

    private static class Attribute {
        private String name;
        private String key;
        private String value;

        public Attribute(String name, String key, String value) {
            this.name = name;
            this.key = key;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Attribute)) {
                return false;
            }
            Attribute other = (Attribute)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            return !(this$key == null ? other$key != null : !this$key.equals(other$key));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Attribute;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            return result;
        }
    }
}

