/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.patch.dstorage.entity;

import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum LayerItem {
    FUSIONSTORAGE_OAM_U("FusionStorage_oam-u", ResourceUtil.getString("check.tiem.layer.fusionstorage.oam.u")),
    SERVICE_LAYER("Service-Layer", ResourceUtil.getString("check.tiem.layer.service.layer")),
    INDEX_LAYER("Index-Layer", ResourceUtil.getString("check.tiem.layer.index.layer")),
    PERSISTENCE_LAYER("Persistence-Layer", ResourceUtil.getString("check.tiem.layer.persistence.layer")),
    INFRASTRUCTURE("Infrastructure", ResourceUtil.getString("check.tiem.layer.infrastructure")),
    FUSIONSTORAGE_FSM("FusionStorage_fsm", ResourceUtil.getString("check.tiem.layer.fusionstorage.fsm")),
    FUSIONSTORAGE_BASE("FusionStorage_base", ResourceUtil.getString("check.tiem.layer.fusionstorage.base"));

    private static final Logger log;
    private final String key;
    private final String description;

    public static String getDescription(String key) {
        Optional<LayerItem> layerItem = Stream.of(LayerItem.values()).filter(item -> item.getKey().equals(key)).findFirst();
        if (!layerItem.isPresent()) {
            log.info("The specified parent inspection {} does not exist.", (Object)key);
            return "--";
        }
        return layerItem.get().getDescription();
    }

    private LayerItem(String key, String description) {
        this.key = key;
        this.description = description;
    }

    public String getKey() {
        return this.key;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        log = LoggerFactory.getLogger(LayerItem.class);
    }
}

