/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.patch.dstorage.service;

import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.KeyValue;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.ism.tool.service.patch.dstorage.service.ImportTask;
import com.huawei.ism.tool.service.patch.service.IBatchPatchImport;
import com.huawei.ism.tool.service.patch.service.IPatchImport;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.MultiErrorYesOrNoDialog;
import com.huawei.ism.util.Pair;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchPatchImportImp
extends ImportTask
implements IBatchPatchImport<Pair<DevNode, DstoragePatchInfo>, TaskResult> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchPatchImportImp.class);
    private ExecutorService service = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TaskResult> batchImport(List<IPatchImport<Pair<DevNode, DstoragePatchInfo>, TaskResult>> tasks) {
        if (tasks.isEmpty()) {
            LOGGER.warn("Task list is empty.");
            return Collections.emptyList();
        }
        LOGGER.info("Start batch import task,tasks num is {}", (Object)tasks.size());
        this.service = Executors.newFixedThreadPool(Math.min(tasks.size(), threadNum));
        ArrayList<KeyValue<IPatchImport<Pair<DevNode, DstoragePatchInfo>, TaskResult>, Future<TaskResult>>> results = new ArrayList<KeyValue<IPatchImport<Pair<DevNode, DstoragePatchInfo>, TaskResult>, Future<TaskResult>>>(tasks.size());
        try {
            tasks.forEach(task -> {
                Callable<TaskResult> taskCallable = task::importPatch;
                results.add(new KeyValue<IPatchImport, Future<TaskResult>>((IPatchImport)task, this.service.submit(taskCallable)));
            });
            List<TaskResult> list = this.waitTaskFinish(results);
            return list;
        }
        catch (Exception e) {
            LOGGER.error("Exec import task failed.", (Throwable)e);
            List<TaskResult> list = Collections.emptyList();
            return list;
        }
        finally {
            this.service.shutdown();
        }
    }

    public static boolean isUploadFailed(List<TaskResult> taskResultList) {
        return taskResultList.stream().anyMatch(BatchPatchImportImp::isUploadFailed);
    }

    public static boolean isUploadFailed(TaskResult result) {
        return result != null && !result.isTaskSuccess();
    }

    public static MultiErrorYesOrNoDialog getNodeUploadFailedTipDialog(Window window, List<TaskResult> resultList, boolean hasMsg) {
        String[] headers = new String[]{ResourceUtil.getString("patch.import.failed.cluster.ip"), ResourceUtil.getString("patch.import.failed.cluster.failed.desc")};
        ArrayList datas = new ArrayList();
        for (TaskResult result : resultList) {
            if (!(result.getResultObject() instanceof Pair)) continue;
            DevNode devNode = (DevNode)((Pair)result.getResultObject()).getKey();
            ArrayList<String> data = new ArrayList<String>();
            data.add(devNode.getIp());
            data.add(result.getErrorLocaleDescription());
            datas.add(data);
        }
        if (hasMsg) {
            return DialogUtils.createMultiWarningYesNoDialog((Window)window, (String)ResourceUtil.getString("patch.import.failed.cluster.node.id.dialog.msg"), (String[])headers, datas);
        }
        return DialogUtils.createMultiWarningYesNoDialog((Window)window, (String)"", (String[])headers, datas);
    }

    private List<TaskResult> waitTaskFinish(List<KeyValue<IPatchImport<Pair<DevNode, DstoragePatchInfo>, TaskResult>, Future<TaskResult>>> futureKeyValueList) {
        ArrayList<TaskResult> results = new ArrayList<TaskResult>(futureKeyValueList.size());
        futureKeyValueList.forEach(futureKeyValue -> {
            try {
                results.add((TaskResult)((Future)futureKeyValue.getValue()).get(taskTimeout, TimeUnit.MINUTES));
            }
            catch (TimeoutException e) {
                LOGGER.warn("Import task executed time out.");
                TaskResult result = new TaskResult();
                result.setResultObject(((IPatchImport)futureKeyValue.getKey()).getIdentity());
                result.setErrorLocaleDescription(ResourceUtil.getString("patch.import.timeout"));
                results.add(result);
            }
            catch (Exception e) {
                LOGGER.error("Import task exec failed.", (Throwable)e);
                TaskResult result = new TaskResult();
                result.setResultObject(((IPatchImport)futureKeyValue.getKey()).getIdentity());
                result.setErrorLocaleDescription(ResourceUtil.getString("patch.import.failed"));
                results.add(result);
            }
        });
        return results;
    }
}

