/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.patch.dstorage.service;

import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.framework.pubservice.entity.TaskResult;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import com.huawei.ism.tool.service.patch.dstorage.entity.DstoragePatchInfo;
import com.huawei.ism.tool.service.patch.dstorage.service.ImportTask;
import com.huawei.ism.tool.service.patch.dstorage.ui.PatchComponent;
import com.huawei.ism.tool.service.patch.service.IHandler;
import com.huawei.ism.tool.service.patch.service.IPatchImport;
import com.huawei.ism.util.Pair;
import com.huawei.json.JSONArray;
import com.huawei.json.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchImportImp
extends ImportTask
implements IPatchImport<Pair<DevNode, DstoragePatchInfo>, TaskResult> {
    private static final Logger log = LoggerFactory.getLogger(PatchImportImp.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(PatchImportImp.class);
    private DevNode devNode;
    private DstoragePatchInfo basicPatchInfo;
    private final TaskResult result = new TaskResult();
    private IHandler<TaskResult> postHandler = null;
    private Pair<DevNode, DstoragePatchInfo> identify;

    public PatchImportImp(DevNode node, DstoragePatchInfo info, IHandler<TaskResult> handler) {
        this();
        this.devNode = node;
        this.basicPatchInfo = info;
        this.postHandler = handler;
        this.identify = new Pair((Object)this.devNode, (Object)this.basicPatchInfo);
    }

    public PatchImportImp(PatchComponent component) {
        this();
        this.devNode = component.getCurrentNode();
        this.basicPatchInfo = component.getCurrentPatch();
        this.postHandler = component.getPostHandler();
    }

    private TaskResult importPackage() throws ToolException {
        RestConnection connection = RestConnectionManager.getRestConnection((DevNode)this.devNode);
        Objects.requireNonNull(connection).setTimeout(taskTimeout * 60);
        String url = DstoragePatchInfo.Type.getURL(this.devNode, this.basicPatchInfo.getPatchType());
        if (Context.INS.getSupportUploadByNodeIdDevMap().getOrDefault(this.devNode, false).booleanValue()) {
            List<String> selectClusterNodeIds = this.devNode.getSelectClusterNodeIds();
            LOGGER.info("upload patch with node ids:{} for device ip:{}", selectClusterNodeIds, (Object)this.devNode.getIp());
            ResponseInfo resp = connection.execPostUploadFileWithNodeIds(url, new File(this.basicPatchInfo.getPatchPath()), selectClusterNodeIds);
            if (this.isFailedErrCode(resp)) {
                if (this.isFaileByNodesUploadPatch(resp)) {
                    this.handleImportResponseInfo(resp);
                } else {
                    throw new ToolException("Import patch failed", false);
                }
            }
            this.basicPatchInfo.updateSelecteNodes(this.devNode, selectClusterNodeIds);
        } else {
            LOGGER.info("upload patch has no ids");
            ResponseInfo resp = connection.execPostUploadFile(url, new File(this.basicPatchInfo.getPatchPath()));
            if (this.isFailedErrCode(resp)) {
                throw new ToolException("Import patch failed", false);
            }
        }
        return this.result;
    }

    private boolean isFailedErrCode(ResponseInfo resp) {
        return resp == null || (Long)resp.getContentMap().get("errorCode") != 0L;
    }

    private boolean isFaileByNodesUploadPatch(ResponseInfo responseInfo) {
        String responseContent = responseInfo.getContent();
        LOGGER.info("ip = {}, content = {}", (Object)this.devNode.getIp(), (Object)responseContent);
        JSONObject responseContentJson = new JSONObject(responseContent);
        if (responseContentJson.has("data")) {
            JSONObject data = responseContentJson.getJSONObject("data");
            return data.has("fail_ids");
        }
        return false;
    }

    private void handleImportResponseInfo(ResponseInfo responseInfo) throws ToolException {
        JSONObject responseContentJson = new JSONObject(responseInfo.getContent());
        JSONObject data = responseContentJson.getJSONObject("data");
        String failIds = data.getJSONArray("fail_ids").toString();
        ToolException exception = new ToolException("cluster.node.patch.file.some.node.fail");
        exception.setDes(this.getImportFailInfo(data, failIds));
        throw exception;
    }

    String getImportFailInfo(JSONObject data, String failIdsStr) {
        List<String> failIds = this.parseFailIds(failIdsStr);
        if (CollectionUtils.isEmpty(failIds) && SceneUtils.isA800SceneInTool()) {
            return ResourceUtil.getString("patch.import.a800.om.failed.empty.cluster.node.desc");
        }
        String failIps = this.getFailIps(failIds);
        String defaultErrorMsg = ResourceUtil.getStringWithParams("patch.import.failed.cluster.node.ip.desc", failIps);
        if (!data.has("fail_detail")) {
            return defaultErrorMsg;
        }
        Map<String, List<String>> errorCodeIps = this.getErrorCodeIps(data.getJSONArray("fail_detail"));
        if (this.isAllErrorCodeNotConfig(errorCodeIps.keySet())) {
            return defaultErrorMsg;
        }
        return this.createErrorInfo(errorCodeIps);
    }

    List<String> parseFailIds(String failIdsStr) {
        if (StringUtils.isNULLStr(failIdsStr)) {
            return Collections.emptyList();
        }
        ArrayList<String> failIds = new ArrayList<String>();
        JSONArray jsonArray = new JSONArray(failIdsStr);
        for (int i = 0; i < jsonArray.length(); ++i) {
            failIds.add(jsonArray.get(i).toString().trim());
        }
        return failIds;
    }

    private String getFailIps(List<String> failIds) {
        if (CollectionUtils.isEmpty(failIds)) {
            return "";
        }
        Map<String, String> idIpMap = this.devNode.getClusterNodes().stream().filter(ClusterNode::isSelected).collect(Collectors.toMap(clusterNode -> String.valueOf(clusterNode.getId()), ClusterNode::getManagementIp));
        return failIds.stream().distinct().map(idIpMap::get).filter(Objects::nonNull).collect(Collectors.joining(", "));
    }

    private String createErrorInfo(Map<String, List<String>> errorCodeIps) {
        StringJoiner errorMsgJoiner = new StringJoiner(System.lineSeparator());
        ArrayList<String> notConfigErrorIps = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : errorCodeIps.entrySet()) {
            String errorCode = entry.getKey();
            String errorMsg = ResourceUtil.getStringWithParams("patch.import.failed.error.code." + errorCode, this.showIps(entry.getValue()));
            if (!"--".equals(errorMsg)) {
                errorMsgJoiner.add(errorMsg);
                continue;
            }
            notConfigErrorIps.addAll((Collection<String>)entry.getValue());
        }
        if (CollectionUtils.isNotEmpty(notConfigErrorIps)) {
            errorMsgJoiner.add(ResourceUtil.getStringWithParams("patch.import.failed.cluster.node.ip.desc", this.showIps(notConfigErrorIps)));
        }
        return errorMsgJoiner.toString();
    }

    private String showIps(List<String> ips) {
        return ips.stream().collect(Collectors.joining(", "));
    }

    private boolean isAllErrorCodeNotConfig(Set<String> errorCodes) {
        return CollectionUtils.isEmpty(errorCodes) || errorCodes.stream().map(errorCode -> ResourceUtil.getString("patch.import.failed.error.code." + errorCode)).allMatch("--"::equals);
    }

    private Map<String, List<String>> getErrorCodeIps(JSONArray detailArray) {
        HashMap<String, List<String>> errorCodeAndIps = new HashMap<String, List<String>>();
        for (int i = 0; i < detailArray.length(); ++i) {
            Object obj = detailArray.get(i);
            if (!(obj instanceof JSONObject)) continue;
            JSONObject jsonObject = (JSONObject)obj;
            String errorCode = jsonObject.getStringOrDefault("error_code", "");
            String ip = jsonObject.getStringOrDefault("fail_ip", "");
            errorCodeAndIps.computeIfAbsent(errorCode, key -> new ArrayList()).add(ip);
        }
        return errorCodeAndIps;
    }

    public TaskResult invokeImport() {
        int curUploadCount = 0;
        this.result.setResultObject((Object)new Pair((Object)this.devNode, (Object)this.basicPatchInfo));
        int maxRetryTimes = 2;
        while (curUploadCount < 2) {
            LOGGER.info(String.format(Locale.ENGLISH, "Start import patch. current retry count %s", ++curUploadCount));
            try {
                return this.importPackage();
            }
            catch (ToolException e) {
                if ("cluster.node.patch.file.some.node.fail".equals(e.getErrorId())) {
                    this.result.setResult(TaskResult.Result.FAILED);
                    this.result.setErrorLocaleDescription(e.getErrorLocaleDescription());
                    return this.result;
                }
                LOGGER.error("Import com.huawei.ism.tool.patch failed.", (Throwable)e);
            }
            catch (Exception e) {
                return this.buildCommonExceptionResult(e);
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.error("sleep fail.", (Throwable)e);
            }
        }
        this.result.setResult(TaskResult.Result.FAILED);
        this.result.setErrorLocaleDescription(ResourceUtil.getString("patch.import.failed"));
        return this.result;
    }

    private TaskResult buildCommonExceptionResult(Exception e) {
        LOGGER.error("Import com.huawei.ism.tool.patch failed.", (Throwable)e);
        this.result.setResult(TaskResult.Result.FAILED);
        this.result.setErrorLocaleDescription(ResourceUtil.getString("patch.import.failed"));
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult importPatch() {
        String name = Thread.currentThread().getName();
        Thread.currentThread().setName(String.format(Locale.ROOT, "ImportThread_%s", this.devNode.getIp()));
        try {
            TaskResult taskResult = this.preCheck();
            this.result.setResultObject((Object)new Pair((Object)this.devNode, (Object)this.basicPatchInfo));
            if (!taskResult.isTaskSuccess()) {
                LOGGER.warn("The parameter is invalid.");
                TaskResult taskResult2 = taskResult;
                return taskResult2;
            }
            taskResult = this.invokeImport();
            if (!taskResult.isTaskSuccess()) {
                LOGGER.warn("Import patch failed.");
                TaskResult taskResult3 = taskResult;
                return taskResult3;
            }
            if (this.postHandler != null) {
                LOGGER.info("Post handle.");
                TaskResult taskResult4 = this.postHandle(this.postHandler);
                return taskResult4;
            }
        }
        catch (Exception e) {
            TaskResult taskResult = this.buildCommonExceptionResult(e);
            return taskResult;
        }
        finally {
            RestConnectionManager.releaseConn((DevNode)this.devNode);
            Thread.currentThread().setName(name);
        }
        this.result.setResult(TaskResult.Result.SUCCESS);
        return this.result;
    }

    @Override
    public TaskResult preCheck() {
        LOGGER.info("Import check.");
        if (!this.devNode.isDsStorage() || StringUtils.isNULLStr(this.basicPatchInfo.getPatchPath()) || !new File(this.basicPatchInfo.getPatchPath()).exists()) {
            this.result.setResult(TaskResult.Result.FAILED);
            this.result.setErrorLocaleDescription(ResourceUtil.getString("patch.import.check.invalid"));
            return this.result;
        }
        LOGGER.info("Try to install patch,patch path : {} .", (Object)this.basicPatchInfo.getPatchPath());
        this.result.setResult(TaskResult.Result.SUCCESS);
        return this.result;
    }

    @Override
    public Pair<DevNode, DstoragePatchInfo> getIdentity() {
        return this.identify;
    }

    private PatchImportImp() {
    }
}

