/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.common;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.service.common.ServiceContext;
import com.huawei.ism.tool.service.rest.model.entity.BusinessDevice;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceObs
extends ServiceContext
implements INodeObserver {
    private static final Logger log = LoggerFactory.getLogger(DeviceObs.class);
    public static final DeviceObs INS = new DeviceObs();
    private final Map<String, BusinessDevice> sn2BusinessDevMap = new ConcurrentHashMap<String, BusinessDevice>();

    public void fireNodeAdd(DevNode dev) throws ToolException {
        if (dev == null || StringUtils.isNULLStr((String)dev.getDeviceSerialNumber())) {
            log.error("Device is null.");
            return;
        }
        this.sn2BusinessDevMap.put(dev.getDeviceSerialNumber(), new BusinessDevice(dev));
    }

    public void fireNodeDelete(DevNode dev) throws ToolException {
        if (dev == null) {
            log.error("Device is null.");
            return;
        }
        this.sn2BusinessDevMap.remove(dev.getDeviceSerialNumber());
    }

    public void fireNodeModify(DevNode dev) {
    }

    public Map<String, BusinessDevice> getSn2BusinessDevMap() {
        return this.sn2BusinessDevMap;
    }
}

