/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.config;

import com.huawei.ism.tool.service.rest.util.CertsUtil;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class SslSupportConfig
implements EnvironmentPostProcessor {
    private final Log log;

    public SslSupportConfig(DeferredLogFactory deferredLogFactory) {
        this.log = deferredLogFactory.getLog(SslSupportConfig.class);
    }

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        String name = "Config resource 'class path resource [application.yml]' via location 'optional:classpath:/'";
        this.log.info((Object)"init ssl config");
        Security.addProvider((Provider)new BouncyCastleProvider());
        MapPropertySource propertySource = (MapPropertySource)environment.getPropertySources().get(name);
        if (propertySource == null) {
            this.log.warn((Object)String.format("get %s propertySource fail", name));
            return;
        }
        Map source = (Map)propertySource.getSource();
        HashMap<String, Object> map = new HashMap<String, Object>();
        source.forEach(map::put);
        map.replace("server.port", environment.getProperty("server.port"));
        map.replace("server.ssl.key-store", CertsUtil.DEFAULT_CERT_FILE_PATH);
        map.replace("server.ssl.key-alias", "FusionServerTools");
        map.replace("server.ssl.key-store-password", CertsUtil.getCertStorePass());
        map.replace("server.ssl.enabled", true);
        environment.getPropertySources().replace(name, (PropertySource)new MapPropertySource(name, map));
    }
}

