/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.model.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;

public class Response<T> {
    public static final int SUCCESS_CODE = 0;
    public static final int ERROR_CODE = 1;
    private T data;
    private ResultInfo result = new ResultInfo();

    public static <T> Response<T> buildResultFromTaskResult(TaskResult result, T data) {
        Response<T> response = new Response<T>();
        response.result.setCode(TaskResult.Result.SUCCESS.equals((Object)result.getResult()) ? 0 : 1);
        response.setData(data);
        if (response.isFailed()) {
            response.result.setDescription(result.getErrorLocaleDescription());
        }
        return response;
    }

    public static <T> Response<T> success(T data) {
        Response<T> response = new Response<T>();
        response.data = data;
        response.result.setCode(0);
        return response;
    }

    public static Response<Void> success() {
        Response<Void> response = new Response<Void>();
        response.result.setCode(0);
        return response;
    }

    public static <T> Response<T> fail(String msg) {
        Response<T> response = new Response<T>();
        response.result.setCode(1);
        response.result.setDescription(msg);
        return response;
    }

    public String getErrorMessage() {
        return this.result.getDescription();
    }

    @JsonIgnore
    public boolean isFailed() {
        return this.result.code == 1;
    }

    public T getData() {
        return this.data;
    }

    public ResultInfo getResult() {
        return this.result;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setResult(ResultInfo result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        ResultInfo this$result = this.getResult();
        ResultInfo other$result = other.getResult();
        return !(this$result == null ? other$result != null : !((Object)this$result).equals(other$result));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        ResultInfo $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : ((Object)$result).hashCode());
        return result;
    }

    public String toString() {
        return "Response(data=" + this.getData() + ", result=" + this.getResult() + ")";
    }

    public static class ResultInfo {
        private int code = -1;
        private String suggestion = "";
        private String description = "";

        public int getCode() {
            return this.code;
        }

        public String getSuggestion() {
            return this.suggestion;
        }

        public String getDescription() {
            return this.description;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public void setSuggestion(String suggestion) {
            this.suggestion = suggestion;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ResultInfo)) {
                return false;
            }
            ResultInfo other = (ResultInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$suggestion = this.getSuggestion();
            String other$suggestion = other.getSuggestion();
            if (this$suggestion == null ? other$suggestion != null : !this$suggestion.equals(other$suggestion)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ResultInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            String $suggestion = this.getSuggestion();
            result = result * 59 + ($suggestion == null ? 43 : $suggestion.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        public String toString() {
            return "Response.ResultInfo(code=" + this.getCode() + ", suggestion=" + this.getSuggestion() + ", description=" + this.getDescription() + ")";
        }
    }
}

