/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.model.entity.vo;

import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.ClusterNodeStatus;
import com.huawei.ism.tool.obase.enums.FsmRole;
import com.huawei.ism.tool.obase.enums.SandboxStatus;
import com.huawei.ism.tool.service.rest.model.entity.AuthClusterNode;
import com.huawei.ism.tool.service.rest.model.entity.BusinessDevice;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class ClusterNodeVO {
    private String name;
    private String manageIp;
    private Set<String> role;
    private String bmcIp;
    private String sn;
    private int id;
    private String status;
    private boolean hasFault;
    private String cabinet;
    private ClusterNode.BaseBoardType boardType;
    private SandboxStatus sandboxStatus;
    private AuthClusterNode.AuthStatusInfo osAuthInfo;
    private AuthClusterNode.AuthStatusInfo bmcAuthInfo;
    private boolean isFsmMaster;

    public ClusterNodeVO(ClusterNode node) {
        this.name = node.getName();
        this.manageIp = node.getManagementIp();
        this.role = node.getRoles();
        this.bmcIp = node.getBmcIp();
        this.sn = node.getSerialNumber();
        this.id = node.getId();
        this.status = node.getStatus().toString();
        this.hasFault = ClusterNodeStatus.STATUS_ABNORMAL.equals((Object)node.getStatus());
        this.cabinet = node.getCabinet();
        this.boardType = node.getBaseBoardType();
        this.sandboxStatus = node.getSandboxStatus();
        this.isFsmMaster = node.getFsmRole() == FsmRole.ACTIVE;
    }

    public ClusterNodeVO(AuthClusterNode node) {
        this(node.getNode());
        this.osAuthInfo = node.getOsAuthStatusInfo();
        this.bmcAuthInfo = node.getBmcAuthStatusInfo();
    }

    public static List<ClusterNodeVO> getClusterNodes(BusinessDevice node) {
        List<AuthClusterNode> nodes = node.getAuthClusterNodes();
        if (nodes == null) {
            return Collections.emptyList();
        }
        return nodes.stream().map(ClusterNodeVO::new).collect(Collectors.toList());
    }

    public String getName() {
        return this.name;
    }

    public String getManageIp() {
        return this.manageIp;
    }

    public Set<String> getRole() {
        return this.role;
    }

    public String getBmcIp() {
        return this.bmcIp;
    }

    public String getSn() {
        return this.sn;
    }

    public int getId() {
        return this.id;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isHasFault() {
        return this.hasFault;
    }

    public String getCabinet() {
        return this.cabinet;
    }

    public ClusterNode.BaseBoardType getBoardType() {
        return this.boardType;
    }

    public SandboxStatus getSandboxStatus() {
        return this.sandboxStatus;
    }

    public AuthClusterNode.AuthStatusInfo getOsAuthInfo() {
        return this.osAuthInfo;
    }

    public AuthClusterNode.AuthStatusInfo getBmcAuthInfo() {
        return this.bmcAuthInfo;
    }

    public boolean isFsmMaster() {
        return this.isFsmMaster;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setManageIp(String manageIp) {
        this.manageIp = manageIp;
    }

    public void setRole(Set<String> role) {
        this.role = role;
    }

    public void setBmcIp(String bmcIp) {
        this.bmcIp = bmcIp;
    }

    public void setSn(String sn) {
        this.sn = sn;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setHasFault(boolean hasFault) {
        this.hasFault = hasFault;
    }

    public void setCabinet(String cabinet) {
        this.cabinet = cabinet;
    }

    public void setBoardType(ClusterNode.BaseBoardType boardType) {
        this.boardType = boardType;
    }

    public void setSandboxStatus(SandboxStatus sandboxStatus) {
        this.sandboxStatus = sandboxStatus;
    }

    public void setOsAuthInfo(AuthClusterNode.AuthStatusInfo osAuthInfo) {
        this.osAuthInfo = osAuthInfo;
    }

    public void setBmcAuthInfo(AuthClusterNode.AuthStatusInfo bmcAuthInfo) {
        this.bmcAuthInfo = bmcAuthInfo;
    }

    public void setFsmMaster(boolean isFsmMaster) {
        this.isFsmMaster = isFsmMaster;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClusterNodeVO)) {
            return false;
        }
        ClusterNodeVO other = (ClusterNodeVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.isHasFault() != other.isHasFault()) {
            return false;
        }
        if (this.isFsmMaster() != other.isFsmMaster()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$manageIp = this.getManageIp();
        String other$manageIp = other.getManageIp();
        if (this$manageIp == null ? other$manageIp != null : !this$manageIp.equals(other$manageIp)) {
            return false;
        }
        Set<String> this$role = this.getRole();
        Set<String> other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)this$role).equals(other$role)) {
            return false;
        }
        String this$bmcIp = this.getBmcIp();
        String other$bmcIp = other.getBmcIp();
        if (this$bmcIp == null ? other$bmcIp != null : !this$bmcIp.equals(other$bmcIp)) {
            return false;
        }
        String this$sn = this.getSn();
        String other$sn = other.getSn();
        if (this$sn == null ? other$sn != null : !this$sn.equals(other$sn)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$cabinet = this.getCabinet();
        String other$cabinet = other.getCabinet();
        if (this$cabinet == null ? other$cabinet != null : !this$cabinet.equals(other$cabinet)) {
            return false;
        }
        ClusterNode.BaseBoardType this$boardType = this.getBoardType();
        ClusterNode.BaseBoardType other$boardType = other.getBoardType();
        if (this$boardType == null ? other$boardType != null : !((Object)((Object)this$boardType)).equals((Object)other$boardType)) {
            return false;
        }
        SandboxStatus this$sandboxStatus = this.getSandboxStatus();
        SandboxStatus other$sandboxStatus = other.getSandboxStatus();
        if (this$sandboxStatus == null ? other$sandboxStatus != null : !((Object)((Object)this$sandboxStatus)).equals((Object)other$sandboxStatus)) {
            return false;
        }
        AuthClusterNode.AuthStatusInfo this$osAuthInfo = this.getOsAuthInfo();
        AuthClusterNode.AuthStatusInfo other$osAuthInfo = other.getOsAuthInfo();
        if (this$osAuthInfo == null ? other$osAuthInfo != null : !((Object)this$osAuthInfo).equals(other$osAuthInfo)) {
            return false;
        }
        AuthClusterNode.AuthStatusInfo this$bmcAuthInfo = this.getBmcAuthInfo();
        AuthClusterNode.AuthStatusInfo other$bmcAuthInfo = other.getBmcAuthInfo();
        return !(this$bmcAuthInfo == null ? other$bmcAuthInfo != null : !((Object)this$bmcAuthInfo).equals(other$bmcAuthInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClusterNodeVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + (this.isHasFault() ? 79 : 97);
        result = result * 59 + (this.isFsmMaster() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $manageIp = this.getManageIp();
        result = result * 59 + ($manageIp == null ? 43 : $manageIp.hashCode());
        Set<String> $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)$role).hashCode());
        String $bmcIp = this.getBmcIp();
        result = result * 59 + ($bmcIp == null ? 43 : $bmcIp.hashCode());
        String $sn = this.getSn();
        result = result * 59 + ($sn == null ? 43 : $sn.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $cabinet = this.getCabinet();
        result = result * 59 + ($cabinet == null ? 43 : $cabinet.hashCode());
        ClusterNode.BaseBoardType $boardType = this.getBoardType();
        result = result * 59 + ($boardType == null ? 43 : ((Object)((Object)$boardType)).hashCode());
        SandboxStatus $sandboxStatus = this.getSandboxStatus();
        result = result * 59 + ($sandboxStatus == null ? 43 : ((Object)((Object)$sandboxStatus)).hashCode());
        AuthClusterNode.AuthStatusInfo $osAuthInfo = this.getOsAuthInfo();
        result = result * 59 + ($osAuthInfo == null ? 43 : ((Object)$osAuthInfo).hashCode());
        AuthClusterNode.AuthStatusInfo $bmcAuthInfo = this.getBmcAuthInfo();
        result = result * 59 + ($bmcAuthInfo == null ? 43 : ((Object)$bmcAuthInfo).hashCode());
        return result;
    }

    public String toString() {
        return "ClusterNodeVO(name=" + this.getName() + ", manageIp=" + this.getManageIp() + ", role=" + this.getRole() + ", bmcIp=" + this.getBmcIp() + ", sn=" + this.getSn() + ", id=" + this.getId() + ", status=" + this.getStatus() + ", hasFault=" + this.isHasFault() + ", cabinet=" + this.getCabinet() + ", boardType=" + (Object)((Object)this.getBoardType()) + ", sandboxStatus=" + (Object)((Object)this.getSandboxStatus()) + ", osAuthInfo=" + this.getOsAuthInfo() + ", bmcAuthInfo=" + this.getBmcAuthInfo() + ", isFsmMaster=" + this.isFsmMaster() + ")";
    }
}

