/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.model.entity.vo;

import com.huawei.ism.tool.service.rest.model.entity.BaseProduct;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ProductVO {
    private String productModel;
    private String productVersion;

    public static List<ProductVO> buildProductsInfo(List<? extends BaseProduct> baseProducts) {
        Map<String, List<BaseProduct>> moduleMap = baseProducts.stream().collect(Collectors.groupingBy(BaseProduct::getProductModel));
        return moduleMap.keySet().stream().map(module -> {
            List versions = ((List)moduleMap.get(module)).stream().map(BaseProduct::getProductVersion).collect(Collectors.toList());
            return ProductVO.builder().productModel((String)module).productVersion(String.join((CharSequence)",", versions)).build();
        }).collect(Collectors.toList());
    }

    ProductVO(String productModel, String productVersion) {
        this.productModel = productModel;
        this.productVersion = productVersion;
    }

    public static ProductVOBuilder builder() {
        return new ProductVOBuilder();
    }

    public String getProductModel() {
        return this.productModel;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductModel(String productModel) {
        this.productModel = productModel;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductVO)) {
            return false;
        }
        ProductVO other = (ProductVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$productModel = this.getProductModel();
        String other$productModel = other.getProductModel();
        if (this$productModel == null ? other$productModel != null : !this$productModel.equals(other$productModel)) {
            return false;
        }
        String this$productVersion = this.getProductVersion();
        String other$productVersion = other.getProductVersion();
        return !(this$productVersion == null ? other$productVersion != null : !this$productVersion.equals(other$productVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProductVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $productModel = this.getProductModel();
        result = result * 59 + ($productModel == null ? 43 : $productModel.hashCode());
        String $productVersion = this.getProductVersion();
        result = result * 59 + ($productVersion == null ? 43 : $productVersion.hashCode());
        return result;
    }

    public String toString() {
        return "ProductVO(productModel=" + this.getProductModel() + ", productVersion=" + this.getProductVersion() + ")";
    }

    public static class ProductVOBuilder {
        private String productModel;
        private String productVersion;

        ProductVOBuilder() {
        }

        public ProductVOBuilder productModel(String productModel) {
            this.productModel = productModel;
            return this;
        }

        public ProductVOBuilder productVersion(String productVersion) {
            this.productVersion = productVersion;
            return this;
        }

        public ProductVO build() {
            return new ProductVO(this.productModel, this.productVersion);
        }

        public String toString() {
            return "ProductVO.ProductVOBuilder(productModel=" + this.productModel + ", productVersion=" + this.productVersion + ")";
        }
    }
}

