/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.service.rest.query;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DiskTypeEnum;
import com.huawei.ism.tool.obase.entity.FusionStorStoragePool;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.protocol.rest.RestConnection;
import com.huawei.ism.tool.protocol.rest.RestConnectionManager;
import com.huawei.ism.tool.protocol.rest.entity.ResponseInfo;
import com.huawei.ism.tool.protocol.utils.RestUtil;
import com.huawei.ism.tool.service.common.DevInfoUtil;
import com.huawei.ism.tool.service.rest.model.entity.SwitchoverEnum;
import com.huawei.ism.tool.service.rest.model.enumz.Status;
import com.huawei.ism.tool.service.rest.query.INodePoolService;
import com.huawei.json.JSONArray;
import com.huawei.uMate.common.UMateException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class NodePoolService
implements INodePoolService {
    private static final Logger log = LoggerFactory.getLogger(NodePoolService.class);
    private static final String STORAGE_POOL_URI = "/dsware/service/resource/queryStoragePool";
    private static final String NODE_DISK_INFO_URI = "/dsware/service/cluster/storagepool/queryNodeDiskInfo";
    private static final String DISK_POOL_NODE_INFO_URL = "/dsware/service/cluster/diskpool/queryNodeDiskInfo";
    private static final String STORAGE_POOL_BASE_INFO_URI = "/dsware/service/resource/queryPoolBasicInfo";
    private static final String FAIL_BACK_WAITING_CODE = "540158032";
    private static final String FAIL_BACK_RUNNING_CODE = "33609812";
    private static final String FAIL_BACK_END_CODE = "540158039";
    private static final String SWITCHBACK_STATE = "540158053";
    private static final List<String> WAIT_CODE = Arrays.asList("540158032", "33609812", "540158053");

    @Override
    public List<FusionStorStoragePool> queryNodePool(DevNode devNode) throws ToolException {
        ResponseInfo responseInfo = this.getResponseInfo(devNode, "", STORAGE_POOL_URI);
        if (responseInfo.isSuccess()) {
            return this.parseContent(responseInfo.getContent());
        }
        return Collections.emptyList();
    }

    public List<FusionStorStoragePool> queryPoolsBasicInfo(DevNode devNode) throws ToolException {
        ResponseInfo responseInfo = this.getResponseInfo(devNode, "", STORAGE_POOL_BASE_INFO_URI);
        if (responseInfo.isSuccess()) {
            return this.parseContentFromBasicPools(responseInfo.getContent());
        }
        return Collections.emptyList();
    }

    private ResponseInfo getResponseInfo(DevNode devNode, String param, String uri) throws ToolException {
        RestConnection rest = RestConnectionManager.getRestConnection((DevNode)devNode);
        if (Objects.isNull(rest)) {
            throw new ToolException("get restConnection failed.");
        }
        String url = RestUtil.getDstorageUrlHead((DevNode)devNode) + uri;
        return rest.execGet(url, param);
    }

    @Override
    public String getNodeDiskInfo(String poolId, DevNode devNode, boolean isDiskPool) throws ToolException {
        ResponseInfo responseInfo = this.getResponseInfo(devNode, this.getQueryPoolNodeParam(isDiskPool, poolId), this.getQueryPoolNodeUrl(isDiskPool));
        if (responseInfo.isSuccess()) {
            JSONObject contentObject = JSON.parseObject((String)responseInfo.getContent());
            String result = contentObject.getString("result");
            if (!"0".equals(result)) {
                throw new ToolException(contentObject.getString("suggestion"));
            }
            return contentObject.getString("nodeInfo");
        }
        return "";
    }

    private String getQueryPoolNodeUrl(boolean isDiskPool) {
        return isDiskPool ? DISK_POOL_NODE_INFO_URL : NODE_DISK_INFO_URI;
    }

    private String getQueryPoolNodeParam(boolean isDiskPool, String poolId) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put(isDiskPool ? "diskPoolId" : "poolId", poolId);
        return JSON.toJSONString(param);
    }

    private List<FusionStorStoragePool> parseContent(String content) throws ToolException {
        ArrayList<FusionStorStoragePool> poolList = new ArrayList<FusionStorStoragePool>(12);
        JSONObject contentObject = JSON.parseObject((String)content);
        String result = contentObject.getString("result");
        if (!"0".equals(result)) {
            throw new ToolException(contentObject.getString("suggestion"));
        }
        com.alibaba.fastjson.JSONArray storagePools = JSON.parseArray((String)contentObject.getString("storagePools"));
        for (Object storagePool : storagePools) {
            JSONObject storageObject = JSON.parseObject((String)JSON.toJSONString(storagePool));
            FusionStorStoragePool fusionStorStoragePool = new FusionStorStoragePool();
            fusionStorStoragePool.setId(storageObject.getString("poolId"));
            fusionStorStoragePool.setName(storageObject.getString("poolName"));
            fusionStorStoragePool.setStatus("poolStatus");
            poolList.add(fusionStorStoragePool);
        }
        return poolList;
    }

    private List<FusionStorStoragePool> parseContentFromBasicPools(String content) throws ToolException {
        JSONObject contentObject = JSON.parseObject((String)content);
        if (!"0".equals(contentObject.getString("result"))) {
            log.error("Failed to query the basic information about the storage pool.");
            throw new ToolException(contentObject.getString("suggestion"));
        }
        com.alibaba.fastjson.JSONArray storagePools = JSON.parseArray((String)contentObject.getString("pools"));
        return storagePools.stream().map(this::buildFusionStorStoragerPool).collect(Collectors.toList());
    }

    private FusionStorStoragePool buildFusionStorStoragerPool(Object storagePool) {
        JSONObject storageObject = JSON.parseObject((String)JSON.toJSONString((Object)storagePool));
        FusionStorStoragePool fusionStorStoragePool = new FusionStorStoragePool();
        fusionStorStoragePool.setId(storageObject.getString("poolId"));
        fusionStorStoragePool.setStoragePoolId(storageObject.getString("storagePoolId"));
        fusionStorStoragePool.setName(storageObject.getString("poolName"));
        fusionStorStoragePool.setStatus(storageObject.getString("poolStatus"));
        this.setDiskType(fusionStorStoragePool, storageObject);
        return fusionStorStoragePool;
    }

    private void setDiskType(FusionStorStoragePool fusionStorStoragePool, JSONObject storageObject) {
        String encryptType = storageObject.getString("supportEncryptForMainStorageMedia");
        String mainStorageMedia = this.getMainStorageMedia(storageObject, encryptType);
        this.setMainStorage(fusionStorStoragePool, encryptType, DiskTypeEnum.getDiskType(mainStorageMedia));
        DiskTypeEnum cacheMediaType = DiskTypeEnum.getDiskType(storageObject.getString("cacheMediaType"));
        this.setCacheStorage(fusionStorStoragePool, cacheMediaType);
    }

    private String getMainStorageMedia(JSONObject storageObject, String encryptType) {
        String mainStorageMedia = storageObject.getString("storageMediaType");
        if (!DiskTypeEnum.SSD_CARD_AND_NVME_SSD.getDiskType().equals(mainStorageMedia)) {
            return mainStorageMedia;
        }
        mainStorageMedia = Objects.equals(storageObject.getString("zeroOPDiskPoolFlag"), "1") ? mainStorageMedia + "_zero_op" : (this.isQlcDisk(storageObject) ? mainStorageMedia + "_qlc" : mainStorageMedia + "_normal");
        if (DiskTypeEnum.ENCRYPT.getDiskType().equals(encryptType)) {
            mainStorageMedia = mainStorageMedia + "_encrypted";
        }
        return mainStorageMedia;
    }

    private boolean isQlcDisk(JSONObject storageObject) {
        com.alibaba.fastjson.JSONArray subTypes = storageObject.getJSONArray("subTypes");
        return subTypes != null && subTypes.contains((Object)2);
    }

    private void setCacheStorage(FusionStorStoragePool fusionStorStoragePool, DiskTypeEnum cacheMediaType) {
        if (DiskTypeEnum.UNKNOWN.equals((Object)cacheMediaType)) {
            return;
        }
        fusionStorStoragePool.setCacheMediaType(cacheMediaType.toString());
    }

    private void setMainStorage(FusionStorStoragePool fusionStorStoragePool, String encryptType, DiskTypeEnum storageMediaType) {
        if (DiskTypeEnum.UNKNOWN.equals((Object)storageMediaType)) {
            return;
        }
        String encryptDisType = DiskTypeEnum.ENCRYPT.getDiskType();
        if (DiskTypeEnum.SAS.equals((Object)storageMediaType) && encryptDisType.equals(encryptType)) {
            fusionStorStoragePool.setStorageMediaType(DiskTypeEnum.SAS_ENCRYPTED.toString());
        } else if (DiskTypeEnum.SATA.equals((Object)storageMediaType) && encryptDisType.equals(encryptType)) {
            fusionStorStoragePool.setStorageMediaType(DiskTypeEnum.SATA_ENCRYPTED.toString());
        } else {
            fusionStorStoragePool.setStorageMediaType(storageMediaType.toString());
        }
    }

    @Override
    public boolean updateNodePools(DevNode devNode) {
        List<ClusterNode> clusterNodes = devNode.getClusterNodes();
        if (CollectionUtil.isEmpty(clusterNodes)) {
            log.error("Cluster nodes empty.");
            return false;
        }
        Map<String, ClusterNode> map = clusterNodes.stream().collect(Collectors.toMap(ClusterNode::getManagementIp, ele -> ele, (firstNode, secondNode) -> firstNode));
        try {
            List<FusionStorStoragePool> nodePool = this.queryNodePool(devNode);
            devNode.getStoragePools().addAll(nodePool);
            for (FusionStorStoragePool fusionStorStoragePool : nodePool) {
                this.setPools(devNode, map, fusionStorStoragePool);
            }
            return true;
        }
        catch (ToolException e) {
            log.error("Query storage pools failed.", (Throwable)e);
            return false;
        }
    }

    private void setPools(DevNode devNode, Map<String, ClusterNode> map, FusionStorStoragePool fusionStorStoragePool) throws ToolException {
        String nodeDiskInfo = this.getNodeDiskInfo(fusionStorStoragePool.getId(), devNode, false);
        com.alibaba.fastjson.JSONArray jsonArray = JSON.parseArray((String)nodeDiskInfo);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (!"0".equals(jsonObject.getString("errorCode"))) {
                log.info("node query failed");
                continue;
            }
            String ip = jsonObject.getString("nodeMgrIp");
            ClusterNode clusterNode = map.get(ip);
            if (!Objects.nonNull(clusterNode)) continue;
            clusterNode.setJoinedStoragePool(fusionStorStoragePool);
        }
    }

    public Map<String, List<String>> getDiskIdMap(DevNode devNode, List<String> managerIps) throws ToolException {
        HashMap<String, List<String>> poolIdToNodeIp = new HashMap<String, List<String>>();
        log.info("Start to search for the disk pool ID of the node.");
        if (DevInfoUtil.isSupportDiskPool(devNode)) {
            this.queryDiskPools(devNode).forEach(diskPool -> poolIdToNodeIp.put(diskPool.getId(), this.getNodeIpFromPools(managerIps, (FusionStorStoragePool)diskPool, devNode, true)));
            return poolIdToNodeIp;
        }
        this.queryStorPools(devNode).forEach(storPool -> poolIdToNodeIp.put(storPool.getId(), this.getNodeIpFromPools(managerIps, (FusionStorStoragePool)storPool, devNode, false)));
        return poolIdToNodeIp;
    }

    private List<FusionStorStoragePool> queryDiskPools(DevNode devNode) throws ToolException {
        return DevInfoUtil.isSupportDiskPool(devNode) ? this.queryPoolsBasicInfo(devNode) : Collections.emptyList();
    }

    private List<FusionStorStoragePool> queryStorPools(DevNode devNode) throws ToolException {
        return DevInfoUtil.isSupportDiskPool(devNode) ? this.queryNodePool(devNode) : this.queryPoolsBasicInfo(devNode);
    }

    private List<String> getNodeIpFromPools(List<String> managerIps, FusionStorStoragePool storPool, DevNode devNode, boolean isDiskPool) {
        try {
            String response = this.getNodeDiskInfo(storPool.getId(), devNode, isDiskPool);
            return this.getMatchNodeInfo(managerIps, response);
        }
        catch (ToolException e) {
            log.error("query pool node disk failed.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private List<String> getMatchNodeInfo(List<String> managerIps, String response) {
        com.alibaba.fastjson.JSONArray nodesFromPools = JSON.parseArray((String)response);
        return nodesFromPools.stream().filter(nodeObject -> nodeObject instanceof JSONObject).map(nodeObject -> (JSONObject)nodeObject).map(node -> node.getString("nodeMgrIp")).filter(managerIps::contains).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static boolean isVnodeEcPool(RestConnection restConn, String cmd, String poolId) throws UMateException {
        if (StringUtils.isNULLStr(poolId)) {
            return false;
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("poolId", poolId);
            ResponseInfo restResponse = restConn.execGet(cmd, params);
            if (!"vnode".equals(NodePoolService.getSecurityLevel(restResponse.getContent()))) {
                log.info("The current disk pool is not a vnode disk pool. {}", (Object)restResponse);
                return false;
            }
        }
        catch (ToolException e) {
            log.error("Failed to query the disk pool type.", (Throwable)e);
            throw new UMateException(ResourceUtil.getString("http.connection.error.tool.exception"));
        }
        return true;
    }

    private static String getSecurityLevel(String restResponse) throws UMateException {
        JSONArray pools = new com.huawei.json.JSONObject(restResponse).getJSONArray("pools");
        if (Objects.isNull(pools)) {
            log.error("Failed to parse the JSON character string.");
            throw new UMateException(ResourceUtil.getString("http.connection.error.tool.exception"));
        }
        return IntStream.range(0, pools.length()).mapToObj(arg_0 -> ((JSONArray)pools).getJSONObject(arg_0)).filter(pool -> "true".equals(pool.getStringOrDefault("ecpool", ""))).map(json -> json.get("securityLevel").toString()).findFirst().orElse("");
    }

    public static boolean switchoverNode(RestConnection restConn, String cmd, String mgrIp) throws UMateException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("faultRecoverIp", mgrIp);
        params.put("force", "0");
        long currentTimeMills = System.currentTimeMillis();
        while (System.currentTimeMillis() - currentTimeMills < 120000L) {
            try {
                ResponseInfo restResponse = restConn.execPost(cmd, params);
                String result = new com.huawei.json.JSONObject(restResponse.getContent()).get("result").toString();
                if ("0".equals(result)) {
                    return true;
                }
                ConnUtils.sleep(5000);
            }
            catch (Exception e) {
                log.info("DSMWeb not ready try again");
                ConnUtils.sleep(5000);
                try {
                    restConn.reLogin();
                }
                catch (ToolException ex) {
                    log.info("login error try again");
                }
            }
        }
        log.error("Failed to execute the command {}.", (Object)cmd);
        throw new UMateException(ResourceUtil.getString("http.connection.error.tool.exception"));
    }

    public static boolean switchbackNode(RestConnection restConn, String cmd, String mgrIp) throws UMateException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("faultRecoverIp", mgrIp);
        params.put("force", "0");
        try {
            for (int index = 0; index < 15; ++index) {
                ResponseInfo restResponse = restConn.execPost(cmd, params);
                com.huawei.json.JSONObject responseInfo = new com.huawei.json.JSONObject(restResponse.getContent());
                String result = responseInfo.get("result").toString();
                if ("0".equals(result)) {
                    return true;
                }
                String errorCode = responseInfo.get("errorCode").toString();
                if (!WAIT_CODE.contains(errorCode)) {
                    if (FAIL_BACK_END_CODE.equals(errorCode)) {
                        return true;
                    }
                    throw new UMateException(responseInfo.get("suggestion").toString());
                }
                Thread.sleep(60000L);
                log.info("Retry to switch back times: {}", (Object)(index + 1));
            }
        }
        catch (ToolException | InterruptedException e) {
            log.error("Failed to start the switchback task.", (Throwable)e);
            throw new UMateException(ResourceUtil.getString("http.connection.error.tool.exception"));
        }
        log.error("Failed to start the switchback task timed out.");
        return false;
    }

    public static boolean taskIsCompleted(RestConnection restConn, SwitchoverEnum switchoverEnum, String cmd) throws UMateException {
        String taskId = NodePoolService.getTaskIdByTaskName(restConn, switchoverEnum, cmd);
        if (StringUtils.isNULLStr(taskId)) {
            throw new UMateException(ResourceUtil.getStringWithParams("no.task.error", switchoverEnum.getKeyOfEn()));
        }
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < 600000L) {
            String status = NodePoolService.getTaskStatusByTaskId(restConn, taskId, cmd);
            if (StringUtils.isNULLStr(status)) {
                throw new UMateException(ResourceUtil.getStringWithParams("no.task.error", switchoverEnum.getKeyOfEn()));
            }
            if (Status.WAITING.toString().equalsIgnoreCase(status)) {
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (InterruptedException e) {
                    log.error("An exception occurred when querying the switchover or switchback task.");
                    throw new UMateException(ResourceUtil.getString("unknown.exception.occurred"));
                }
            }
            if (Status.FAILED.toString().equalsIgnoreCase(status)) {
                return false;
            }
            if (!Status.SUCCESS.toString().equalsIgnoreCase(status)) continue;
            return true;
        }
        throw new UMateException(ResourceUtil.getString("no.task.time.out"));
    }

    private static String getTaskStatusByTaskId(RestConnection connection, String taskId, String cmd) throws UMateException {
        ResponseInfo response = NodePoolService.getResponse(connection, cmd);
        if (!response.isSuccess()) {
            return "";
        }
        JSONArray taskInfos = NodePoolService.getTaskInfos(response);
        return IntStream.range(0, taskInfos.length()).mapToObj(arg_0 -> ((JSONArray)taskInfos).getJSONObject(arg_0)).filter(taskInfo -> taskId.equals(taskInfo.get("taskId").toString())).map(taskInfo -> taskInfo.get("taskStatus").toString()).findFirst().orElse("");
    }

    private static String getTaskIdByTaskName(RestConnection restConn, SwitchoverEnum switchoverEnum, String cmd) throws UMateException {
        ResponseInfo response = NodePoolService.getResponse(restConn, cmd);
        if (!response.isSuccess()) {
            return "";
        }
        JSONArray taskInfos = NodePoolService.getTaskInfos(response);
        return IntStream.range(0, taskInfos.length()).mapToObj(arg_0 -> ((JSONArray)taskInfos).getJSONObject(arg_0)).filter(taskInfo -> NodePoolService.isSwitchoverTask(switchoverEnum, taskInfo)).map(taskInfo -> taskInfo.get("taskId").toString()).findFirst().orElse("");
    }

    private static JSONArray getTaskInfos(ResponseInfo response) {
        return new com.huawei.json.JSONObject(response.getContent()).getJSONArray("taskInfo");
    }

    private static boolean isSwitchoverTask(SwitchoverEnum switchoverEnum, com.huawei.json.JSONObject jsonObject) {
        String taskName = jsonObject.get("taskName").toString();
        return switchoverEnum.getKeyOfZh().equals(taskName) || switchoverEnum.getKeyOfEn().equals(taskName);
    }

    private static ResponseInfo getResponse(RestConnection restConn, String cmd) throws UMateException {
        ResponseInfo restResponse;
        try {
            restResponse = restConn.execGet(cmd);
        }
        catch (ToolException e) {
            log.error("Failed to execute the command {}.", (Object)cmd, (Object)e);
            throw new UMateException(ResourceUtil.getString("http.connection.error.tool.exception"));
        }
        return restResponse;
    }
}

